package net.dreamlu.boot.support;

import net.dreamlu.tool.util.StringEscapeEditor;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;

/**
 * xss 处理，为了能多继承
 */
public interface XssController {

	@InitBinder
	default void initBinder(ServletRequestDataBinder binder) {
		/**
		 * 防止XSS攻击
		 */
		binder.registerCustomEditor(String.class, new StringEscapeEditor());
	}
}
