package net.dreamlu.boot.result;

/**
 * 结果集返回工具
 *
 * @author L.cm
 */
public class Results {
	private final static int FAILURE = 0;
	private final static int SUCCESS = 1;

	/**
	 * 数据库操作结果
	 * @param status 数据库操作结果
	 * @param <T> 泛型标记
	 * @return Result
	 */
	public static <T> Result<T> status(boolean status) {
		return status ? Results.success() : Results.failure();
	}

	/**
	 * 成功-携带数据
	 * @param data 数据
	 * @param <T> 泛型标记
	 * @return Result
	 */
	public static <T> Result<T> success(T data) {
		return result(SUCCESS, "操作成功", data);
	}

	/**
	 * 返回成功
	 * @param <T> 泛型标记
	 * @return Result
	 */
	public static <T> Result<T> success() {
		return success(null);
	}

	/**
	 * 返回失败信息
	 * @param msg 失败信息
	 * @param <T> 泛型标记
	 * @return Result
	 */
	public static <T> Result<T> failure(String msg) {
		return result(FAILURE, msg);
	}

	/**
	 * 返回失败信息
	 * @param <T> 泛型标记
	 * @return Result
	 */
	public static <T> Result<T> failure() {
		return failure("操作失败");
	}

	private static <T> Result<T> result(int code, String msg) {
		return result(code, msg, null);
	}

	private static <T> Result<T> result(int code, String msg, T data) {
		Result<T> result = new Result<>();
		result.setCode(code);
		result.setMsg(msg);
		if (data != null) {
			result.setData(data);
		}
		return result;
	}
}
