package net.dreamlu.boot.properties;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

@Getter
@Setter
@ConfigurationProperties("dream.swagger")
public class DreamSwaggerProperties {
	/**
	 * 组名
	 */
	private String name;
	/**
	 * 标题
	 */
	private String title;
	/**
	 * 详情
	 */
	private String description;
	/**
	 * 版本号
	 */
	private String version;
	/**
	 * 组织名，默认：Dream
	 */
	private String contactUser = "Dream";
	/**
	 * 组织url，默认：https://www.d.com
	 */
	private String contactUrl = "https://www.dreamlu.net/";
	/**
	 * 组织邮箱，默认：aisp@mail.chehejia.com
	 */
	private String contactEmail = "596392912@qq.com";
}
