package net.dreamlu.boot.properties;

import lombok.Getter;
import lombok.Setter;
import net.dreamlu.tool.util.DateUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 格式化配置
 *
 * @author L.cm
 */
@ConfigurationProperties("dream.fmt")
public class DreamFmtProperties {

	/**
	 * 数字格式化，默认：#.00
	 */
	@Getter
	@Setter
	private String numPattern = "#.00";
	/**
	 * Date 日期格式化，默认："yyyy-MM-dd HH:mm:ss"
	 */
	@Getter
	@Setter
	private String datePattern = DateUtils.PATTERN_DATETIME;
	/**
	 * java8 LocalTime时间格式化，默认："HH:mm:ss"
	 */
	@Getter
	@Setter
	private String ltimePattern = DateUtils.PATTERN_TIME;
	/**
	 * java8 LocalDate日期格式化，默认："yyyy-MM-dd"
	 */
	@Getter
	@Setter
	private String ldatePattern = DateUtils.PATTERN_DATE;
	/**
	 * java8 LocalDateTime日期时间格式化，默认："yyyy-MM-dd HH:mm:ss"
	 */
	@Getter
	@Setter
	private String ldateTimePattern = DateUtils.PATTERN_DATETIME;

}
