package net.dreamlu.boot.properties;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.ArrayList;
import java.util.List;

@ConfigurationProperties("dream.cross")
public class DreamCrossProperties {

	@Getter
	private final Jsonp jsonp = new Jsonp();
	@Getter
	private final Cors cors = new Cors();

	/**
	 * jsonp跨域配置
	 */
	@Getter
	@Setter
	public static class Jsonp {
		/**
		 * 开启jsonp，默认：false
		 */
		private boolean enabled = false;
	}

	/**
	 * Cors跨域
	 */
	@Getter
	@Setter
	public static class Cors {
		/**
		 * 开启cors，默认：false
		 */
		private boolean enabled = false;
		/**
		 * cors mapping，默认：/**
		 */
		private String mapping = "/**";
		/**
		 * list of origins. '*' allows all. not set,CORS support is disabled.
		 */
		private final List<String> allowedOrigins = new ArrayList<>();
		/**
		 * list of methods. '*' allows all. defaults to GET.
		 */
		private final List<String> allowedMethods = new ArrayList<>();
		/**
		 * list of headers. '*' allows all.
		 */
		private final List<String> allowedHeaders = new ArrayList<>();
		/**
		 * list of headers to include in a response.
		 */
		private final List<String> exposedHeaders = new ArrayList<>();
		/**
		 * Whether credentials are supported. When not set, credentials are not supported.
		 */
		private Boolean allowCredentials;
		/**
		 * 时长，默认：30 分钟
		 */
		private long maxAge = 1800L;
	}
}
