package net.dreamlu.boot.func;

import net.dreamlu.boot.properties.DreamFmtProperties;
import net.dreamlu.tool.util.DateUtils;

import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

/**
 * 内置函数
 *
 * 提供给 tpl 和 Thymeleaf 使用
 *
 * @author L.cm
 */
public class FmtFunc {
	private final DreamFmtProperties fmtProperties;

	public FmtFunc(DreamFmtProperties fmtProperties) {
		this.fmtProperties = fmtProperties;
	}

	/**
	 * 对象格式化
	 * @param object 格式化对象
	 * @return 格式化后的字符串
	 */
	public String format(Object object) {
		if (object instanceof Number) {
			return format(object, fmtProperties.getNumPattern());
		} else if (object instanceof Date) {
			return format(object, fmtProperties.getDatePattern());
		} else if (object instanceof LocalTime) {
			return format(object, fmtProperties.getLtimePattern());
		} else if (object instanceof LocalDate) {
			return format(object, fmtProperties.getLdatePattern());
		} else if (object instanceof LocalDateTime) {
			return format(object, fmtProperties.getLdateTimePattern());
		}
		throw new RuntimeException("未支持的对象格式" + object);
	}

	/**
	 * 对象格式化
	 * @param object 格式化对象
	 * @param pattern 表达式
	 * @return 格式化后的字符串
	 */
	public String format(Object object, String pattern) {
		if (object instanceof Number) {
			DecimalFormat decimalFormat = new DecimalFormat(pattern);
			return decimalFormat.format(object);
		} else if (object instanceof Date) {
			return DateUtils.format((Date) object, pattern);
		} else if (object instanceof TemporalAccessor) {
			DateTimeFormatter df = DateTimeFormatter.ofPattern(pattern);
			return df.format((TemporalAccessor) object);
		}
		throw new RuntimeException("未支持的对象格式" + object);
	}

}
