package net.dreamlu.boot.exception;

import lombok.Getter;

/**
 * 业务异常
 *
 * @author L.cm
 */
public class ServiceException extends RuntimeException {
	private static final long serialVersionUID = 2359767895161832954L;

	@Getter
	private final Integer code;

	public ServiceException(Integer code, String message, Throwable cause) {
		super(message, cause);
		this.code = code;
	}

	public ServiceException(Integer code, String message) {
		super(message);
		this.code = code;
	}

	public ServiceException(Integer code, Throwable cause) {
		super(cause);
		this.code = code;
	}

	@Override
	public Throwable fillInStackTrace() {
		return this;
	}

}
