package net.dreamlu.boot.exception;

import lombok.Getter;

/**
 * 本地化的异常信息
 *
 * @author L.cm
 */
public class LocalizedException extends RuntimeException {
	@Getter
	private final Object[] localeArgs;
	@Getter
	private final String localeMessage;

	public LocalizedException(String localeMessage, String message) {
		super(message);
		this.localeArgs = new Object[0];
		this.localeMessage = localeMessage;
	}

	public LocalizedException(String localeMessage, Object[] localeArgs, String message) {
		super(message);
		this.localeArgs = localeArgs;
		this.localeMessage = localeMessage;
	}

	@Override
	public Throwable fillInStackTrace() {
		return null;
	}

	public Throwable doFillInStackTrace() {
		return super.fillInStackTrace();
	}

}
