package net.dreamlu.boot.error;

import lombok.extern.slf4j.Slf4j;
import net.dreamlu.boot.result.Result;
import net.dreamlu.boot.result.Results;
import net.dreamlu.tool.util.BeanUtils;
import org.springframework.boot.autoconfigure.web.DefaultErrorAttributes;
import org.springframework.web.context.request.RequestAttributes;

import java.util.Map;

/**
 * 全局异常处理
 *
 * @author L.cm
 */
@Slf4j
public class DreamErrorAttributes extends DefaultErrorAttributes {

	private final ExceptionTranslator exceptionTranslator;

	public DreamErrorAttributes(ExceptionTranslator exceptionTranslator) {
		this.exceptionTranslator = exceptionTranslator;
	}

	@Override
	@SuppressWarnings("unchecked")
	public Map<String, Object> getErrorAttributes(RequestAttributes requestAttributes, boolean includeStackTrace) {
		Throwable error = getError(requestAttributes);
		Result<Object> result;
		if (error == null) {
			Integer status = getAttribute(requestAttributes, "javax.servlet.error.status_code");
			result = Results.failure(String.valueOf(status));
		} else {
			String message = exceptionTranslator.handle(error);
			result = Results.failure(message);
		}
		return BeanUtils.toMap(result);
	}

	@SuppressWarnings("unchecked")
	private <T> T getAttribute(RequestAttributes requestAttributes, String name) {
		return (T) requestAttributes.getAttribute(name, RequestAttributes.SCOPE_REQUEST);
	}
}
