package net.dreamlu.boot.config;

import org.hibernate.validator.HibernateValidator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.context.MessageSourceAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@AutoConfigureAfter(MessageSourceAutoConfiguration.class)
public class ValidatorConfiguration extends WebMvcConfigurerAdapter {

	private final MessageSourceAutoConfiguration messageSourceAutoConfiguration;

	public ValidatorConfiguration(MessageSourceAutoConfiguration messageSourceAutoConfiguration) {
		this.messageSourceAutoConfiguration = messageSourceAutoConfiguration;
	}

	/**
	 * 配置 HibernateValidator 国际化
	 * @return Validator
	 */
	@Override
	public Validator getValidator() {
		LocalValidatorFactoryBean validator = new LocalValidatorFactoryBean();
		validator.setProviderClass(HibernateValidator.class);
		ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
		messageSource.setBasename("classpath:messages/ValidationMessages");
		messageSource.setCacheSeconds(messageSourceAutoConfiguration.getCacheSeconds());
		messageSource.setDefaultEncoding(messageSourceAutoConfiguration.getEncoding().name());
		messageSource.setAlwaysUseMessageFormat(messageSourceAutoConfiguration.isAlwaysUseMessageFormat());
		messageSource.setFallbackToSystemLocale(messageSourceAutoConfiguration.isFallbackToSystemLocale());
		validator.setValidationMessageSource(messageSource);
		return validator;
	}
}
