package net.dreamlu.boot.config;

import io.swagger.annotations.Api;
import net.dreamlu.boot.properties.DreamSwaggerProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import springfox.bean.validators.configuration.BeanValidatorPluginsConfiguration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.configuration.Swagger2DocumentationConfiguration;

/**
 * Swagger2配置
 *
 * @author L.cm
 */
@Configuration
@ConditionalOnClass(Swagger2DocumentationConfiguration.class)
@Import({
	Swagger2DocumentationConfiguration.class,
	BeanValidatorPluginsConfiguration.class
})
@AutoConfigureAfter(DreamSwaggerProperties.class)
public class SwaggerConfiguration {
	private final DreamSwaggerProperties properties;

	public SwaggerConfiguration(DreamSwaggerProperties properties) {
		this.properties = properties;
	}

	@Bean
	public Docket createRestApi() {
		return new Docket(DocumentationType.SWAGGER_2)
			.groupName(properties.getName())
			.apiInfo(apiInfo()).select()
			.apis(RequestHandlerSelectors.withClassAnnotation(Api.class))
			.paths(PathSelectors.any())
			.build();
	}

	private ApiInfo apiInfo() {
		return new ApiInfoBuilder()
			.title(properties.getTitle())
			.description(properties.getDescription())
			.version(properties.getVersion())
			.contact(new Contact(properties.getContactUser(), properties.getContactUrl(), properties.getContactEmail()))
			.build();
	}
}
