package net.dreamlu.boot.config;

import net.dreamlu.boot.properties.DreamProperties;
import net.dreamlu.tool.captcha.DreamCaptcha;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 验证码配置
 *
 * @author L.cm
 */
@Configuration
@ConditionalOnWebApplication
@AutoConfigureAfter(DreamProperties.class)
@ConditionalOnProperty(value = "dream.captcha.enabled", havingValue = "true", matchIfMissing = true)
public class CaptchaConfiguration {

	private final DreamProperties dreamProperties;

	public CaptchaConfiguration(DreamProperties dreamProperties) {
		this.dreamProperties = dreamProperties;
	}

	@Bean
	public DreamCaptcha dreamCaptcha(CacheManager cacheManager) {
		DreamCaptcha captcha = new DreamCaptcha(cacheManager);
		captcha.setCacheName(dreamProperties.getCaptcha().getCacheName());
		captcha.setCookieName(dreamProperties.getCaptcha().getCookieName());
		return captcha;
	}
}
