/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.template;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.dreamlu.boot.exception.LocalizedException;
import net.dreamlu.boot.properties.DreamProperties;
import net.dreamlu.boot.template.DreamConsole;
import net.dreamlu.tool.util.FileUtils;
import net.dreamlu.tool.util.Try;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ResourceUtils;

public class DreamTemplate
implements InitializingBean {
    private final ConcurrentMap<String, String> tplCache = new ConcurrentHashMap<String, String>();
    private final Function<String, String> tplFunction = Try.of(x -> {
        File tplFile = ResourceUtils.getFile((String)x);
        return FileUtils.readToString((File)tplFile);
    });
    private final DreamProperties dreamProperties;
    private ScriptEngine engine;
    private DreamConsole console;

    public DreamTemplate(DreamProperties dreamProperties) {
        this.dreamProperties = dreamProperties;
        this.console = new DreamConsole();
    }

    public String renderTpl(String tplName, Object data) {
        if (tplName.startsWith("/")) {
            tplName = tplName.substring(1);
        }
        DreamProperties.Tpl tpl = this.dreamProperties.getTpl();
        String tplPath = tpl.getPrefix() + tplName;
        try {
            String html = tpl.isCache() ? this.tplCache.computeIfAbsent(tplPath, this.tplFunction) : this.tplFunction.apply(tplPath);
            return this._render(html, data);
        }
        catch (ScriptException e) {
            throw new LocalizedException("error.tpl.Script", e.getMessage());
        }
        catch (Exception e) {
            throw new LocalizedException("error.tpl.FileNotFound", e.getMessage());
        }
    }

    public String render(String html, Object data) {
        try {
            return this._render(html, data);
        }
        catch (ScriptException e) {
            throw new LocalizedException("error.tpl.Script", e.getMessage());
        }
    }

    private String _render(String html, Object data) throws ScriptException {
        Bindings bindings = this.engine.createBindings();
        bindings.put("_html_", (Object)html);
        bindings.put("data", data);
        return (String)this.engine.eval("laytpl(_html_).render(data);", bindings);
    }

    public void afterPropertiesSet() throws Exception {
        ScriptEngineManager engineManager = new ScriptEngineManager();
        ScriptEngine engine = engineManager.getEngineByMimeType("text/javascript");
        Bindings bindings = engine.createBindings();
        try (InputStream input = DreamTemplate.class.getResourceAsStream("laytpl.js");
             BufferedReader reader = new BufferedReader(new InputStreamReader(input));){
            HashMap<String, String> config = new HashMap<String, String>();
            DreamProperties.Tpl tpl = this.dreamProperties.getTpl();
            config.put("open", tpl.getOpen());
            config.put("close", tpl.getClose());
            bindings.put("console", (Object)this.console);
            bindings.put("_config", (Object)config);
            engine.setBindings(bindings, 200);
            engine.eval((Reader)reader, bindings);
            this.engine = engine;
        }
        this.engine.eval("console.log('DreamTpl init, laytpl version:{}', laytpl.v);");
    }
}

