/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.error;

import java.util.Locale;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import net.dreamlu.boot.exception.LocalizedException;
import net.dreamlu.tool.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.MediaType;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.servlet.NoHandlerFoundException;

public class ExceptionTranslator {
    private static final Logger log = LoggerFactory.getLogger(ExceptionTranslator.class);
    private final MessageSource messageSource;

    public ExceptionTranslator(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public String handle(Throwable error) {
        Locale locale = LocaleContextHolder.getLocale();
        Throwable _error = Exceptions.unwrap((Throwable)error);
        return this.handleException(_error, locale);
    }

    protected String handleException(Throwable error, Locale locale) {
        String message = null;
        message = error instanceof MissingServletRequestParameterException ? this.handleError((MissingServletRequestParameterException)error, locale) : (error instanceof MethodArgumentNotValidException ? this.handleError((MethodArgumentNotValidException)error) : (error instanceof BindException ? this.handleError((BindException)error) : (error instanceof ConstraintViolationException ? this.handleError((ConstraintViolationException)error) : (error instanceof NoHandlerFoundException ? this.handleError((NoHandlerFoundException)error, locale) : (error instanceof HttpRequestMethodNotSupportedException ? this.handleError((HttpRequestMethodNotSupportedException)error, locale) : (error instanceof HttpMediaTypeNotSupportedException ? this.handleError((HttpMediaTypeNotSupportedException)error, locale) : (error instanceof LocalizedException ? this.handleError((LocalizedException)error, locale) : this.handleError(error, locale))))))));
        if (null == message) {
            message = error.getClass().getSimpleName();
        }
        return message;
    }

    protected String handleError(MissingServletRequestParameterException e, Locale locale) {
        log.error("\u7f3a\u5c11\u8bf7\u6c42\u53c2\u6570", (Throwable)e);
        String parameterName = e.getParameterName();
        String parameterType = e.getParameterType();
        return this.getMessage((Throwable)e, locale, new Object[]{parameterName, parameterType});
    }

    protected String handleError(MethodArgumentNotValidException e) {
        log.error("\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25", (Throwable)e);
        BindingResult result = e.getBindingResult();
        FieldError error = result.getFieldError();
        return error.getDefaultMessage();
    }

    protected String handleError(BindException e) {
        log.error("\u53c2\u6570\u7ed1\u5b9a\u5931\u8d25", (Throwable)e);
        BindingResult result = e.getBindingResult();
        FieldError error = result.getFieldError();
        return error.getDefaultMessage();
    }

    protected String handleError(ConstraintViolationException e) {
        log.error("\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25", (Throwable)e);
        Set violations = e.getConstraintViolations();
        ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
        return violation.getMessage();
    }

    protected String handleError(NoHandlerFoundException e, Locale locale) {
        log.error("404\u6ca1\u627e\u5230\u8bf7\u6c42", (Throwable)e);
        String httpMethod = e.getHttpMethod();
        String requestURL = e.getRequestURL();
        return this.getMessage((Throwable)e, locale, new Object[]{httpMethod, requestURL});
    }

    protected String handleError(HttpRequestMethodNotSupportedException e, Locale locale) {
        log.error("\u4e0d\u652f\u6301\u5f53\u524d\u8bf7\u6c42\u65b9\u6cd5", (Throwable)e);
        String method = e.getMethod();
        return this.getMessage((Throwable)e, locale, new Object[]{method});
    }

    protected String handleError(HttpMediaTypeNotSupportedException e, Locale locale) {
        log.error("\u4e0d\u652f\u6301\u5f53\u524d\u5a92\u4f53\u7c7b\u578b", (Throwable)e);
        MediaType contentType = e.getContentType();
        return this.getMessage((Throwable)e, locale, new Object[]{contentType.getType()});
    }

    protected String handleError(LocalizedException e, Locale locale) {
        log.error("\u672c\u5730\u5316\u5f02\u5e38", (Throwable)e);
        return this.getMessage(e, locale, e.getLocaleArgs());
    }

    protected String handleError(Throwable e, Locale locale) {
        log.error("\u901a\u7528\u5f02\u5e38", e);
        return this.getMessage(e, locale, new Object[0]);
    }

    protected String getMessage(Throwable e, Locale locale, Object[] values) {
        String msgKey = e instanceof LocalizedException ? ((LocalizedException)e).getLocaleMessage() : e.getClass().getName();
        try {
            return this.messageSource.getMessage(msgKey, values, locale);
        }
        catch (NoSuchMessageException ex) {
            log.error(ex.getMessage());
            return e.getMessage();
        }
    }
}

