/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.support;

import java.io.File;
import java.nio.charset.Charset;
import javax.servlet.http.HttpServletRequest;
import net.dreamlu.tool.util.Charsets;
import net.dreamlu.tool.util.URLUtils;
import net.dreamlu.tool.util.WebUtils;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public abstract class BaseController {
    protected String redirect(String url) {
        return "redirect:" + url;
    }

    protected ResponseEntity<Resource> download(File file) {
        String fileName = file.getName();
        return this.download(file, fileName);
    }

    protected ResponseEntity<Resource> download(File file, String fileName) {
        FileSystemResource resource = new FileSystemResource(file);
        return this.download((Resource)resource, fileName);
    }

    protected ResponseEntity<Resource> download(Resource resource, String fileName) {
        HttpStatus status;
        HttpServletRequest request = WebUtils.getRequest();
        String header = request.getHeader("User-Agent");
        String string = header = header == null ? "" : header.toUpperCase();
        if (header.contains("MSIE") || header.contains("TRIDENT") || header.contains("EDGE")) {
            fileName = URLUtils.encodeURL((String)fileName, (Charset)Charsets.UTF_8);
            status = HttpStatus.OK;
        } else {
            fileName = new String(fileName.getBytes(Charsets.UTF_8), Charsets.ISO_8859_1);
            status = HttpStatus.CREATED;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        headers.setContentDispositionFormData("attachment", fileName);
        return new ResponseEntity((Object)resource, (MultiValueMap)headers, status);
    }
}

