/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.config;

import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import net.dreamlu.boot.properties.DreamProperties;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.aop.interceptor.SimpleAsyncUncaughtExceptionHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync
@EnableScheduling
public class ExecutorConfiguration
extends AsyncConfigurerSupport {
    private final DreamProperties dreamProperties;

    public ExecutorConfiguration(DreamProperties dreamProperties) {
        this.dreamProperties = dreamProperties;
    }

    @Bean(name={"taskExecutor"})
    public Executor getAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.dreamProperties.getAsync().getCorePoolSize());
        executor.setMaxPoolSize(this.dreamProperties.getAsync().getMaxPoolSize());
        executor.setQueueCapacity(this.dreamProperties.getAsync().getQueueCapacity());
        executor.setKeepAliveSeconds(this.dreamProperties.getAsync().getKeepAliveSeconds());
        executor.setThreadNamePrefix("async-executor-");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return new SimpleAsyncUncaughtExceptionHandler();
    }
}

