/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.runer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.dreamlu.tool.util.StringUtils;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SimpleCommandLinePropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.env.SystemEnvironmentPropertySource;

public class DreamApplication {
    public static ConfigurableApplicationContext run(String appName, Object source, String ... args) {
        String profile;
        StandardEnvironment environment = new StandardEnvironment();
        MutablePropertySources propertySources = environment.getPropertySources();
        propertySources.addFirst((PropertySource)new SimpleCommandLinePropertySource(args));
        propertySources.addLast((PropertySource)new MapPropertySource("systemProperties", environment.getSystemProperties()));
        propertySources.addLast((PropertySource)new SystemEnvironmentPropertySource("systemEnvironment", environment.getSystemEnvironment()));
        Object[] activeProfiles = environment.getActiveProfiles();
        List<String> profiles = Arrays.asList(activeProfiles);
        ArrayList<String> presetProfiles = new ArrayList<String>(Arrays.asList("dev", "test", "prod"));
        presetProfiles.retainAll(profiles);
        ArrayList<String> activeProfileList = new ArrayList<String>(profiles);
        SpringApplicationBuilder builder = new SpringApplicationBuilder(new Object[]{source});
        if (presetProfiles.isEmpty()) {
            profile = "dev";
            activeProfileList.add(profile);
            builder.profiles(new String[]{profile});
        } else if (presetProfiles.size() == 1) {
            profile = (String)presetProfiles.get(0);
        } else {
            throw new RuntimeException("\u540c\u65f6\u5b58\u5728\u73af\u5883\u53d8\u91cf:[" + StringUtils.join((Object[])activeProfiles) + "]");
        }
        System.err.println("----\u542f\u52a8\u4e2d\uff0c\u8bfb\u53d6\u5230\u7684\u73af\u5883\u53d8\u91cf:[" + StringUtils.join(activeProfileList) + "]----");
        System.setProperty("dream.env", profile);
        System.setProperty("spring.application.name", appName);
        System.setProperty("banner.location", "classpath:dream_banner.txt");
        System.setProperty("logging.config", "classpath:log4j2_${dream.env}.xml");
        return builder.run(args);
    }
}

