/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.properties;

import java.util.HashMap;
import java.util.Map;
import net.dreamlu.boot.properties.DreamDefaults;
import net.dreamlu.tool.util.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="dream")
public class DreamProperties {
    private String env;
    private final Map<String, String> prop = new HashMap<String, String>();
    private final Async async = new Async();
    private final Captcha captcha = new Captcha();
    private final Locale locale = new Locale();
    private final Upload upload = new Upload();

    public String get(String key) {
        return this.get(key, null);
    }

    public String get(String key, String defaultValue) {
        String value = this.prop.get(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }

    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    public Integer getInt(String key, Integer defaultValue) {
        String value = this.prop.get(key);
        if (value != null) {
            return Integer.parseInt(value.trim());
        }
        return defaultValue;
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        String value = this.prop.get(key);
        if (value != null) {
            return Long.parseLong(value.trim());
        }
        return defaultValue;
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String value = this.prop.get(key);
        if (value != null) {
            if ("true".equals(value = value.toLowerCase().trim())) {
                return true;
            }
            if ("false".equals(value)) {
                return false;
            }
            throw new RuntimeException("The value can not parse to Boolean : " + value);
        }
        return defaultValue;
    }

    public boolean containsKey(String key) {
        return this.prop.containsKey(key);
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public Map<String, String> getProp() {
        return this.prop;
    }

    public Async getAsync() {
        return this.async;
    }

    public Captcha getCaptcha() {
        return this.captcha;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Upload getUpload() {
        return this.upload;
    }

    public static class Upload {
        String savePath = DreamDefaults.Upload.savePath;

        public String getSavePath() {
            return this.savePath;
        }

        public void setSavePath(String savePath) {
            this.savePath = savePath;
        }
    }

    public static class Locale {
        String cookieName = "DREAM-LANG";
        String paramName = "language";
        java.util.Locale defaultLocale = DreamDefaults.Locale.defaultLocale;

        public String getCookieName() {
            return this.cookieName;
        }

        public String getParamName() {
            return this.paramName;
        }

        public java.util.Locale getDefaultLocale() {
            return this.defaultLocale;
        }

        public void setCookieName(String cookieName) {
            this.cookieName = cookieName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }

        public void setDefaultLocale(java.util.Locale defaultLocale) {
            this.defaultLocale = defaultLocale;
        }
    }

    public static class Captcha {
        private String cookieName = "dream-captcha";
        private String cacheName = "dreamCaptchaCache";

        public String getCookieName() {
            return this.cookieName;
        }

        public String getCacheName() {
            return this.cacheName;
        }

        public void setCookieName(String cookieName) {
            this.cookieName = cookieName;
        }

        public void setCacheName(String cacheName) {
            this.cacheName = cacheName;
        }
    }

    public static class Async {
        private int corePoolSize = 2;
        private int maxPoolSize = 50;
        private int queueCapacity = 10000;
        private int keepAliveSeconds = 300;

        public int getCorePoolSize() {
            return this.corePoolSize;
        }

        public int getMaxPoolSize() {
            return this.maxPoolSize;
        }

        public int getQueueCapacity() {
            return this.queueCapacity;
        }

        public int getKeepAliveSeconds() {
            return this.keepAliveSeconds;
        }

        public void setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public void setMaxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
        }

        public void setQueueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
        }

        public void setKeepAliveSeconds(int keepAliveSeconds) {
            this.keepAliveSeconds = keepAliveSeconds;
        }
    }
}

