/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.boot.config;

import org.hibernate.validator.HibernateValidator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.context.MessageSourceAutoConfiguration;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@AutoConfigureAfter(value={MessageSourceAutoConfiguration.class})
public class ValidatorConfiguration
extends WebMvcConfigurerAdapter {
    private final MessageSourceAutoConfiguration messageSourceAutoConfiguration;

    public ValidatorConfiguration(MessageSourceAutoConfiguration messageSourceAutoConfiguration) {
        this.messageSourceAutoConfiguration = messageSourceAutoConfiguration;
    }

    public Validator getValidator() {
        LocalValidatorFactoryBean validator = new LocalValidatorFactoryBean();
        validator.setProviderClass(HibernateValidator.class);
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasename("classpath:messages/ValidationMessages");
        messageSource.setCacheSeconds(this.messageSourceAutoConfiguration.getCacheSeconds());
        messageSource.setDefaultEncoding(this.messageSourceAutoConfiguration.getEncoding().name());
        messageSource.setAlwaysUseMessageFormat(this.messageSourceAutoConfiguration.isAlwaysUseMessageFormat());
        messageSource.setFallbackToSystemLocale(this.messageSourceAutoConfiguration.isFallbackToSystemLocale());
        validator.setValidationMessageSource((MessageSource)messageSource);
        return validator;
    }
}

