/*
 * Decompiled with CFR 0.152.
 */
package net.digger.util.fsm;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Consumer;
import net.digger.util.fsm.ActionHandler;
import net.digger.util.fsm.EventData;
import net.digger.util.fsm.EventMapper;
import net.digger.util.fsm.StateData;

public class StateMachine<A extends Enum<?>, S extends Enum<?>, E> {
    protected final S ANYWHERE = null;
    protected final S NO_TRANSITION = null;
    protected final A NO_ACTION = null;
    private final Map<S, StateData<A, S, E>> states = new HashMap<S, StateData<A, S, E>>();
    private final ActionHandler<A, S, E> handler;
    private final EventMapper<E> mapper;
    private final E minEvent;
    private final E maxEvent;
    private final S initialState;
    private S currentState;

    public StateMachine(S state, ActionHandler<A, S, E> handler) {
        this(state, handler, null, null, null);
    }

    public StateMachine(S state, ActionHandler<A, S, E> handler, EventMapper<E> mapper) {
        this(state, handler, mapper, null, null);
    }

    public StateMachine(S state, ActionHandler<A, S, E> handler, E minEvent, E maxEvent) throws IllegalArgumentException {
        this(state, handler, null, minEvent, maxEvent);
    }

    public StateMachine(S state, ActionHandler<A, S, E> handler, EventMapper<E> mapper, E minEvent, E maxEvent) throws IllegalArgumentException {
        this.initialState = state;
        this.currentState = state;
        this.handler = handler;
        this.mapper = mapper;
        StateData<Object, Object, E> data = new StateData<Object, Object, E>(null, null, null, minEvent, maxEvent);
        this.minEvent = minEvent;
        this.maxEvent = maxEvent;
    }

    public void addState(S state, A onEntry, A onExit, Consumer<StateData<A, S, E>> consumer) {
        StateData data = this.minEvent == null && this.maxEvent == null ? new StateData(state, onEntry, onExit) : new StateData<A, S, E>(state, onEntry, onExit, this.minEvent, this.maxEvent);
        consumer.accept(data);
        this.states.put(state, data);
    }

    public void reset() {
        this.currentState = this.initialState;
    }

    public StateData<A, S, E> getStateData(S state) {
        return this.states.get(state);
    }

    public EventData<A, S> getEventData(S state, E event) {
        E lookup = this.mapper == null ? event : this.mapper.map(event);
        StateData<A, S, E> data = this.states.get(state);
        if (data != null && data.hasEvent(lookup)) {
            return data.getEvent(lookup);
        }
        data = this.states.get(this.ANYWHERE);
        if (data != null && data.hasEvent(lookup)) {
            return data.getEvent(lookup);
        }
        return null;
    }

    public void handleEvent(E event) {
        Object action;
        EventData<A, S> data = this.getEventData(this.currentState, event);
        if (data.state != null && (action = this.states.get(this.currentState).onExit) != null && this.handler != null) {
            this.handler.onExit(this.currentState, action);
        }
        if (data.action != null && this.handler != null) {
            this.handler.onEvent(this.currentState, event, data.action);
        }
        if (data.state != null) {
            action = this.states.get(data.state).onEntry;
            if (action != null && this.handler != null) {
                this.handler.onEntry(data.state, action);
            }
            this.currentState = data.state;
        }
    }

    public String getDOT(boolean showAnywhere) {
        StringBuilder sb = new StringBuilder();
        sb.append("strict digraph StateMachine {\n");
        sb.append(String.format("\"%s\" -> \"%s\"\n", "start", this.initialState));
        for (Map.Entry<S, StateData<A, S, E>> stateEntry : this.states.entrySet()) {
            Enum[] enumArray;
            Enum state = (Enum)stateEntry.getKey();
            if (state == null) continue;
            for (Enum s : enumArray = (Enum[])state.getClass().getEnumConstants()) {
                sb.append(String.format("\"%s\" [shape=box, style=rounded];\n", s));
            }
        }
        HashSet transSet = new HashSet();
        StateData<A, S, E> anywhere = this.states.get(this.ANYWHERE);
        for (Map.Entry<S, StateData<A, S, E>> entry : this.states.entrySet()) {
            Transition trans;
            EventData eventData;
            Enum state = (Enum)entry.getKey();
            if (!showAnywhere) {
                if (state == this.ANYWHERE) continue;
                if (anywhere != null) {
                    for (Map.Entry eventEntry : anywhere.events.entrySet()) {
                        eventData = eventEntry.getValue();
                        trans = new Transition(state, (Enum)eventData.state, eventData.action);
                        transSet.add(trans);
                    }
                }
            }
            for (Map.Entry eventEntry : entry.getValue().events.entrySet()) {
                eventData = eventEntry.getValue();
                trans = new Transition(state, (Enum)eventData.state, eventData.action);
                transSet.add(trans);
            }
        }
        for (Transition transition : transSet) {
            String stateName;
            if (transition.to == this.NO_TRANSITION) continue;
            String string = stateName = transition.from == this.ANYWHERE ? "anywhere" : ((Enum)transition.from).toString();
            if (transition.action == this.NO_ACTION) {
                sb.append(String.format("\"%s\" -> \"%s\"\n", stateName, transition.to));
                continue;
            }
            sb.append(String.format("\"%s\" -> \"%s\" [label=\"%s\"];\n", stateName, transition.to, transition.action));
        }
        sb.append("}\n");
        return sb.toString();
    }

    private static class Transition<A extends Enum<?>, S extends Enum<?>> {
        public final S from;
        public final S to;
        public final A action;

        public Transition(S from, S to, A action) {
            this.from = from;
            this.to = to;
            this.action = action;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.action == null ? 0 : ((Enum)this.action).hashCode());
            result = 31 * result + (this.from == null ? 0 : ((Enum)this.from).hashCode());
            result = 31 * result + (this.to == null ? 0 : ((Enum)this.to).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Transition)) {
                return false;
            }
            Transition other = (Transition)obj;
            if (this.action == null ? other.action != null : !((Enum)this.action).equals(other.action)) {
                return false;
            }
            if (this.from == null ? other.from != null : !((Enum)this.from).equals(other.from)) {
                return false;
            }
            return !(this.to == null ? other.to != null : !((Enum)this.to).equals(other.to));
        }
    }
}

