/*
 * Decompiled with CFR 0.152.
 */
package net.digger.util.fsm;

import java.util.HashMap;
import java.util.Map;
import net.digger.util.fsm.EventData;

public class StateData<A extends Enum<?>, S extends Enum<?>, E> {
    public final S state;
    public final A onEntry;
    public final A onExit;
    protected final Map<E, EventData<A, S>> events = new HashMap<E, EventData<A, S>>();
    private final Integer minEvent;
    private final Integer maxEvent;

    public StateData(S state, A onEntry, A onExit) {
        this(state, onEntry, onExit, null, null);
    }

    public StateData(S state, A onEntry, A onExit, E minEvent, E maxEvent) throws IllegalArgumentException {
        E event;
        this.state = state;
        this.onEntry = onEntry;
        this.onExit = onExit;
        if (minEvent == null && maxEvent == null) {
            this.minEvent = null;
            this.maxEvent = null;
            return;
        }
        E e = event = minEvent == null ? maxEvent : minEvent;
        if (event instanceof Integer) {
            if ((Integer)minEvent > (Integer)maxEvent) {
                throw new IllegalArgumentException("minEvent must be <= maxEvent");
            }
            this.minEvent = minEvent == null ? Integer.MIN_VALUE : (Integer)minEvent;
            this.maxEvent = maxEvent == null ? Integer.MAX_VALUE : (Integer)maxEvent;
            return;
        }
        if (event instanceof Character) {
            if (((Character)minEvent).charValue() > ((Character)maxEvent).charValue()) {
                throw new IllegalArgumentException("minEvent must be <= maxEvent");
            }
            this.minEvent = minEvent == null ? 0 : ((Character)minEvent).charValue() & 0xFFFF;
            this.maxEvent = maxEvent == null ? 65535 : ((Character)maxEvent).charValue() & 0xFFFF;
            return;
        }
        if (event instanceof Enum) {
            if (((Enum)minEvent).ordinal() > ((Enum)maxEvent).ordinal()) {
                throw new IllegalArgumentException("minEvent must be <= maxEvent");
            }
            this.minEvent = minEvent == null ? 0 : ((Enum)minEvent).ordinal();
            this.maxEvent = maxEvent == null ? minEvent.getClass().getEnumConstants().length - 1 : ((Enum)maxEvent).ordinal();
            return;
        }
        throw new IllegalArgumentException("This constructor requires Integer, Character or Enum event type.");
    }

    public void addEvent(E event, A action, S state) throws IllegalArgumentException {
        if (event != null && this.minEvent != null && this.maxEvent != null) {
            String message = null;
            if (event instanceof Integer) {
                if ((Integer)event < this.minEvent || (Integer)event > this.maxEvent) {
                    message = String.format("Event must be 0x%02x (%d) to 0x%02x (%d). Received: 0x%02x (%d).", this.minEvent, this.minEvent, this.maxEvent, this.maxEvent, (Integer)event, (Integer)event);
                }
            } else if (event instanceof Character) {
                if (((Character)event).charValue() < this.minEvent || ((Character)event).charValue() > this.maxEvent) {
                    message = String.format("Event must be 0x%02x (%c) to 0x%02x (%c). Received: 0x%02x (%c).", this.minEvent, Character.valueOf((char)this.minEvent.intValue()), this.maxEvent, Character.valueOf((char)this.maxEvent.intValue()), ((Character)event).charValue() & 0xFF, event);
                }
            } else if (event instanceof Enum && (((Enum)event).ordinal() < this.minEvent || ((Enum)event).ordinal() > this.maxEvent)) {
                message = String.format("Event must be %s (%d) to %s (%d). Received: %s (%d).", event.getClass().getEnumConstants()[this.minEvent].toString(), this.minEvent, event.getClass().getEnumConstants()[this.maxEvent].toString(), this.maxEvent, event.toString(), ((Enum)event).ordinal());
            }
            if (message != null) {
                throw new IllegalArgumentException(message);
            }
        }
        this.events.put(event, new EventData<A, S>(action, state));
    }

    public void addEvents(E first, E last, A action, S state) throws IllegalArgumentException {
        if (first == null || last == null) {
            throw new IllegalArgumentException("Neither first nor last can be null.");
        }
        if (this.minEvent != null && this.maxEvent != null) {
            String message = null;
            if (first instanceof Integer) {
                if ((Integer)first < this.minEvent || (Integer)first > this.maxEvent || (Integer)last < this.minEvent || (Integer)last > this.maxEvent) {
                    message = String.format("Event must be 0x%02x (%d) to 0x%02x (%d). Received range: 0x%02x (%d) to 0x%02x (%d).", this.minEvent, this.minEvent, this.maxEvent, this.maxEvent, (Integer)first, (Integer)first, (Integer)last, (Integer)last);
                }
            } else if (first instanceof Character) {
                if (((Character)first).charValue() < this.minEvent || ((Character)first).charValue() > this.maxEvent || ((Character)last).charValue() < this.minEvent || ((Character)last).charValue() > this.maxEvent) {
                    message = String.format("Event must be 0x%02x (%c) to 0x%02x (%c). Received range: 0x%02x (%c) to 0x%02x (%c).", this.minEvent, Character.valueOf((char)this.minEvent.intValue()), this.maxEvent, Character.valueOf((char)this.maxEvent.intValue()), ((Character)first).charValue() & 0xFF, first, ((Character)last).charValue() & 0xFF, last);
                }
            } else if (first instanceof Enum && (((Enum)first).ordinal() < this.minEvent || ((Enum)first).ordinal() > this.maxEvent || ((Enum)last).ordinal() < this.minEvent || ((Enum)last).ordinal() > this.maxEvent)) {
                message = String.format("Event must be %s (%d) to %s (%d). Received range: %s (%d) to %s (%d).", first.getClass().getEnumConstants()[this.minEvent].toString(), this.minEvent, first.getClass().getEnumConstants()[this.maxEvent].toString(), this.maxEvent, first.toString(), ((Enum)first).ordinal(), last.toString(), ((Enum)last).ordinal());
            }
            if (message != null) {
                throw new IllegalArgumentException(message);
            }
        }
        EventData<A, S> data = new EventData<A, S>(action, state);
        if (first instanceof Integer) {
            Integer i = (Integer)first;
            while (i <= (Integer)last) {
                Integer key = i;
                this.events.put(key, data);
                key = i;
                Integer n = i = Integer.valueOf(i + 1);
            }
        } else if (first instanceof Character) {
            Character i = (Character)first;
            while (i.charValue() <= ((Character)last).charValue()) {
                Character key = i;
                this.events.put(key, data);
                key = i;
                Character c = i = Character.valueOf((char)(i.charValue() + '\u0001'));
            }
        } else if (first instanceof Enum) {
            ?[] values = first.getClass().getEnumConstants();
            for (int i = ((Enum)first).ordinal(); i <= ((Enum)last).ordinal(); ++i) {
                this.events.put(values[i], data);
            }
        } else {
            throw new IllegalArgumentException("StateData.addEvents() requires Integer, Character or Enum event type.");
        }
    }

    public boolean hasEvent(E event) {
        return this.events.containsKey(event);
    }

    public EventData<A, S> getEvent(E event) {
        return this.events.get(event);
    }
}

