/*
 * Decompiled with CFR 0.152.
 */
package net.digger.ui.vttest;

import java.util.HashMap;
import java.util.Map;
import net.digger.ui.screen.JScreen;
import net.digger.ui.screen.mode.IBMScreenMode;
import net.digger.ui.screen.protocol.ANSI;
import net.digger.ui.screen.protocol.CGAANSIColor;
import net.digger.ui.vttest.Esc;
import org.apache.commons.lang3.StringUtils;

public class VTTest {
    private JScreen screen;
    private static final String VERSION = "1.7b 1985-04-19";
    private Map<Integer, String> parityTable = new HashMap<Integer, String>(){
        {
            this.put(1, "NONE");
            this.put(4, "ODD");
            this.put(5, "EVEN");
            this.put(-1, "");
        }
    };
    private Map<Integer, String> nBitsTable = new HashMap<Integer, String>(){
        {
            this.put(1, "8");
            this.put(2, "7");
            this.put(-1, "");
        }
    };
    private Map<Integer, String> speedTable = new HashMap<Integer, String>(){
        {
            this.put(0, "50");
            this.put(8, "75");
            this.put(16, "110");
            this.put(24, "132.5");
            this.put(32, "150");
            this.put(40, "200");
            this.put(48, "300");
            this.put(56, "600");
            this.put(64, "1200");
            this.put(72, "1800");
            this.put(80, "2000");
            this.put(88, "2400");
            this.put(96, "3600");
            this.put(104, "4800");
            this.put(112, "9600");
            this.put(120, "19200");
            this.put(-1, "");
        }
    };

    public static void main(String[] args) {
        new VTTest().run();
    }

    public VTTest() {
        this.screen = JScreen.createJScreenWindow("VTTest", IBMScreenMode.VGA_80x25);
        this.screen.setTextProtocol(new ANSI(this.screen, new CGAANSIColor()));
        this.screen.keyboard.clearKeyBuffer();
        this.screen.keyboard.enableKeyBuffer(true);
        Esc.screen = this.screen;
    }

    public void run() {
        String[] mainMenu = new String[]{"Exit", "Test of cursor movements", "Test of screen features", "Test of character sets", "Test of double-sized characters", "Test of keyboard", "Test of terminal reports", "Test of VT52 mode", "Test of VT102 features (Insert/Delete Char/Line)", "Test of known bugs", "Test of reset and self-test", ""};
        this.initTerminal(0);
        try {
            int menuChoice;
            do {
                Esc.ed(2);
                Esc.cup(5, 10);
                this.screen.printf("VT100 test program, version %s", VERSION);
                Esc.cup(7, 10);
                Esc.println("Choose test type:");
                menuChoice = this.menu(mainMenu);
                switch (menuChoice) {
                    case 1: {
                        this.tst_movements();
                        break;
                    }
                    case 2: {
                        this.tst_screen();
                        break;
                    }
                    case 3: {
                        this.tst_characters();
                        break;
                    }
                    case 4: {
                        this.tst_doublesize();
                        break;
                    }
                    case 5: {
                        this.tst_keyboard();
                        break;
                    }
                    case 6: {
                        this.tst_reports();
                        break;
                    }
                    case 7: {
                        this.tst_vt52();
                        break;
                    }
                    case 8: {
                        this.tst_insdel();
                        break;
                    }
                    case 9: {
                        this.tst_bugs();
                        break;
                    }
                    case 10: {
                        this.tst_rst();
                    }
                }
            } while (menuChoice != 0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.bye();
    }

    private void tst_movements() throws InterruptedException {
        int col;
        String ctext = "This is a correct sentence";
        for (int pass = 0; pass <= 1; ++pass) {
            int row;
            int hlfxtra;
            int width;
            if (pass == 0) {
                Esc.rm("?3");
                width = 80;
                hlfxtra = 0;
            } else {
                Esc.sm("?3");
                width = 132;
                hlfxtra = 26;
            }
            Esc.decaln();
            Esc.cup(9, 10 + hlfxtra);
            Esc.ed(1);
            Esc.cup(18, 60 + hlfxtra);
            Esc.ed(0);
            Esc.el(1);
            Esc.cup(9, 71 + hlfxtra);
            Esc.el(0);
            for (row = 10; row <= 16; ++row) {
                Esc.cup(row, 10 + hlfxtra);
                Esc.el(1);
                Esc.cup(row, 71 + hlfxtra);
                Esc.el(0);
            }
            Esc.cup(17, 30);
            Esc.el(2);
            for (col = 1; col <= width; ++col) {
                Esc.hvp(24, col);
                this.screen.printf("*", new Object[0]);
                Esc.hvp(1, col);
                this.screen.printf("*", new Object[0]);
            }
            Esc.cup(2, 2);
            for (row = 2; row <= 23; ++row) {
                this.screen.printf("+", new Object[0]);
                Esc.cub(1);
                Esc.ind();
            }
            Esc.cup(23, width - 1);
            for (row = 23; row >= 2; --row) {
                this.screen.printf("+", new Object[0]);
                Esc.cub(1);
                Esc.ri();
            }
            Esc.cup(2, 1);
            for (row = 2; row <= 23; ++row) {
                this.screen.printf("*", new Object[0]);
                Esc.cup(row, width);
                this.screen.printf("*", new Object[0]);
                Esc.cub(10);
                if (row < 10) {
                    Esc.nel();
                    continue;
                }
                this.screen.printf("\n", new Object[0]);
            }
            Esc.cup(2, 10);
            Esc.cub(42 + hlfxtra);
            Esc.cuf(2);
            for (col = 3; col <= width - 2; ++col) {
                this.screen.printf("+", new Object[0]);
                Esc.cuf(0);
                Esc.cub(2);
                Esc.cuf(1);
            }
            Esc.cup(23, 70 + hlfxtra);
            Esc.cuf(42 + hlfxtra);
            Esc.cub(2);
            for (col = width - 2; col >= 3; --col) {
                this.screen.printf("+", new Object[0]);
                Esc.cub(1);
                Esc.cuf(1);
                Esc.cub(0);
                this.screen.printf("%c", 8);
            }
            Esc.cup(1, 1);
            Esc.cuu(10);
            Esc.cuu(1);
            Esc.cuu(0);
            Esc.cup(24, width);
            Esc.cud(10);
            Esc.cud(1);
            Esc.cud(0);
            Esc.cup(10, 12 + hlfxtra);
            for (row = 10; row <= 15; ++row) {
                for (col = 12 + hlfxtra; col <= 69 + hlfxtra; ++col) {
                    this.screen.printf(" ", new Object[0]);
                }
                Esc.cud(1);
                Esc.cub(58);
            }
            Esc.cuu(5);
            Esc.cuf(1);
            this.screen.printf("The screen should be cleared,  and have an unbroken bor-", new Object[0]);
            Esc.cup(12, 13 + hlfxtra);
            this.screen.printf("der of *'s and +'s around the edge,   and exactly in the", new Object[0]);
            Esc.cup(13, 13 + hlfxtra);
            this.screen.printf("middle  there should be a frame of E's around this  text", new Object[0]);
            Esc.cup(14, 13 + hlfxtra);
            this.screen.printf("with  one (1) free position around it.    ", new Object[0]);
            this.holdit();
        }
        Esc.rm("?3");
        Esc.ed(2);
        Esc.cup(1, 1);
        this.screen.println("Test of cursor-control characters inside ESC sequences.");
        this.screen.println("Below should be two identical lines:");
        this.screen.println("");
        this.screen.println("A B C D E F G H I J K L M N O P Q R S");
        for (int i = 1; i < 20; ++i) {
            this.screen.printf("%c", 64 + i);
            Esc.brcstr("2\b", 'C');
        }
        this.screen.println("");
        this.screen.println("");
        this.holdit();
        Esc.ed(2);
        Esc.cup(1, 1);
        this.screen.println("Test of leading zeros in ESC sequences.");
        this.screen.printf("Two lines below you should see the sentence \"%s\".", ctext);
        for (col = 0; col < ctext.length(); ++col) {
            this.screen.printf("\u001b[00000000004;00000000%dH%c", col + 1, Character.valueOf(ctext.charAt(col)));
        }
        Esc.cup(20, 1);
        this.holdit();
    }

    private void tst_screen() {
    }

    private void tst_characters() {
    }

    private void tst_doublesize() {
    }

    private void tst_keyboard() {
    }

    private void tst_reports() {
    }

    private void tst_vt52() {
    }

    private void tst_insdel() {
    }

    private void dch(int pn) {
        Esc.brc(pn, 'P');
    }

    private void ich(int pn) {
        Esc.brc(pn, '@');
    }

    private void dl(int pn) {
        Esc.brc(pn, 'M');
    }

    private void il(int pn) {
        Esc.brc(pn, 'L');
    }

    private void tst_bugs() {
    }

    private void bug_a() {
    }

    private void bug_b() {
    }

    private void bug_c() {
    }

    private void bug_d() {
    }

    private void bug_e() {
    }

    private void bug_f() {
    }

    private void bug_w() {
    }

    private void bug_l() {
    }

    private void bug_s() {
    }

    private void tst_rst() {
    }

    private void initTerminal(int pn) {
        Esc.esc("<");
        Esc.rm("?1");
        Esc.rm("?3");
        Esc.rm("?4");
        Esc.rm("?5");
        Esc.rm("?6");
        Esc.sm("?7");
        Esc.rm("?8");
        Esc.decstbm(0, 0);
        Esc.sgr("0");
    }

    private void bye() {
        Esc.esc("<");
        Esc.rm("?1");
        Esc.rm("?3");
        Esc.rm("?5");
        Esc.rm("?6");
        Esc.sm("?7");
        Esc.sm("?8");
        Esc.decstbm(0, 0);
        Esc.sgr("0");
        Esc.ed(2);
        Esc.cup(12, 30);
        this.screen.printf("That's all, folks!\r\n", new Object[0]);
        this.screen.printf("\r\n\r\n\r\n", new Object[0]);
        Esc.inflush();
    }

    private void onbrk() {
    }

    private void onterm() {
    }

    private void holdit() throws InterruptedException {
        Esc.inflush();
        this.screen.printf("Push <RETURN>", new Object[0]);
        this.readnl();
    }

    private void readnl() throws InterruptedException {
        this.screen.keyboard.readLine();
    }

    private int scanto() {
        return 0;
    }

    private String lookup(Map<Integer, String> t, int k) {
        return "BAD VALUE";
    }

    private int menu(String[] table) throws InterruptedException {
        Esc.println("");
        int tablesize = 0;
        int i = 0;
        while (StringUtils.isNotEmpty(table[i])) {
            this.screen.printf("          %d. %s\r\n", i, table[i]);
            ++tablesize;
            ++i;
        }
        this.screen.printf("\r\n          Enter choice number (0 - %d): ", --tablesize);
        while (true) {
            String s = Esc.inputline();
            int choice = 0;
            try {
                choice = Integer.parseInt(s);
                if (choice >= 0 && choice <= tablesize) {
                    Esc.ed(2);
                    return choice;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.screen.printf("          Bad choice, try again: ", new Object[0]);
        }
    }

    private void chrprint(String s) {
    }
}

