/*
 * Decompiled with CFR 0.152.
 */
package net.digger.ui.screen.protocol;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.function.Consumer;
import net.digger.ui.screen.JScreen;
import net.digger.ui.screen.color.Attr;
import net.digger.ui.screen.protocol.ANSIColor;
import net.digger.ui.screen.protocol.PlainText;
import net.digger.util.vt.Action;
import net.digger.util.vt.VTEmulator;
import net.digger.util.vt.VTParser;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;

public class ANSI
extends PlainText
implements VTEmulator {
    private static final char ESCAPE = '\u001b';
    private static final String CSI = "\u001b[";
    private VTParser parser;
    private ANSIColor palette;
    private Consumer<String> dsrCallback = null;
    private Point cursor = null;
    private int topMargin = 0;
    private int bottomMargin = 0;
    private boolean inANSIMusic = false;
    private StringBuilder music = new StringBuilder();

    public ANSI(JScreen screen, ANSIColor palette) {
        this(screen, palette, null);
    }

    public ANSI(JScreen screen, ANSIColor palette, Consumer<String> dsrCallback) {
        super(screen);
        this.palette = palette;
        this.dsrCallback = dsrCallback;
        this.parser = new VTParser(this, true);
    }

    @Override
    public void print(char ch) {
        if (this.inANSIMusic) {
            if (ch < ' ') {
                this.inANSIMusic = false;
                this.music.setLength(0);
                if (ch == '\u000e') {
                    return;
                }
            } else {
                this.music.append(ch);
                return;
            }
        }
        this.parser.parse(ch);
    }

    @Override
    public void actionCSIDispatch(char ch, List<Character> intermediateChars, List<Integer> params) {
        ControlSequence ctrlseq = EnumUtils.getEnum(ControlSequence.class, String.valueOf(ch));
        if (ctrlseq == null || intermediateChars.size() > 0) {
            System.out.println("ANSI: Unimplemented Control Sequence: Esc[" + StringUtils.join(intermediateChars, null) + StringUtils.join(params, ';') + ch);
            return;
        }
        switch (ctrlseq) {
            case A: {
                this.doCUU(intermediateChars, params);
                break;
            }
            case B: {
                this.doCUD(intermediateChars, params);
                break;
            }
            case C: {
                this.doCUF(intermediateChars, params);
                break;
            }
            case D: {
                this.doCUB(intermediateChars, params);
                break;
            }
            case f: 
            case H: {
                this.doHVPCUP(intermediateChars, params);
                break;
            }
            case J: {
                this.doED(intermediateChars, params);
                break;
            }
            case K: {
                this.doEL(intermediateChars, params);
                break;
            }
            case M: {
                this.inANSIMusic = true;
                this.music.setLength(0);
                this.music.append('M');
                break;
            }
            case m: {
                this.doSGR(intermediateChars, params);
                break;
            }
            case n: {
                this.doDSR(intermediateChars, params);
                break;
            }
            case r: {
                this.doDECSTBM(intermediateChars, params);
                break;
            }
            case s: {
                this.doSCP(intermediateChars, params);
                break;
            }
            case u: {
                this.doRCP(intermediateChars, params);
            }
        }
    }

    private void doCUU(List<Character> intermediateChars, List<Integer> params) {
        Point coord = this.screen.getCursor();
        coord.y = Math.max(0, coord.y - this.nextParam(params, 1));
        if (this.topMargin > 0) {
            coord.y = Math.max(coord.y, this.topMargin - 1);
        }
        this.screen.setCursor(coord);
    }

    private void doCUD(List<Character> intermediateChars, List<Integer> params) {
        Point coord = this.screen.getCursor();
        Rectangle window = this.screen.getWindow();
        coord.y = Math.min(window.height - 1, coord.y + this.nextParam(params, 1));
        if (this.bottomMargin > 0) {
            coord.y = Math.min(coord.y, this.bottomMargin - 1);
        }
        this.screen.setCursor(coord);
    }

    private void doCUF(List<Character> intermediateChars, List<Integer> params) {
        Point coord = this.screen.getCursor();
        Rectangle window = this.screen.getWindow();
        coord.x = Math.min(window.width - 1, coord.x + this.nextParam(params, 1));
        this.screen.setCursor(coord);
    }

    private void doCUB(List<Character> intermediateChars, List<Integer> params) {
        Point coord = this.screen.getCursor();
        coord.x = Math.max(0, coord.x - this.nextParam(params, 1));
        this.screen.setCursor(coord);
    }

    private void doHVPCUP(List<Character> intermediateChars, List<Integer> params) {
        int y = this.nextParam(params, 1);
        int x = this.nextParam(params, 1);
        Rectangle window = this.screen.getWindow();
        x = Math.max(1, Math.min(window.width, x));
        y = Math.max(1, Math.min(window.height, y));
        this.screen.setCursor(x - 1, y - 1);
    }

    private void doED(List<Character> intermediateChars, List<Integer> params) {
        int param = this.nextParam(params, 0);
        switch (param) {
            case 0: {
                this.screen.clearToBottom();
                break;
            }
            case 1: {
                this.screen.clearToTop();
                break;
            }
            case 2: 
            case 3: {
                this.screen.clearWindow();
                break;
            }
            default: {
                System.out.printf("ANSI: Unimplemented ED parameter: %d\n", param);
            }
        }
    }

    private void doEL(List<Character> intermediateChars, List<Integer> params) {
        int param = this.nextParam(params, 0);
        switch (param) {
            case 0: {
                this.screen.clearToEOL();
                break;
            }
            case 1: {
                this.screen.clearToBOL();
                break;
            }
            case 2: {
                this.screen.clearLine();
                break;
            }
            default: {
                System.out.printf("ANSI: Unimplemented EL parameter: %d\n", param);
            }
        }
    }

    private void doSGR(List<Character> intermediateChars, List<Integer> params) {
        if (params.isEmpty()) {
            params.add(null);
        }
        block27: while (!params.isEmpty()) {
            int param = this.nextParam(params, 0);
            switch (param) {
                case 0: {
                    this.screen.setTextColors(this.palette.getDefaultFG(), this.palette.getDefaultBG(), new Attr[0]);
                    continue block27;
                }
                case 1: {
                    this.screen.setTextAttr(Attr.BOLD, true);
                    continue block27;
                }
                case 5: {
                    this.screen.setTextAttr(Attr.BLINKING, true);
                    continue block27;
                }
                case 7: {
                    this.screen.setTextAttr(Attr.REVERSE, true);
                    continue block27;
                }
                case 22: {
                    this.screen.setTextAttr(Attr.BOLD, false);
                    continue block27;
                }
                case 25: {
                    this.screen.setTextAttr(Attr.BLINKING, false);
                    continue block27;
                }
                case 27: {
                    this.screen.setTextAttr(Attr.REVERSE, false);
                    continue block27;
                }
                case 30: {
                    this.screen.setFGColor(this.palette.getBlack());
                    continue block27;
                }
                case 31: {
                    this.screen.setFGColor(this.palette.getRed());
                    continue block27;
                }
                case 32: {
                    this.screen.setFGColor(this.palette.getGreen());
                    continue block27;
                }
                case 33: {
                    this.screen.setFGColor(this.palette.getBrown());
                    continue block27;
                }
                case 34: {
                    this.screen.setFGColor(this.palette.getBlue());
                    continue block27;
                }
                case 35: {
                    this.screen.setFGColor(this.palette.getMagenta());
                    continue block27;
                }
                case 36: {
                    this.screen.setFGColor(this.palette.getCyan());
                    continue block27;
                }
                case 37: {
                    this.screen.setFGColor(this.palette.getLightGrey());
                    continue block27;
                }
                case 39: {
                    this.screen.setFGColor(this.palette.getDefaultFG());
                    continue block27;
                }
                case 40: {
                    this.screen.setBGColor(this.palette.getBlack());
                    continue block27;
                }
                case 41: {
                    this.screen.setBGColor(this.palette.getRed());
                    continue block27;
                }
                case 42: {
                    this.screen.setBGColor(this.palette.getGreen());
                    continue block27;
                }
                case 43: {
                    this.screen.setBGColor(this.palette.getBrown());
                    continue block27;
                }
                case 44: {
                    this.screen.setBGColor(this.palette.getBlue());
                    continue block27;
                }
                case 45: {
                    this.screen.setBGColor(this.palette.getMagenta());
                    continue block27;
                }
                case 46: {
                    this.screen.setBGColor(this.palette.getCyan());
                    continue block27;
                }
                case 47: {
                    this.screen.setBGColor(this.palette.getLightGrey());
                    continue block27;
                }
                case 49: {
                    this.screen.setBGColor(this.palette.getDefaultBG());
                    continue block27;
                }
            }
            System.out.printf("ANSI: Unimplemented SGR parameter: %d\n", param);
        }
    }

    private void doDSR(List<Character> intermediateChars, List<Integer> params) {
        int param = this.nextParam(params, 0);
        switch (param) {
            case 5: {
                if (this.dsrCallback == null) break;
                String response = "\u001b[0n";
                this.dsrCallback.accept(response);
                break;
            }
            case 6: {
                if (this.dsrCallback == null) break;
                Point cursor = this.screen.getCursor();
                String response = CSI + cursor.y + ';' + cursor.x + 'R';
                this.dsrCallback.accept(response);
                break;
            }
            default: {
                System.out.printf("ANSI: Unimplemented DSR parameter: %d\n", param);
            }
        }
    }

    private void doDECSTBM(List<Character> intermediateChars, List<Integer> params) {
        Rectangle window = this.screen.getWindow();
        int top = this.nextParam(params, 1);
        int bottom = this.nextParam(params, window.height);
        if (top == 1 && bottom == window.height) {
            this.topMargin = 0;
            this.bottomMargin = 0;
        } else if (top > 0 && bottom > 0 && bottom > top) {
            this.topMargin = top;
            this.bottomMargin = bottom;
        }
    }

    private void doSCP(List<Character> intermediateChars, List<Integer> params) {
        this.cursor = this.screen.getCursor();
    }

    private void doRCP(List<Character> intermediateChars, List<Integer> params) {
        if (this.cursor != null) {
            this.screen.setCursor(this.cursor);
        }
    }

    @Override
    public void actionEscapeDispatch(char ch, List<Character> intermediateChars) {
        EscapeSequence escseq = EnumUtils.getEnum(EscapeSequence.class, String.valueOf(ch));
        if (escseq == null || intermediateChars.size() > 0) {
            System.out.println("ANSI: Unimplemented Escape Sequence: Esc" + StringUtils.join(intermediateChars, null) + ch);
            return;
        }
        switch (escseq) {
            case D: {
                this.doIND();
                break;
            }
            case E: {
                this.doNEL();
                break;
            }
            case M: {
                this.doRI();
            }
        }
    }

    private void doIND() {
        this.insideMargin(() -> {
            Point coord = this.screen.getCursor();
            Rectangle window = this.screen.getWindow();
            if (coord.y < window.height - 1) {
                this.screen.setCursor(coord.x, coord.y + 1);
            } else {
                this.screen.scrollWindowUp();
            }
        });
    }

    private void doNEL() {
        this.insideMargin(() -> {
            super.print('\r');
            super.print('\n');
        });
    }

    private void doRI() {
        this.insideMargin(() -> {
            Point coord = this.screen.getCursor();
            if (coord.y > 0) {
                this.screen.setCursor(coord.x, coord.y - 1);
            } else {
                this.screen.scrollWindowDown();
            }
        });
    }

    @Override
    public void actionExecute(char ch) {
        this.actionPrint(ch);
    }

    @Override
    public void actionPrint(char ch) {
        this.insideMargin(() -> super.print(ch));
    }

    @Override
    public void actionDCSHook(char ch, List<Character> intermediateChars, List<Integer> params) {
        this.printAction(Action.DCS_HOOK, Character.valueOf(ch), intermediateChars, params);
    }

    @Override
    public void actionDCSPut(char ch) {
        this.printAction(Action.DCS_PUT, Character.valueOf(ch), null, null);
    }

    @Override
    public void actionDCSUnhook() {
        this.printAction(Action.DCS_UNHOOK, null, null, null);
    }

    @Override
    public void actionError() {
        this.printAction(Action.ERROR, null, null, null);
    }

    @Override
    public void actionOSCEnd() {
        this.printAction(Action.OSC_END, null, null, null);
    }

    @Override
    public void actionOSCPut(char ch) {
        this.printAction(Action.OSC_PUT, Character.valueOf(ch), null, null);
    }

    @Override
    public void actionOSCStart() {
        this.printAction(Action.OSC_START, null, null, null);
    }

    private void printAction(Action action, Character ch, List<Character> intermediateChars, List<Integer> params) {
        System.out.printf("ANSI: Unimplemented Parser Action %s", new Object[]{action});
        if (ch != null && ch.charValue() != '\u0000') {
            System.out.printf(", Char: 0x%02x ('%c')\n", ch.charValue(), ch);
        }
        if (intermediateChars != null && !intermediateChars.isEmpty()) {
            System.out.printf("\t%d Intermediate chars: ", intermediateChars.size());
            for (Character intch : intermediateChars) {
                System.out.printf("0x%02x ('%c'), ", intch.charValue(), intch);
            }
            System.out.println();
        }
        if (params != null && !params.isEmpty()) {
            System.out.printf("\t%d Parameters: ", params.size());
            for (Integer param : params) {
                System.out.printf("%d, ", param);
            }
            System.out.println();
        }
        System.out.println();
    }

    private int nextParam(List<Integer> params, int defaultValue) {
        if (params == null) {
            return defaultValue;
        }
        if (params.isEmpty()) {
            return defaultValue;
        }
        Integer param = params.remove(0);
        if (param == null || param == 0) {
            return defaultValue;
        }
        return param;
    }

    protected void insideMargin(Runnable callback) {
        int dy = 0;
        int dh = 0;
        if (this.topMargin > 0 && this.bottomMargin > 0) {
            Point cursor = this.screen.getCursor();
            Rectangle window = this.screen.getWindow();
            int bottom = Math.min(this.bottomMargin, window.height);
            if (cursor.y + 1 >= this.topMargin && cursor.y + 1 <= bottom) {
                dy = this.topMargin - 1;
                int height = bottom - this.topMargin + 1;
                dh = height - window.height;
                if (dy != 0 || dh != 0) {
                    this.screen.adjustWindow(0, dy, 0, dh);
                }
            }
        }
        callback.run();
        if (dy != 0 || dh != 0) {
            this.screen.adjustWindow(0, -dy, 0, -dh);
        }
    }

    private static enum ControlSequence {
        A,
        B,
        C,
        D,
        f,
        H,
        J,
        K,
        M,
        m,
        n,
        r,
        s,
        u;

    }

    private static enum EscapeSequence {
        D,
        E,
        M;

    }
}

