/*
 * Decompiled with CFR 0.152.
 */
package net.digger.ui.screen.io;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import net.digger.ui.screen.JScreen;
import org.apache.commons.lang3.StringUtils;

public class JScreenKeyboard {
    private static boolean KEY_DEBUG = false;
    private final JScreen screen;
    private boolean keyBufferEnabled = false;
    private ArrayDeque<KeyEvent> keyBuffer = new ArrayDeque();

    public JScreenKeyboard(JScreen screen) {
        this.screen = screen;
        KeyListener listener = new KeyListener(){
            private final Map<Integer, Character> winCtrlKeyMap = new HashMap<Integer, Character>(){
                {
                    this.put(77, Character.valueOf('\r'));
                    this.put(49, Character.valueOf('1'));
                    this.put(50, Character.valueOf('2'));
                    this.put(51, Character.valueOf('3'));
                    this.put(52, Character.valueOf('4'));
                    this.put(53, Character.valueOf('5'));
                    this.put(54, Character.valueOf('6'));
                    this.put(55, Character.valueOf('7'));
                    this.put(56, Character.valueOf('8'));
                    this.put(57, Character.valueOf('9'));
                    this.put(48, Character.valueOf('0'));
                    this.put(45, Character.valueOf('-'));
                    this.put(61, Character.valueOf('='));
                    this.put(96, Character.valueOf('0'));
                    this.put(97, Character.valueOf('1'));
                    this.put(98, Character.valueOf('2'));
                    this.put(99, Character.valueOf('3'));
                    this.put(100, Character.valueOf('4'));
                    this.put(101, Character.valueOf('5'));
                    this.put(102, Character.valueOf('6'));
                    this.put(103, Character.valueOf('7'));
                    this.put(104, Character.valueOf('8'));
                    this.put(105, Character.valueOf('9'));
                    this.put(106, Character.valueOf('*'));
                    this.put(107, Character.valueOf('+'));
                    this.put(109, Character.valueOf('-'));
                    this.put(110, Character.valueOf('.'));
                    this.put(111, Character.valueOf('/'));
                }
            };
            private final Map<Character, Character> winShiftKeyMap = new HashMap<Character, Character>(){
                {
                    this.put(Character.valueOf('1'), Character.valueOf('!'));
                    this.put(Character.valueOf('2'), Character.valueOf('@'));
                    this.put(Character.valueOf('3'), Character.valueOf('#'));
                    this.put(Character.valueOf('4'), Character.valueOf('$'));
                    this.put(Character.valueOf('5'), Character.valueOf('%'));
                    this.put(Character.valueOf('6'), Character.valueOf('^'));
                    this.put(Character.valueOf('7'), Character.valueOf('&'));
                    this.put(Character.valueOf('8'), Character.valueOf('*'));
                    this.put(Character.valueOf('9'), Character.valueOf('('));
                    this.put(Character.valueOf('0'), Character.valueOf(')'));
                    this.put(Character.valueOf('-'), Character.valueOf('\u001f'));
                    this.put(Character.valueOf('='), Character.valueOf('+'));
                }
            };
            private Character faked = null;

            @Override
            public void keyTyped(KeyEvent e) {
                if (this.faked != null) {
                    if (e.getKeyChar() == this.faked.charValue()) {
                        if (KEY_DEBUG) {
                            System.out.print("Suppressed: (faked=" + this.faked + ")");
                        }
                        this.faked = null;
                        return;
                    }
                    if (e.getKeyChar() == '\n' && this.faked.charValue() == '\r') {
                        if (KEY_DEBUG) {
                            System.out.print("Suppressed hack: (faked=" + this.faked + ")");
                        }
                        this.faked = null;
                        return;
                    }
                    this.faked = null;
                }
                JScreenKeyboard.this.addKeyEvent(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (KEY_DEBUG) {
                    JScreenKeyboard.this.dumpKey(e);
                }
                if (e.isActionKey()) {
                    JScreenKeyboard.this.addKeyEvent(e);
                    return;
                }
                Character c = this.winCtrlKeyMap.get(e.getKeyCode());
                if (c != null) {
                    boolean numpad;
                    int modifiers = e.getModifiersEx();
                    boolean ctrl = (modifiers & 0x80) != 0;
                    boolean shift = (modifiers & 0x40) != 0;
                    boolean bl = numpad = e.getKeyLocation() == 4;
                    if (!(!ctrl || shift && numpad)) {
                        Character c2;
                        if (shift && (c2 = this.winShiftKeyMap.get(c)) != null) {
                            c = c2;
                        }
                        KeyEvent e2 = new KeyEvent((Component)e.getSource(), 400, e.getWhen(), e.getModifiers() | e.getModifiersEx(), 0, c.charValue(), 0);
                        if (KEY_DEBUG) {
                            System.out.print("Faked:");
                        }
                        JScreenKeyboard.this.addKeyEvent(e2);
                        this.faked = c;
                    }
                }
            }
        };
        screen.getComponent().addKeyListener(listener);
    }

    public void enableKeyBuffer(boolean enable) {
        this.keyBufferEnabled = enable;
    }

    public boolean isKeyBufferEnabled() {
        return this.keyBufferEnabled;
    }

    public void clearKeyBuffer() {
        this.keyBuffer.clear();
    }

    public boolean isKeyEvent() {
        return !this.keyBuffer.isEmpty();
    }

    public KeyEvent getKeyEvent() {
        return this.keyBuffer.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyEvent awaitKeyEvent() throws InterruptedException {
        if (!this.keyBufferEnabled) {
            throw new RuntimeException("Key buffer is not enabled.");
        }
        ArrayDeque<KeyEvent> arrayDeque = this.keyBuffer;
        synchronized (arrayDeque) {
            while (this.keyBuffer.isEmpty()) {
                this.keyBuffer.wait();
            }
            return this.keyBuffer.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addKeyEvent(KeyEvent event) {
        if (!this.keyBufferEnabled) {
            return;
        }
        ArrayDeque<KeyEvent> arrayDeque = this.keyBuffer;
        synchronized (arrayDeque) {
            this.keyBuffer.add(event);
            if (KEY_DEBUG) {
                this.dumpKey(this.keyBuffer.peekLast());
            }
            this.keyBuffer.notify();
        }
    }

    public void addKeyEvents(String text) {
        if (!this.keyBufferEnabled || text == null) {
            return;
        }
        for (int i = 0; i < text.length(); ++i) {
            int modifiers = 0;
            char ch = text.charAt(i);
            if (Character.isUpperCase(ch)) {
                modifiers |= 0x40;
            }
            KeyEvent event = new KeyEvent(this.screen.getComponent(), 400, System.currentTimeMillis(), modifiers, 0, ch);
            this.addKeyEvent(event);
        }
    }

    public void pasteClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            String text = null;
            Transferable contents = clipboard.getContents(null);
            if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                text = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            this.addKeyEvents(text);
        }
        catch (UnsupportedFlavorException | IOException | IllegalStateException exception) {
            // empty catch block
        }
    }

    public String readLine() throws InterruptedException {
        return this.readLine(Integer.MAX_VALUE);
    }

    public String readLine(int maxLength) throws InterruptedException {
        String input = "";
        char ch = '\u0000';
        block5: do {
            KeyEvent event;
            if ((event = this.awaitKeyEvent()).getID() != 400) continue;
            ch = event.getKeyChar();
            switch (ch) {
                case '\b': {
                    if (input.length() <= 0) continue block5;
                    input = input.substring(0, input.length() - 1);
                    this.screen.print(ch);
                    break;
                }
                case '\n': {
                    this.screen.println();
                    break;
                }
                case '\u001b': {
                    while (input.length() > 0) {
                        input = input.substring(0, input.length() - 1);
                        this.screen.print('\b');
                    }
                    continue block5;
                }
                default: {
                    if (input.length() >= maxLength) continue block5;
                    input = input + ch;
                    this.screen.print(ch);
                }
            }
        } while (ch != '\n');
        return input;
    }

    private void dumpKey(KeyEvent event) {
        System.out.println();
        int id = event.getID();
        switch (id) {
            case 401: {
                System.out.println("KEY_PRESSED:");
                break;
            }
            case 402: {
                System.out.println("KEY_RELEASED:");
                break;
            }
            case 400: {
                System.out.println("KEY_TYPED:");
                break;
            }
            default: {
                System.out.println("Unknown event type:");
            }
        }
        char c = event.getKeyChar();
        System.out.printf("\tkey character = '%c' (%d = 0x%s)\n", Character.valueOf(c), (int)c, Integer.toHexString(c));
        int keyCode = event.getKeyCode();
        System.out.printf("\tkey code = %d (%s)\n", keyCode, KeyEvent.getKeyText(keyCode));
        int modifiersEx = event.getModifiersEx();
        String modString = KeyEvent.getModifiersExText(modifiersEx);
        if (StringUtils.isBlank(modString)) {
            modString = "no extended modifiers";
        }
        System.out.printf("\textended modifiers = %d (%s)\n", modifiersEx, modString);
        System.out.printf("\taction key? %s\n", event.isActionKey() ? "YES" : "NO");
        switch (event.getKeyLocation()) {
            case 1: {
                System.out.println("\tkey location: standard");
                break;
            }
            case 2: {
                System.out.println("\tkey location: left");
                break;
            }
            case 3: {
                System.out.println("\tkey location: right");
                break;
            }
            case 4: {
                System.out.println("\tkey location: numpad");
                break;
            }
            default: {
                System.out.println("\tkey location: unknown");
            }
        }
    }
}

