/*
 * Decompiled with CFR 0.152.
 */
package net.digger.ui.screen.font;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.digger.ui.screen.JScreenCell;
import net.digger.ui.screen.color.Attr;
import net.digger.ui.screen.color.JScreenPalette;

public class JScreenFont {
    private static boolean FONT_DEBUG = false;
    private final String family;
    private final int size;
    private final String about;
    private final boolean antiAlias;
    private final Map<Integer, Font> fonts = new HashMap<Integer, Font>();
    private final Map<Integer, Integer> offsets = new HashMap<Integer, Integer>();
    private final Map<Integer, Dimension> sizes = new HashMap<Integer, Dimension>();

    public JScreenFont(String family, int pointSize, String about) {
        this(family, pointSize, about, false);
    }

    public JScreenFont(String family, int pointSize, String about, boolean antiAlias) {
        this.family = family;
        this.size = pointSize;
        this.about = about;
        this.antiAlias = antiAlias;
        if (!this.isMonospaced()) {
            throw new IllegalArgumentException(family + " is not monospaced.");
        }
    }

    public String getFamily() {
        return this.family;
    }

    public int getPointSize() {
        return this.size;
    }

    public String getAbout() {
        return "'" + this.family + "' " + (this.about == null ? "" : this.about);
    }

    private boolean isMonospaced() {
        Font font = this.getFont(1);
        AffineTransform atrans = null;
        if (font.isTransformed()) {
            atrans = font.getTransform();
        }
        FontRenderContext frc = new FontRenderContext(atrans, true, true);
        Rectangle2D b1 = font.getStringBounds("|", frc);
        Rectangle2D b2 = font.getStringBounds("W", frc);
        return b1.getWidth() == b2.getWidth();
    }

    public Dimension getCellSize(int scale) {
        Dimension cellSize = this.sizes.get(scale);
        if (cellSize == null) {
            Rectangle2D cell = this.getCell(scale);
            cellSize = new Dimension();
            cellSize.width = (int)Math.round(cell.getWidth() + 0.5);
            cellSize.height = (int)Math.round(cell.getHeight() + 0.5);
            this.sizes.put(scale, cellSize);
        }
        return cellSize;
    }

    private Rectangle2D getCell(int scale) {
        Font font = this.getFont(scale);
        AffineTransform atrans = null;
        if (font.isTransformed()) {
            atrans = font.getTransform();
        }
        FontRenderContext frc = new FontRenderContext(atrans, true, true);
        return font.getMaxCharBounds(frc);
    }

    protected static String registerFont(String file) {
        try {
            InputStream is = JScreenFont.class.getClassLoader().getResourceAsStream(file);
            if (is == null) {
                is = JScreenFont.class.getClassLoader().getResourceAsStream("resources/" + file);
            }
            Font font = Font.createFont(0, is);
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
            return font.getFamily();
        }
        catch (FontFormatException | IOException e) {
            throw new RuntimeException("Unable to load font " + file, e);
        }
    }

    private Font getFont(int scale) {
        Font font = this.fonts.get(scale);
        if (font == null) {
            font = new Font(this.family, 0, this.size * scale);
            this.fonts.put(scale, font);
        }
        return font;
    }

    private int getYOffset(int scale) {
        Integer offset = this.offsets.get(scale);
        if (offset == null) {
            Rectangle2D cell = this.getCell(scale);
            offset = (int)Math.round(cell.getHeight() + cell.getY());
            this.offsets.put(scale, offset);
        }
        return offset;
    }

    public void drawChar(Graphics g, Rectangle bounds, JScreenPalette palette, JScreenCell cell, int scale) {
        Color fg = palette.getFG(cell);
        Color bg = palette.getBG(cell);
        if (cell.attrs != null && cell.attrs.contains((Object)Attr._IS_SELECTED)) {
            Color tmp = fg;
            fg = bg;
            bg = tmp;
        }
        g.setColor(bg);
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        if (FONT_DEBUG) {
            Color boxColor = (bounds.x / bounds.width + bounds.y / bounds.height) % 2 == 0 ? Color.BLUE : Color.GRAY;
            g.setColor(boxColor);
            g.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
        }
        if (!(cell.attrs.contains((Object)Attr.BLINKING) && cell.attrs.contains((Object)Attr._IS_BLINKED) || fg.equals(bg))) {
            g.setFont(this.getFont(scale));
            g.setColor(fg);
            if (this.antiAlias) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            g.drawChars(new char[]{cell.ch}, 0, 1, bounds.x, bounds.y + bounds.height - this.getYOffset(scale));
        }
    }
}

