/*
 * Decompiled with CFR 0.152.
 */
package net.digger.ui.screen.color;

import java.awt.Color;
import java.util.EnumSet;
import net.digger.ui.screen.JScreenCell;
import net.digger.ui.screen.color.Attr;

public class JScreenPalette {
    public final Color[] color;
    public final int defaultFG;
    public final int defaultBG;

    public JScreenPalette(int defaultFG, int defaultBG, Color ... colors) {
        this.defaultFG = defaultFG;
        this.defaultBG = defaultBG;
        this.color = colors;
    }

    public Color get(int index) {
        return this.color[index];
    }

    public Color getFG(JScreenCell cell) {
        return this.getFG(cell.fg, cell.bg, cell.attrs);
    }

    public Color getFG(int fgIndex, int bgIndex, EnumSet<Attr> attrs) {
        if (attrs != null && attrs.contains((Object)Attr.REVERSE)) {
            return this.color[bgIndex];
        }
        return this.color[fgIndex];
    }

    public Color getBG(JScreenCell cell) {
        return this.getBG(cell.fg, cell.bg, cell.attrs);
    }

    public Color getBG(int fgIndex, int bgIndex, EnumSet<Attr> attrs) {
        if (attrs != null && attrs.contains((Object)Attr.REVERSE)) {
            return this.color[fgIndex];
        }
        return this.color[bgIndex];
    }
}

