/*
 * Decompiled with CFR 0.152.
 */
package net.digger.ui.screen;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import net.digger.ui.screen.JScreenCell;
import net.digger.ui.screen.JScreenRegion;
import net.digger.ui.screen.JScreenWindowState;
import net.digger.ui.screen.charmap.JScreenCharMap;
import net.digger.ui.screen.color.Attr;
import net.digger.ui.screen.color.JScreenPalette;
import net.digger.ui.screen.cursor.JScreenCursor;
import net.digger.ui.screen.font.JScreenFont;
import net.digger.ui.screen.io.JScreenKeyboard;
import net.digger.ui.screen.io.JScreenSound;
import net.digger.ui.screen.mode.JScreenMode;
import net.digger.ui.screen.protocol.JScreenTextProtocol;
import net.digger.ui.screen.protocol.PlainText;
import net.digger.util.Pause;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class JScreen
implements Closeable {
    private static final String VERSION = "1.2.0";
    private static final String COPYRIGHT = "\u00a92017,2018";
    private static final String DEFAULT_WINDOW_TITLE = "JScreen";
    private static final JScreenMode DEFAULT_SCREEN_MODE = JScreenMode.DEFAULT_MODE;
    private final JScreenComponent screen;
    private JPopupMenu menu = null;
    private JMenu scaleMenu = null;
    private JMenu fontMenu = null;
    private JScreenCell[][] cells;
    private Rectangle screenCells;
    private Rectangle screenPixels;
    private Dimension cellSize;
    private JScreenPalette palette;
    private int fgColor;
    private int bgColor;
    private EnumSet<Attr> attrs = EnumSet.noneOf(Attr.class);
    private ScrollFillMethod scrollFillMethod = ScrollFillMethod.DEFAULT;
    private JScreenFont[] fonts;
    private int font;
    private int fontScale;
    private int maxFontScale = 1;
    private Rectangle window;
    private JScreenCursor cursorRenderer;
    private Point cursor = new Point(0, 0);
    private boolean cursorVisible = true;
    private boolean cursorBlink = true;
    private ScheduledFuture<?> cursorBlinker = null;
    private JScreenTextProtocol protocol;
    private JScreenCharMap charMap;
    private boolean scanLines = false;
    private ScheduledThreadPoolExecutor scheduler = null;
    private boolean blinkingChars = false;
    private boolean blinked = false;
    private Point selectionStarted = null;
    private Rectangle selection = null;
    public final JScreenKeyboard keyboard;
    public final JScreenSound sound;

    public JScreen() {
        this(null, null);
    }

    public JScreen(JScreenMode mode) {
        this(mode, null);
    }

    public JScreen(JScreenMode mode, String copyright) {
        mode = mode == null ? DEFAULT_SCREEN_MODE : mode;
        this.screen = new JScreenComponent(this::paintScreen);
        this.setScreenMode(mode);
        this.setTextProtocol(new PlainText(this));
        this.screen.setEnabled(true);
        this.screen.setFocusable(true);
        this.screen.setFocusTraversalKeysEnabled(false);
        this.keyboard = new JScreenKeyboard(this);
        this.sound = new JScreenSound();
        this.screen.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                switch (e.getClickCount()) {
                    case 3: {
                        this.doTripleClick(e);
                        break;
                    }
                    case 2: {
                        this.doDoubleClick(e);
                        break;
                    }
                    default: {
                        this.doClick(e);
                    }
                }
            }

            private void doClick(MouseEvent e) {
                JScreen.this.selectionStarted = null;
                JScreen.this.clearSelection();
            }

            private void doDoubleClick(MouseEvent e) {
                boolean space;
                Point clicked = JScreen.this.findCell(e.getPoint());
                int startX = clicked.x;
                int endX = clicked.x;
                int y = clicked.y;
                boolean bl = space = JScreen.this.getCellChar(startX, y) == ' ';
                while (--startX >= 0 && this.checkChar(JScreen.this.getCellChar(startX, y), space)) {
                }
                ++startX;
                while (++endX < ((JScreen)JScreen.this).screenCells.width && this.checkChar(JScreen.this.getCellChar(endX, y), space)) {
                }
                JScreen.this.selectCells(new Rectangle(startX, y, --endX - startX + 1, 1));
            }

            private void doTripleClick(MouseEvent e) {
                Point clicked = JScreen.this.findCell(e.getPoint());
                int startX = 0;
                int endX = ((JScreen)JScreen.this).screenCells.width - 1;
                int y = clicked.y;
                JScreen.this.selectCells(new Rectangle(startX, y, endX - startX + 1, 1));
            }

            private boolean checkChar(char ch, boolean space) {
                return space ? ch == ' ' : ch != ' ';
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JScreen.this.selectionStarted = JScreen.this.findCell(e.getPoint());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JScreen.this.selectionStarted = null;
            }
        });
        this.screen.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (JScreen.this.selectionStarted != null) {
                    Point cell = JScreen.this.findCell(e.getPoint());
                    JScreen.this.selectCells(new Rectangle(Math.min(((JScreen)JScreen.this).selectionStarted.x, cell.x), Math.min(((JScreen)JScreen.this).selectionStarted.y, cell.y), Math.abs(cell.x - ((JScreen)JScreen.this).selectionStarted.x) + 1, Math.abs(cell.y - ((JScreen)JScreen.this).selectionStarted.y) + 1));
                }
            }
        });
        this.menu = new JPopupMenu();
        this.screen.setComponentPopupMenu(this.menu);
        if (copyright != null) {
            this.menu.add(new JMenuItem(copyright));
        }
        this.menu.add(new JMenuItem("JScreen v1.2.0 \u00a92017,2018 by David Walton"));
        JMenuItem copy = new JMenuItem("Copy selection text to clipboard");
        this.menu.add(copy);
        copy.addActionListener(e -> this.copySelectionToClipboard());
        JMenuItem paste = new JMenuItem("Paste text to keyboard buffer");
        this.menu.add(paste);
        paste.addActionListener(e -> {
            if (this.keyboard != null) {
                this.keyboard.pasteClipboard();
            }
        });
        this.fontMenu = new JMenu("Fonts");
        this.menu.add(this.fontMenu);
        this.addFontMenus();
        this.scaleMenu = new JMenu("Font Scale");
        this.menu.add(this.scaleMenu);
        this.addFontScaleMenus();
        this.startBlinker(mode.blinkRate);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                JScreen.this.close();
            }
        });
    }

    private void startBlinker(double blinkRate) {
        if (this.scheduler == null) {
            this.scheduler = new ScheduledThreadPoolExecutor(1);
            this.scheduler.setRemoveOnCancelPolicy(true);
        }
        if (this.cursorBlinker != null) {
            this.cursorBlinker.cancel(false);
        }
        this.cursorBlinker = this.scheduler.scheduleAtFixedRate(() -> {
            boolean bl = this.blinked = !this.blinked;
            if (this.blinkingChars) {
                boolean found = false;
                for (int y = 0; y < this.screenCells.height; ++y) {
                    for (int x = 0; x < this.screenCells.width; ++x) {
                        JScreenCell cell = this.cells[y][x];
                        if (!cell.attrs.contains((Object)Attr.BLINKING)) continue;
                        found = true;
                        cell.setAttr(Attr._IS_BLINKED, this.blinked);
                        this.screen.repaint(this.cellPixels(x, y));
                    }
                }
                if (!found) {
                    this.blinkingChars = false;
                }
            }
            if (this.cursorVisible && this.cursorBlink) {
                JScreenCell cell = this.cells[this.cursor.y][this.cursor.x];
                cell.setAttr(Attr._IS_BLINKED, this.blinked);
                this.screen.repaint(this.cellPixels(this.cursor));
            }
        }, 0L, (int)(1000.0 / blinkRate), TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.shutdownNow();
        }
    }

    public static JScreen createJScreenWindow() {
        return JScreen.createJScreenWindow(DEFAULT_WINDOW_TITLE, null, null);
    }

    public static JScreen createJScreenWindow(String title) {
        return JScreen.createJScreenWindow(title, null, null);
    }

    public static JScreen createJScreenWindow(String title, JScreenMode mode) {
        return JScreen.createJScreenWindow(title, mode, null);
    }

    public static JScreen createJScreenWindow(String title, JScreenMode mode, String copyright) {
        JScreen screen = new JScreen(mode, copyright);
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame(title);
            frame.setDefaultCloseOperation(3);
            frame.setLayout(new BorderLayout());
            frame.setResizable(false);
            frame.add((Component)screen.getComponent(), "Center");
            frame.pack();
            frame.setLocationRelativeTo(null);
            frame.setLocationByPlatform(true);
            frame.setVisible(true);
        });
        return screen;
    }

    public void resetTextColors() {
        this.setFGColor(this.palette.defaultFG);
        this.setBGColor(this.palette.defaultBG);
        this.attrs = this.createAttrSet(null);
    }

    public void setTextColors(int fg, int bg, Attr ... attrs) {
        this.setFGColor(fg);
        this.setBGColor(bg);
        this.attrs = this.createAttrSet(attrs);
    }

    public void setFGColor(int fg) {
        this.fgColor = fg;
    }

    public void setBGColor(int bg) {
        this.bgColor = bg;
    }

    public int[] getTextColors() {
        return new int[]{this.fgColor, this.bgColor};
    }

    public int getTextFGColor() {
        return this.fgColor;
    }

    public int getTextBGColor() {
        return this.bgColor;
    }

    public int[] getCellColors(Point coord) {
        JScreenCell cell = this.getWindowCell(coord);
        return new int[]{cell.fg, cell.bg};
    }

    public int[] getCellColors(int x, int y) {
        JScreenCell cell = this.getWindowCell(x, y);
        return new int[]{cell.fg, cell.bg};
    }

    public int getCellFGColor(Point coord) {
        return this.getWindowCell((Point)coord).fg;
    }

    public int getCellFGColor(int x, int y) {
        return this.getWindowCell((int)x, (int)y).fg;
    }

    public int getCellBGColor(Point coord) {
        return this.getWindowCell((Point)coord).bg;
    }

    public int getCellBGColor(int x, int y) {
        return this.getWindowCell((int)x, (int)y).bg;
    }

    public void setScrollFillMethod(ScrollFillMethod method) {
        this.scrollFillMethod = method;
    }

    public void setTextAttr(Attr attr, boolean on) {
        if (on) {
            this.attrs.add(attr);
        } else {
            this.attrs.remove((Object)attr);
        }
    }

    public void toggleTextAttr(Attr attr) {
        if (this.attrs.contains((Object)attr)) {
            this.attrs.remove((Object)attr);
        } else {
            this.attrs.add(attr);
        }
    }

    public boolean getTextAttr(Attr attr) {
        return this.attrs.contains((Object)attr);
    }

    public void clearTextAttrs() {
        this.attrs.clear();
    }

    public void setCellAttr(Point coord, Attr attr, boolean on) {
        this.setCellAttr(coord.x, coord.y, attr, on);
    }

    public void setCellAttr(int x, int y, Attr attr, boolean on) {
        JScreenCell cell = this.getWindowCell(x, y);
        cell.setAttr(attr, on);
        if (attr == Attr.BLINKING && on) {
            this.blinkingChars = true;
        }
        this.screen.repaint(this.cellPixels(x, y));
    }

    public void toggleCellAttr(Point coord, Attr attr) {
        this.toggleCellAttr(coord.x, coord.y, attr);
    }

    public void toggleCellAttr(int x, int y, Attr attr) {
        JScreenCell cell = this.getWindowCell(x, y);
        cell.toggleAttr(attr);
        if (cell.attrs.contains((Object)Attr.BLINKING)) {
            this.blinkingChars = true;
        }
        this.screen.repaint(this.cellPixels(x, y));
    }

    public boolean getCellAttr(Point coord, Attr attr) {
        return this.getWindowCell((Point)coord).attrs.contains((Object)attr);
    }

    public boolean getCellAttr(int x, int y, Attr attr) {
        return this.getWindowCell((int)x, (int)y).attrs.contains((Object)attr);
    }

    private EnumSet<Attr> createAttrSet(Attr ... attrs) {
        EnumSet<Attr> set = EnumSet.noneOf(Attr.class);
        if (attrs != null) {
            for (Attr attr : attrs) {
                if (attr == null) continue;
                set.add(attr);
            }
        }
        return set;
    }

    public void setScreenMode(JScreenMode mode) {
        this.charMap = mode.charMap;
        this.scanLines = mode.scanLines;
        this.cursorRenderer = mode.cursor;
        this.palette = mode.palette;
        this.setTextColors(this.palette.defaultFG, this.palette.defaultBG, new Attr[0]);
        this.setTextFonts(mode.font);
        this.setTextScreenSize(new Dimension(mode.width, mode.height));
        this.startBlinker(mode.blinkRate);
    }

    public Dimension getTextScreenSize() {
        return new Dimension(this.screenCells.getSize());
    }

    public Dimension getTextScreenPixels() {
        return new Dimension(this.screenPixels.getSize());
    }

    public void setTextScreenSize(Dimension size) {
        this.screenCells = new Rectangle(size);
        this.window = new Rectangle(this.screenCells);
        this.cells = JScreenRegion.createCellGrid(this.screenCells.getSize());
        this.setFontScale();
        this.clearScreen();
    }

    public void setTextFonts(JScreenFont ... fonts) {
        if (ArrayUtils.isEmpty(fonts)) {
            throw new IllegalArgumentException("Must provide at least one font!");
        }
        this.fonts = fonts;
        for (int i = 0; i < fonts.length; ++i) {
            System.out.println("Font " + i + " family: " + fonts[i].getFamily());
        }
        this.addFontMenus();
        this.setFontScale();
    }

    public void setTextFont(int font) {
        if (ArrayUtils.isNotEmpty(this.fonts) && font >= 0 && font < this.fonts.length) {
            this.font = font;
        }
    }

    public int getTextFont() {
        return this.font;
    }

    public int getCellFont(Point coord) {
        JScreenCell cell = this.getWindowCell(coord);
        return cell.font;
    }

    public int getCellFont(int x, int y) {
        JScreenCell cell = this.getWindowCell(x, y);
        return cell.font;
    }

    public void setFontScale() {
        if (this.screenCells == null || ArrayUtils.isEmpty(this.fonts)) {
            return;
        }
        this.setMaxFontScale();
        this.setFontScale(this.maxFontScale - 1);
    }

    private void setMaxFontScale() {
        if (this.screenCells == null || ArrayUtils.isEmpty(this.fonts)) {
            return;
        }
        Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Dimension size = null;
        for (JScreenFont font : this.fonts) {
            Dimension fsize = font.getCellSize(1);
            if (size == null) {
                size = fsize;
                continue;
            }
            if (size.equals(fsize)) continue;
            throw new IllegalArgumentException("All fonts must have the same cell size!");
        }
        int xScale = bounds.width / (this.screenCells.width * size.width);
        int yScale = bounds.height / (this.screenCells.height * size.height);
        this.maxFontScale = Math.max(1, Math.min(xScale, yScale)) + 1;
        this.addFontScaleMenus();
    }

    public void setFontScale(int scale) {
        if (this.screenCells == null || ArrayUtils.isEmpty(this.fonts)) {
            return;
        }
        this.fontScale = scale;
        this.cellSize = this.fonts[0].getCellSize(this.fontScale);
        this.screenPixels = new Rectangle(this.screenCells.width * this.cellSize.width, this.screenCells.height * this.cellSize.height);
        this.addFontScaleMenus();
        this.setPreferredSize();
    }

    public void setCursor(int x, int y) {
        this.setAbsCursor(this.windowCoordToScreen(x, y));
    }

    public void setCursor(Point coord) {
        this.setAbsCursor(this.windowPointToScreen(coord));
    }

    public Point getCursor() {
        return new Point(this.cursor.x - this.window.x, this.cursor.y - this.window.y);
    }

    public void showCursor() {
        this.cursorVisible = true;
    }

    public void hideCursor() {
        this.cursorVisible = false;
    }

    public void blinkCursor(boolean blink) {
        this.cursorBlink = blink;
    }

    private void advanceCursor() {
        int newX = this.cursor.x + 1;
        if (newX >= this.window.x + this.window.width) {
            this.carriageReturn();
            this.lineFeed();
        } else {
            this.setAbsCursor(newX, this.cursor.y);
        }
    }

    public void carriageReturn() {
        this.setAbsCursor(this.window.x, this.cursor.y);
    }

    public void lineFeed() {
        int newY = this.cursor.y + 1;
        if (newY >= this.window.y + this.window.height) {
            this.scrollWindowUp();
            --newY;
        }
        this.setAbsCursor(this.cursor.x, newY);
    }

    public void backspace() {
        if (this.cursor.x == this.window.x) {
            return;
        }
        int newX = this.cursor.x - 1;
        this.cells[this.cursor.y][newX].ch = (char)32;
        this.cells[this.cursor.y][newX].attrs.clear();
        this.setAbsCursor(newX, this.cursor.y);
    }

    private void setAbsCursor(Point cursor) {
        this.setAbsCursor(cursor.x, cursor.y);
    }

    private void setAbsCursor(int x, int y) {
        int oldX = this.cursor.x;
        int oldY = this.cursor.y;
        this.cursor.x = x;
        this.cursor.y = y;
        if (this.cursorVisible) {
            this.screen.repaint(this.cellPixels(oldX, oldY));
            this.screen.repaint(this.cellPixels(this.cursor));
        }
    }

    public void setWindow(int left, int top, int width, int height) {
        this.setTextWindow(left, top, width, height);
        this.setCursor(0, 0);
    }

    public void setWindow(Rectangle region) {
        this.setTextWindow(region.x, region.y, region.width, region.height);
        this.setCursor(0, 0);
    }

    private void setTextWindow(int left, int top, int width, int height) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Window must be at least 1x1.");
        }
        Rectangle region = new Rectangle(left, top, width, height);
        this.checkRegionInScreen(region);
        this.window = region;
    }

    public void adjustWindow(int dx, int dy, int dw, int dh) {
        this.setTextWindow(this.window.x + dx, this.window.y + dy, this.window.width + dw, this.window.height + dh);
        if (!this.window.contains(this.cursor)) {
            this.setCursor(0, 0);
        }
    }

    public void moveWindow(int dx, int dy) {
        this.adjustWindow(dx, dy, 0, 0);
    }

    public void resizeWindow(int dw, int dh) {
        this.adjustWindow(0, 0, dw, dh);
    }

    public Rectangle getWindow() {
        return new Rectangle(this.window);
    }

    public JScreenWindowState saveWindowState() {
        JScreenWindowState state = new JScreenWindowState();
        state.window = this.getWindow();
        state.cursor = this.getCursor();
        state.cursorVisible = this.cursorVisible;
        state.cursorBlink = this.cursorBlink;
        state.font = this.font;
        state.fgColor = this.fgColor;
        state.bgColor = this.bgColor;
        state.attrs = EnumSet.copyOf(this.attrs);
        return state;
    }

    public void restoreWindowState(JScreenWindowState state) {
        this.setWindow(state.window);
        this.setCursor(state.cursor);
        this.cursorVisible = state.cursorVisible;
        this.cursorBlink = state.cursorBlink;
        this.font = state.font;
        this.fgColor = state.fgColor;
        this.bgColor = state.bgColor;
        this.attrs = EnumSet.copyOf(state.attrs);
    }

    public void frameWindow(String title, char[] frame) {
        this.frameWindow(title, frame, null, null, null);
    }

    public void frameWindow(String title, char[] frame, Integer frameFG, Integer frameBG, Attr ... frameAttrs) {
        Point coord = new Point(0, 0);
        if (frame != null) {
            if (frameFG == null) {
                frameFG = this.fgColor;
            }
            if (frameBG == null) {
                frameBG = this.bgColor;
            }
            if (frameAttrs == null) {
                frameAttrs = this.attrs.toArray(new Attr[0]);
            }
            this.putChar(coord, frame[0], (int)frameFG, (int)frameBG, frameAttrs);
            ++coord.x;
            this.putChars(coord, frame[1], this.window.width - 2, (int)frameFG, (int)frameBG, frameAttrs);
            coord.x = this.window.width - 1;
            this.putChar(coord, frame[2], (int)frameFG, (int)frameBG, frameAttrs);
        }
        if (title != null) {
            if (frame != null && frame.length > 9) {
                title = StringUtils.substring(title, 0, this.window.width - 4);
                coord.x = (this.window.width - title.length()) / 2;
                this.putChar(coord.x - 1, coord.y, frame[8], (int)frameFG, frameBG, frameAttrs);
                this.putStr(coord, title);
                this.putChar(coord.x + title.length(), coord.y, frame[9], (int)frameFG, frameBG, frameAttrs);
            } else {
                title = StringUtils.substring(title, 0, this.window.width - 2);
                coord.x = (this.window.width - title.length()) / 2;
                this.putStr(coord, title);
            }
        }
        if (frame != null) {
            int y = 1;
            while (y < this.window.height) {
                coord.y = y++;
                coord.x = 0;
                this.putChar(coord, frame[3], (int)frameFG, (int)frameBG, frameAttrs);
                coord.x = this.window.width - 1;
                this.putChar(coord, frame[4], (int)frameFG, (int)frameBG, frameAttrs);
            }
            coord.y = this.window.height - 1;
            coord.x = 0;
            this.putChar(coord, frame[5], (int)frameFG, (int)frameBG, frameAttrs);
            ++coord.x;
            this.putChars(coord, frame[6], this.window.width - 2, (int)frameFG, (int)frameBG, frameAttrs);
            coord.x = this.window.width - 1;
            this.putChar(coord, frame[7], (int)frameFG, (int)frameBG, frameAttrs);
        }
        this.adjustWindow(1, 1, -2, -2);
    }

    public void unframeWindow() {
        this.adjustWindow(-1, -1, 2, 2);
    }

    private Point windowPointToScreen(Point coord) {
        return this.windowCoordToScreen(coord.x, coord.y);
    }

    private Point windowCoordToScreen(int x, int y) {
        Point coord = new Point(this.window.x + x, this.window.y + y);
        this.checkCellInWindow(coord);
        return coord;
    }

    private Rectangle windowRegionToScreen(Rectangle region) {
        region = new Rectangle(region);
        region.translate(this.window.x, this.window.y);
        this.checkRegionInWindow(region);
        return region;
    }

    private void putCellChar(Point coord, char ch, int count, int fg, int bg, EnumSet<Attr> attrs) {
        int x;
        if (this.charMap != null) {
            ch = this.charMap.mapChar(ch).charValue();
        }
        for (int i = 0; i < count && (x = coord.x + i) <= this.window.x + this.window.width - 1; ++i) {
            JScreenCell cell = this.cells[coord.y][x];
            cell.fg = fg;
            cell.bg = bg;
            cell.ch = ch;
            cell.font = this.font;
            cell.setAttrs(attrs);
            this.screen.repaint(this.cellPixels(x, coord.y));
        }
        if (attrs.contains((Object)Attr.BLINKING)) {
            this.blinkingChars = true;
        }
    }

    public void putChars(Point coord, char ch, int count, int fg, int bg, Attr ... attrs) {
        EnumSet<Attr> set = this.createAttrSet(attrs);
        this.putCellChar(this.windowPointToScreen(coord), ch, count, fg, bg, set);
    }

    public void putChars(int x, int y, char ch, int count, int fg, int bg, Attr ... attrs) {
        EnumSet<Attr> set = this.createAttrSet(attrs);
        this.putCellChar(this.windowCoordToScreen(x, y), ch, count, fg, bg, set);
    }

    public void putChar(Point coord, char ch, int fg, int bg, Attr ... attrs) {
        EnumSet<Attr> set = this.createAttrSet(attrs);
        this.putCellChar(this.windowPointToScreen(coord), ch, 1, fg, bg, set);
    }

    public void putChar(int x, int y, char ch, int fg, int bg, Attr ... attrs) {
        EnumSet<Attr> set = this.createAttrSet(attrs);
        this.putCellChar(this.windowCoordToScreen(x, y), ch, 1, fg, bg, set);
    }

    public void putChar(Point coord, char ch) {
        this.putCellChar(this.windowPointToScreen(coord), ch, 1, this.fgColor, this.bgColor, this.attrs);
    }

    public void putChar(int x, int y, char ch) {
        this.putCellChar(this.windowCoordToScreen(x, y), ch, 1, this.fgColor, this.bgColor, this.attrs);
    }

    public void putChar(char ch, int fg, int bg, Attr ... attrs) {
        EnumSet<Attr> set = this.createAttrSet(attrs);
        this.putCellChar(this.cursor, ch, 1, fg, bg, set);
        this.advanceCursor();
    }

    public void putChar(char ch) {
        this.putCellChar(this.cursor, ch, 1, this.fgColor, this.bgColor, this.attrs);
        this.advanceCursor();
    }

    public char getWindowCellChar(Point coord) {
        return this.getWindowCellChar(coord.x, coord.y);
    }

    public char getWindowCellChar(int x, int y) {
        char ch = this.getWindowCell((int)x, (int)y).ch;
        if (this.charMap != null) {
            ch = this.charMap.unmapChar(ch).charValue();
        }
        return ch;
    }

    public char getCellChar(Point coord) {
        return this.getCellChar(coord.x, coord.y);
    }

    public char getCellChar(int x, int y) {
        char ch = this.getCell((int)x, (int)y).ch;
        if (this.charMap != null) {
            ch = this.charMap.unmapChar(ch).charValue();
        }
        return ch;
    }

    public void putStr(Point coord, String str, int fg, int bg, Attr ... attrs) {
        this.putStr(coord.x, coord.y, str, fg, bg, attrs);
    }

    public void putStrCentered(String str, int fg, int bg, Attr ... attrs) {
        str = StringUtils.substring(str, 0, this.window.width);
        int x = (this.window.width - str.length()) / 2;
        this.putStr(x, this.cursor.y - this.window.y, str, fg, bg, attrs);
    }

    public void putStr(int x, int y, String str, int fg, int bg, Attr ... attrs) {
        if (StringUtils.isEmpty(str)) {
            return;
        }
        Point coord = this.windowCoordToScreen(x, y);
        EnumSet<Attr> set = this.createAttrSet(attrs);
        for (int i = 0; i < str.length(); ++i) {
            this.putCellChar(coord, str.charAt(i), 1, fg, bg, set);
            ++coord.x;
            if (coord.x > this.window.x + this.window.width - 1) break;
        }
    }

    public void putStr(Point coord, String str) {
        this.putStr(coord.x, coord.y, str);
    }

    public void putStrCentered(String str) {
        this.putStrCentered(str, this.fgColor, this.bgColor, this.attrs.toArray(new Attr[0]));
    }

    public void putStr(int x, int y, String str) {
        this.putStr(x, y, str, this.fgColor, this.bgColor, this.attrs.toArray(new Attr[0]));
    }

    public void putStr(String str, int fg, int bg, Attr ... attrs) {
        if (StringUtils.isEmpty(str)) {
            return;
        }
        EnumSet<Attr> set = this.createAttrSet(attrs);
        for (int i = 0; i < str.length(); ++i) {
            this.putCellChar(this.cursor, str.charAt(i), 1, fg, bg, set);
            this.advanceCursor();
        }
    }

    public void putStr(String str) {
        if (StringUtils.isEmpty(str)) {
            return;
        }
        for (int i = 0; i < str.length(); ++i) {
            this.putChar(str.charAt(i));
        }
    }

    public void print(char ch) {
        if (this.protocol == null) {
            this.putChar(ch);
        } else {
            this.protocol.print(ch);
        }
    }

    public void print(Object ... params) {
        for (Object param : params) {
            if (param == null) continue;
            this.print(param.toString());
        }
    }

    public void print(String str) {
        if (StringUtils.isEmpty(str)) {
            return;
        }
        for (int i = 0; i < str.length(); ++i) {
            this.print(str.charAt(i));
        }
    }

    public void printf(String format, Object ... args) {
        this.print(String.format(format, args));
    }

    public void println(Object ... params) {
        for (Object param : params) {
            this.print(param.toString());
        }
        this.println();
    }

    public void println(String str) {
        this.print(str);
        this.println();
    }

    public void println() {
        this.print("\r\n");
    }

    public void printBPS(int bps, Object ... params) {
        for (Object param : params) {
            if (param == null) continue;
            this.printBPS(bps, param.toString());
        }
    }

    public void printBPS(int bps, String str) {
        int wait = (int)(1000000.0 / ((double)bps / 8.0));
        for (int i = 0; i < str.length(); ++i) {
            this.print(str.charAt(i));
            Pause.micro(wait);
        }
    }

    public void printlnBPS(int bps, Object ... params) {
        for (Object param : params) {
            this.printBPS(bps, param.toString());
        }
        this.printlnBPS(bps);
    }

    public void printlnBPS(int bps, String str) {
        this.printBPS(bps, str);
        this.printlnBPS(bps);
    }

    public void printlnBPS(int bps) {
        this.printBPS(bps, "\r\n");
    }

    public void fillScreen(Character ch, Integer fg, Integer bg, Attr ... attrs) {
        this.fillCells(this.screenCells, ch, fg, bg, attrs);
    }

    public void fillWindow(Character ch, Integer fg, Integer bg, Attr ... attrs) {
        this.fillCells(this.window, ch, fg, bg, attrs);
    }

    public void fillRegion(Rectangle region, Character ch, Integer fg, Integer bg, Attr ... attrs) {
        this.fillCells(this.windowRegionToScreen(region), ch, fg, bg, attrs);
    }

    private void fillCells(Rectangle region, Character ch, Integer fg, Integer bg, Attr ... attrs) {
        if (region.width < 1 || region.height < 1) {
            return;
        }
        for (int y = region.y; y < region.y + region.height; ++y) {
            for (int x = region.x; x < region.x + region.width; ++x) {
                JScreenCell cell = this.cells[y][x];
                if (ch != null) {
                    cell.ch = ch.charValue();
                    cell.font = this.font;
                }
                if (fg != null) {
                    cell.fg = fg;
                }
                if (bg != null) {
                    cell.bg = bg;
                }
                if (attrs == null) continue;
                cell.setAttrs(attrs);
            }
        }
        if (ArrayUtils.contains((Object[])attrs, (Object)Attr.BLINKING)) {
            this.blinkingChars = true;
        }
        this.screen.repaint(this.regionPixels(region));
    }

    public void clearScreen() {
        this.setWindow(this.screenCells);
        this.clearTextAttrs();
        this.clearWindow();
    }

    public void clearWindow() {
        this.clearCells(this.window);
        this.setCursor(0, 0);
    }

    public void clearRegion(Rectangle region) {
        this.clearCells(this.windowRegionToScreen(region));
    }

    public void clearLine() {
        this.clearCells(new Rectangle(this.window.x, this.cursor.y, this.window.width, 1));
    }

    public void clearToEOL() {
        this.clearCells(new Rectangle(this.cursor.x, this.cursor.y, this.window.x + this.window.width - this.cursor.x, 1));
    }

    public void clearToBOL() {
        this.clearCells(new Rectangle(this.window.x, this.cursor.y, this.cursor.x - this.window.x + 1, 1));
    }

    public void clearToTop() {
        this.clearToBOL();
        this.clearCells(new Rectangle(this.window.x, this.window.y, this.window.width, this.cursor.y - this.window.y));
    }

    public void clearToBottom() {
        this.clearToEOL();
        this.clearCells(new Rectangle(this.window.x, this.cursor.y + 1, this.window.width, this.window.y + this.window.height - 1 - this.cursor.y));
    }

    private void clearCells(Rectangle region) {
        this.fillCells(region, Character.valueOf(' '), this.fgColor, this.bgColor, new Attr[0]);
    }

    public JScreenRegion readScreen() {
        return this.readCells(this.screenCells);
    }

    public JScreenRegion readWindow() {
        return this.readCells(this.window);
    }

    public JScreenRegion readRegion(Rectangle region) {
        return this.readCells(this.windowRegionToScreen(region));
    }

    private JScreenRegion readCells(Rectangle region) {
        JScreenRegion data = new JScreenRegion(region.getSize());
        if (region.width < 1 || region.height < 1) {
            return data;
        }
        for (int sy = region.y; sy < region.y + region.height; ++sy) {
            for (int sx = region.x; sx < region.x + region.width; ++sx) {
                int dx = sx - region.x;
                int dy = sy - region.y;
                JScreenCell src = this.cells[sy][sx];
                JScreenCell dest = data.cells[dy][dx];
                dest.ch = src.ch;
                dest.font = src.font;
                dest.fg = src.fg;
                dest.bg = src.bg;
                dest.setAttrs(src.attrs);
            }
        }
        return data;
    }

    public void writeScreen(JScreenRegion data) {
        this.writeCells(this.screenCells, data);
    }

    public void writeWindow(JScreenRegion data) {
        this.writeCells(this.window, data);
    }

    public void writeRegion(Rectangle region, JScreenRegion data) {
        this.writeCells(this.windowRegionToScreen(region), data);
    }

    private void writeCells(Rectangle region, JScreenRegion data) {
        int bottom = region.y + Math.min(region.height, data.size.height);
        int right = region.x + Math.min(region.width, data.size.width);
        for (int dy = region.y; dy < bottom; ++dy) {
            for (int dx = region.x; dx < right; ++dx) {
                int sx = dx - region.x;
                int sy = dy - region.y;
                JScreenCell src = data.cells[sy][sx];
                JScreenCell dest = this.cells[dy][dx];
                dest.ch = src.ch;
                dest.font = src.font;
                dest.fg = src.fg;
                dest.bg = src.bg;
                dest.setAttrs(src.attrs);
                if (!dest.attrs.contains((Object)Attr.BLINKING)) continue;
                this.blinkingChars = true;
            }
        }
        this.screen.repaint(this.regionPixels(region));
    }

    public void scrollScreenUp() {
        this.scrollCellsUp(this.screenCells);
    }

    public void scrollWindowUp() {
        this.scrollCellsUp(this.window);
    }

    public void scrollRegionUp(Rectangle region) {
        this.scrollCellsUp(this.windowRegionToScreen(region));
    }

    public void deleteLine() {
        this.scrollCellsUp(new Rectangle(this.window.x, this.cursor.y, this.window.width, this.window.height - (this.cursor.y - this.window.y)));
    }

    private void scrollCellsUp(Rectangle region) {
        if (region.equals(this.screenCells)) {
            int bottom = this.screenCells.height - 1;
            for (int y = 0; y < bottom; ++y) {
                this.cells[y] = this.cells[y + 1];
            }
            this.cells[bottom] = JScreenRegion.createCellRow(this.screenCells.width);
            if (this.scrollFillMethod == ScrollFillMethod.CURRENT) {
                this.clearCells(new Rectangle(0, bottom, this.screenCells.width, 1));
            }
        } else {
            if (region.width < 1 || region.height < 1) {
                return;
            }
            int bottom = region.y + region.height - 1;
            int right = region.x + region.width - 1;
            for (int y = region.y; y <= bottom; ++y) {
                JScreenCell[] newRow = new JScreenCell[]{};
                if (region.x > 0) {
                    newRow = ArrayUtils.addAll(newRow, ArrayUtils.subarray(this.cells[y], 0, region.x));
                }
                newRow = y == bottom ? ArrayUtils.addAll(newRow, JScreenRegion.createCellRow(region.width)) : ArrayUtils.addAll(newRow, ArrayUtils.subarray(this.cells[y + 1], region.x, right + 1));
                if (right < this.screenCells.width - 1) {
                    newRow = ArrayUtils.addAll(newRow, ArrayUtils.subarray(this.cells[y], right + 1, this.screenCells.width));
                }
                this.cells[y] = newRow;
            }
            if (this.scrollFillMethod == ScrollFillMethod.CURRENT) {
                this.clearCells(new Rectangle(region.x, bottom, region.width, 1));
            }
        }
        this.screen.repaint(this.regionPixels(region));
    }

    public void scrollScreenDown() {
        this.scrollCellsDown(this.screenCells);
    }

    public void scrollWindowDown() {
        this.scrollCellsDown(this.window);
    }

    public void scrollRegionDown(Rectangle region) {
        this.scrollCellsDown(this.windowRegionToScreen(region));
    }

    public void insertLine() {
        this.scrollCellsDown(new Rectangle(this.window.x, this.cursor.y, this.window.width, this.window.height - (this.cursor.y - this.window.y)));
    }

    private void scrollCellsDown(Rectangle region) {
        if (region.equals(this.screenCells)) {
            int bottom;
            for (int y = bottom = this.screenCells.height - 1; y > 0; --y) {
                this.cells[y] = this.cells[y - 1];
            }
            this.cells[0] = JScreenRegion.createCellRow(this.screenCells.width);
            if (this.scrollFillMethod == ScrollFillMethod.CURRENT) {
                this.clearCells(new Rectangle(0, 0, this.screenCells.width, 1));
            }
        } else {
            if (region.width < 1 || region.height < 1) {
                return;
            }
            int bottom = region.y + region.height - 1;
            int right = region.x + region.width - 1;
            for (int y = bottom; y >= region.y; --y) {
                JScreenCell[] newRow = new JScreenCell[]{};
                if (region.x > 0) {
                    newRow = ArrayUtils.addAll(newRow, ArrayUtils.subarray(this.cells[y], 0, region.x));
                }
                newRow = y == region.y ? ArrayUtils.addAll(newRow, JScreenRegion.createCellRow(region.width)) : ArrayUtils.addAll(newRow, ArrayUtils.subarray(this.cells[y + 1], region.x, right + 1));
                if (right < this.screenCells.width - 1) {
                    newRow = ArrayUtils.addAll(newRow, ArrayUtils.subarray(this.cells[y], right + 1, this.screenCells.width));
                }
                this.cells[y] = newRow;
            }
            if (this.scrollFillMethod == ScrollFillMethod.CURRENT) {
                this.clearCells(new Rectangle(region.x, region.y, region.width, 1));
            }
        }
        this.screen.repaint(this.regionPixels(region));
    }

    public void selectScreen() {
        this.selectCells(this.screenCells);
    }

    public void selectWindow() {
        this.selectCells(this.window);
    }

    public void selectRegion(Rectangle region) {
        this.selectCells(this.windowRegionToScreen(region));
    }

    public void selectCells(Rectangle region) {
        Point ul = new Point(Math.max(this.screenCells.x, region.x), Math.max(this.screenCells.y, region.y));
        Point lr = new Point(Math.min(this.screenCells.width, region.x + region.width), Math.min(this.screenCells.height, region.y + region.height));
        Rectangle oldSelection = this.selection;
        this.selection = new Rectangle(ul.x, ul.y, lr.x - ul.x, lr.y - ul.y);
        if (oldSelection != null) {
            this.screen.repaint(this.regionPixels(oldSelection));
        }
        this.screen.repaint(this.regionPixels(this.selection));
    }

    public void copySelectionToClipboard() {
        if (this.selection != null) {
            ArrayList<String> text = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            for (int y = this.selection.y; y < this.selection.y + this.selection.height; ++y) {
                sb.setLength(0);
                for (int x = this.selection.x; x < this.selection.x + this.selection.width; ++x) {
                    sb.append(this.cells[y][x].ch);
                }
                text.add(sb.toString());
            }
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(StringUtils.join(text, '\n')), null);
            this.clearSelection();
        }
    }

    public void clearSelection() {
        Rectangle oldSelection = this.selection;
        this.selection = null;
        if (oldSelection != null) {
            this.screen.repaint(this.regionPixels(oldSelection));
        }
    }

    public void setTextProtocol(JScreenTextProtocol protocol) {
        this.protocol = protocol;
    }

    private void paintScreen(Graphics g) {
        Rectangle bounds = g.getClipBounds();
        Point coords = new Point(bounds.getLocation());
        Point ulCell = this.findCell(coords);
        ulCell.x = Math.max(0, ulCell.x);
        ulCell.y = Math.max(0, ulCell.y);
        coords.translate(bounds.width - 1, bounds.height - 1);
        Point lrCell = this.findCell(coords);
        lrCell.x = Math.min(lrCell.x, this.screenCells.width - 1);
        lrCell.y = Math.min(lrCell.y, this.screenCells.height - 1);
        for (int y = ulCell.y; y <= lrCell.y; ++y) {
            for (int x = ulCell.x; x <= lrCell.x; ++x) {
                Rectangle cellBounds = this.cellPixels(x, y);
                int font = this.cells[y][x].font;
                if (font >= 0 && font < this.fonts.length) {
                    if (this.selection != null && this.selection.contains(x, y)) {
                        this.cells[y][x].setAttr(Attr._IS_SELECTED, true);
                        this.fonts[font].drawChar(g, cellBounds, this.palette, this.cells[y][x], this.fontScale);
                        this.cells[y][x].setAttr(Attr._IS_SELECTED, false);
                    } else {
                        this.fonts[font].drawChar(g, cellBounds, this.palette, this.cells[y][x], this.fontScale);
                    }
                } else {
                    Color bg = this.palette.getBG(this.cells[y][x]);
                    g.setColor(bg);
                    g.fillRect(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height);
                }
                if (this.cursorRenderer == null || !this.cursorVisible || this.cursor.x != x || this.cursor.y != y || this.cursorBlink && this.cells[y][x].attrs.contains((Object)Attr._IS_BLINKED)) continue;
                this.cursorRenderer.drawCursor(g, cellBounds, this.palette.getFG(this.cells[y][x]), this.fontScale);
            }
        }
        if (this.scanLines && this.fontScale > 1) {
            g.setColor(Color.BLACK);
            Point ulCorner = this.cellOrigin(ulCell);
            Point lrCorner = this.cellOrigin(lrCell);
            lrCorner.translate(this.cellSize.width - 1, this.cellSize.height - 1);
            for (int y = ulCorner.y; y <= lrCorner.y; ++y) {
                if (!((double)(y % this.fontScale) >= (double)this.fontScale / 2.0)) continue;
                g.drawLine(ulCorner.x, y, lrCorner.x, y);
            }
        }
        Toolkit.getDefaultToolkit().sync();
    }

    private void setPreferredSize() {
        Dimension d = this.screenPixels.getSize();
        this.screen.setMinimumSize(d);
        this.screen.setPreferredSize(d);
        this.screen.setMaximumSize(d);
        JFrame frame = (JFrame)SwingUtilities.getRoot(this.screen);
        if (frame != null) {
            frame.pack();
        }
    }

    private JScreenCell getWindowCell(Point coord) {
        return this.getWindowCell(coord.x, coord.y);
    }

    private JScreenCell getWindowCell(int x, int y) {
        Point coord = this.windowCoordToScreen(x, y);
        return this.cells[coord.y][coord.x];
    }

    private JScreenCell getCell(Point coord) {
        this.checkCellInScreen(coord);
        return this.cells[coord.y][coord.x];
    }

    private JScreenCell getCell(int x, int y) {
        return this.getCell(new Point(x, y));
    }

    private Point cellOrigin(Point coord) {
        return this.cellOrigin(coord.x, coord.y);
    }

    private Point cellOrigin(int x, int y) {
        return new Point(x * this.cellSize.width, y * this.cellSize.height);
    }

    private Rectangle cellPixels(Point coord) {
        return this.cellPixels(coord.x, coord.y);
    }

    private Rectangle cellPixels(int x, int y) {
        return new Rectangle(this.cellOrigin(x, y), this.cellSize);
    }

    private Rectangle regionPixels(Rectangle region) {
        return this.regionPixels(region.x, region.y, region.width, region.height);
    }

    private Rectangle regionPixels(int left, int top, int width, int height) {
        Point start = this.cellOrigin(left, top);
        Point end = this.cellOrigin(left + width - 1, top + height - 1);
        end.translate(this.cellSize.width, this.cellSize.height);
        return new Rectangle(start.x, start.y, end.x - start.x + 1, end.y - start.y + 1);
    }

    private Point findCell(Point pixel) {
        return this.findCell(pixel.x, pixel.y);
    }

    private Point findCell(int x, int y) {
        Point coord = new Point();
        coord.x = x / this.cellSize.width;
        coord.y = y / this.cellSize.height;
        return coord;
    }

    private void checkCellInScreen(Point coord) {
        if (!this.screenCells.contains(coord)) {
            throw new IllegalArgumentException("Cell " + coord + " is off-screen (" + this.screenCells + ").");
        }
    }

    private void checkCellInWindow(Point coord) {
        if (!this.window.contains(coord)) {
            throw new IllegalArgumentException("Cell " + coord + " is outside of current window (" + this.window + ").");
        }
    }

    private void checkRegionInScreen(Rectangle region) {
        if (!this.screenCells.contains(region)) {
            throw new IllegalArgumentException("Cell region " + region + " is not on-screen (" + this.screenCells + ").");
        }
    }

    private void checkRegionInWindow(Rectangle region) {
        if (!this.window.contains(region)) {
            throw new IllegalArgumentException("Cell region " + region + " is outside of current window (" + this.window + ").");
        }
    }

    private void checkPixelInScreen(Point pixel) {
        if (!this.screenPixels.contains(pixel)) {
            throw new IllegalArgumentException("Pixel " + pixel + " is not on-screen (" + this.screenPixels + ").");
        }
    }

    public JPopupMenu getContextMenu() {
        return this.menu;
    }

    private void addFontScaleMenus() {
        if (this.scaleMenu != null) {
            this.scaleMenu.removeAll();
            ButtonGroup group = new ButtonGroup();
            for (int i = 1; i <= this.maxFontScale; ++i) {
                JRadioButtonMenuItem item = new JRadioButtonMenuItem("" + i + 'x');
                item.setSelected(this.fontScale == i);
                item.setActionCommand(String.valueOf(i));
                group.add(item);
                this.scaleMenu.add(item);
                item.addActionListener(e -> this.setFontScale(Integer.parseInt(e.getActionCommand())));
            }
        }
    }

    private void addFontMenus() {
        if (this.fontMenu != null) {
            this.fontMenu.removeAll();
            for (JScreenFont font : this.fonts) {
                this.fontMenu.add(new JMenuItem(font.getAbout()));
            }
        }
    }

    public JScreenComponent getComponent() {
        return this.screen;
    }

    public class JScreenComponent
    extends JComponent {
        private static final long serialVersionUID = 8329461748149292559L;
        private final Consumer<Graphics> painter;

        public JScreenComponent(Consumer<Graphics> painter) {
            this.painter = painter;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.painter.accept(g);
        }
    }

    public static enum ScrollFillMethod {
        DEFAULT,
        CURRENT;

    }
}

