/*
 * Decompiled with CFR 0.152.
 */
package net.digger.ui;

import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import net.digger.ui.screen.JScreen;
import net.digger.ui.screen.color.Attr;
import net.digger.ui.screen.font.IBMFont;
import net.digger.ui.screen.font.SystemFont;
import net.digger.ui.screen.mode.IBMScreenMode;
import net.digger.util.Pause;
import org.apache.commons.lang3.StringUtils;

public class JScreenTest {
    static JScreen screen;

    public static void main(String[] args) {
        SystemFont.getFonts();
        screen = JScreen.createJScreenWindow("JScreen test", IBMScreenMode.VGA_80x25);
        System.out.println(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds());
        JScreenTest.testComponent();
        screen.setCursor(0, 5);
        JScreenTest.printASCII(false);
        screen.setCursor(10, 1);
        screen.putStr(StringUtils.repeat('\u2591', 3));
        char ch = '\u00fa';
        screen.putChar(ch);
        System.out.println(ch);
        System.out.println(Integer.toHexString(ch));
        screen.setCursor(10, 2);
        screen.putStr(StringUtils.repeat('\u2592', 3));
        screen.setCursor(10, 3);
        screen.putStr(StringUtils.repeat('\u2593', 3));
        screen.print('\u0007');
        screen.setCursor(0, 15);
        JScreenTest.printASCII(true);
        screen.setTextAttr(Attr.REVERSE, true);
        screen.setCursor(20, 2);
        screen.print(' ');
        screen.setCursor(22, 2);
        screen.print(' ');
        screen.setCursor(21, 1);
        screen.print(' ');
        screen.setCursor(21, 3);
        screen.print(' ');
        screen.setTextAttr(Attr.REVERSE, false);
        screen.setCursor(21, 2);
        screen.print('\u2592');
        screen.setWindow(30, 1, 4, 4);
        screen.frameWindow("", IBMFont.SINGLE_FRAME, null, null, new Attr[0]);
        screen.print('\u2592');
        screen.blinkCursor(false);
    }

    private static void printASCII(boolean reverse) {
        screen.println("   0123456789ABCDEF0123456789ABCDEF");
        screen.setTextAttr(Attr.REVERSE, reverse);
        for (int l = 0; l < 8; ++l) {
            screen.print("" + Integer.toHexString(2 * l) + "x ");
            for (int c = 0; c < 32; ++c) {
                char ch = (char)(l * 32 + c);
                if (ch == '\u000f') {
                    screen.setTextAttr(Attr.BLINKING, true);
                }
                if (ch == '\u00b7') {
                    System.out.println(ch);
                    System.out.println(Integer.toHexString(ch));
                }
                screen.putChar(ch);
                screen.setTextAttr(Attr.BLINKING, false);
            }
            screen.println();
        }
        screen.setTextAttr(Attr.REVERSE, false);
    }

    private static void testComponent() {
        int i;
        JScreenTest.screen.keyboard.enableKeyBuffer(true);
        int width = JScreenTest.screen.getTextScreenSize().width;
        int height = JScreenTest.screen.getTextScreenSize().height;
        screen.putChar(0, 0, '1');
        screen.putChar(width - 1, 0, '2');
        screen.putChar(width - 1, height - 1, '3');
        screen.putChar(0, height - 1, '4');
        int left = width / 4;
        int right = width - left;
        int top = height / 4;
        int bottom = height - top;
        int w = right - left + 1;
        int h = bottom - top + 1;
        screen.fillRegion(new Rectangle(left, top, w, h), Character.valueOf('#'), 6, 6, Attr.BOLD);
        screen.setCellAttr(left + w / 2, bottom - 1, Attr.BLINKING, true);
        screen.setCellAttr(left + w / 2, bottom, Attr.BLINKING, true);
        Pause.second(2);
        Rectangle region = new Rectangle(left + 1, top + 1, w - 2, h - 2);
        screen.scrollRegionUp(region);
        int middle = width / 2;
        screen.setCursor(middle - 3, bottom - 1);
        screen.putStr("Scroll");
        for (i = 0; i < h - 3; ++i) {
            Pause.milli(50);
            screen.scrollRegionUp(region);
        }
        screen.setCursor(middle - 3, height - 1);
        screen.print("Scroll");
        for (i = 0; i < height - 1; ++i) {
            Pause.milli(50);
            screen.scrollScreenUp();
        }
    }
}

