/*
 * Decompiled with CFR 0.152.
 */
package net.digger.ui;

import java.awt.Rectangle;
import java.io.IOException;
import net.digger.ui.screen.JScreen;
import net.digger.ui.screen.JScreenRegion;
import net.digger.ui.screen.JScreenWindowState;
import net.digger.ui.screen.color.Attr;
import net.digger.ui.screen.font.IBMFont;
import net.digger.ui.screen.mode.IBMScreenMode;
import net.digger.ui.screen.protocol.ANSI;
import net.digger.ui.screen.protocol.CGAANSIColor;
import net.digger.util.Pause;

public class JScreenDemo {
    private JScreen screen = JScreen.createJScreenWindow("JScreenDemo", IBMScreenMode.VGA_80x25);
    private static final Rectangle textWin = new Rectangle(10, 3, 60, 5);
    private static final Rectangle demoWin = new Rectangle(20, 10, 40, 13);
    private static final int BPS = 300;
    private JScreenWindowState textWinSave;
    private JScreenWindowState demoWinSave;

    public static void main(String[] args) throws IOException {
        new JScreenDemo().run();
    }

    public JScreenDemo() {
        this.screen.setTextProtocol(new ANSI(this.screen, new CGAANSIColor()));
        this.screen.keyboard.clearKeyBuffer();
        this.screen.keyboard.enableKeyBuffer(true);
    }

    public void run() {
        this.screen.clearScreen();
        this.screen.setCursor(0, 1);
        this.screen.putStrCentered("JScreen", 7, 0, Attr.BOLD);
        this.screen.setWindow(textWin);
        this.textWinSave = this.screen.saveWindowState();
        this.screen.setWindow(demoWin);
        this.demoWinSave = this.screen.saveWindowState();
        this.writeTextWin("JScreen is a Java Swing component which provides a text", "screen display.  It was conceived to enable porting old", "DOS programs to a modern cross-platform environment, while", "retaining their original look and feel.");
        Pause.second(2);
        this.writeTextWin("JScreen can create its own window, as we have done here.", "Or it can be embedded as a component in your UI, using", "whatever screen dimensions you wish.");
        Pause.second(2);
        this.writeTextWin("With JScreen, you can create output windows in the screen,", "such as the one this text is in.  You can also frame those", "windows.");
        Pause.second(1);
        this.inDemoWin(() -> this.screen.frameWindow(null, IBMFont.DOUBLE_FRAME));
        Pause.second(2);
        this.writeTextWin("And put a title on the frame.");
        Pause.second(1);
        this.inDemoWin(() -> {
            this.screen.unframeWindow();
            this.screen.frameWindow("This is a title", IBMFont.DOUBLE_FRAME_SPACE);
        });
        Pause.second(2);
        this.writeTextWin("JScreen comes with fonts and character mapping to imitate", "a PC screen, as you see in this demo.  But it was also", "designed to enable emulating non-PC text modes, given", "suitable fonts and character mapping.");
        Pause.second(1);
        this.inDemoWin(() -> {
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 32; ++j) {
                    this.screen.putChar((char)(i * 32 + j));
                }
                this.screen.println();
            }
            this.screen.println();
        });
        Pause.second(2);
        this.writeTextWin("Naturally, you can also use colors...");
        Pause.second(1);
        this.inDemoWin(() -> {
            this.screen.setTextColors(1, 0, new Attr[0]);
            this.screen.print("Blue ");
            this.screen.setTextColors(2, 0, new Attr[0]);
            this.screen.print("Green ");
            this.screen.setTextColors(3, 0, new Attr[0]);
            this.screen.print("Cyan ");
            this.screen.setTextColors(4, 0, new Attr[0]);
            this.screen.print("Red ");
            this.screen.setTextColors(5, 0, new Attr[0]);
            this.screen.print("Magenta ");
            this.screen.setTextColors(6, 0, new Attr[0]);
            this.screen.print("Brown ");
            this.screen.println();
            this.screen.setTextColors(7, 0, new Attr[0]);
            this.screen.print("Light Grey ");
            this.screen.setTextColors(0, 0, Attr.BOLD);
            this.screen.print("Dark Grey ");
            this.screen.setTextColors(1, 0, Attr.BOLD);
            this.screen.print("Light Blue ");
            this.screen.println();
            this.screen.setTextColors(2, 0, Attr.BOLD);
            this.screen.print("Light Green ");
            this.screen.setTextColors(3, 0, Attr.BOLD);
            this.screen.print("Light Cyan ");
            this.screen.setTextColors(4, 0, Attr.BOLD);
            this.screen.print("Light Red ");
            this.screen.println();
            this.screen.setTextColors(5, 0, Attr.BOLD);
            this.screen.print("Light Magenta ");
            this.screen.setTextColors(6, 0, Attr.BOLD);
            this.screen.print("Yellow ");
            this.screen.setTextColors(7, 0, Attr.BOLD);
            this.screen.print("White ");
            this.screen.println();
            this.screen.setTextColors(7, 1, Attr.BOLD);
            this.screen.print("Yes, ");
            this.screen.setTextColors(3, 2, Attr.BOLD);
            this.screen.print("you ");
            this.screen.setTextColors(4, 3, Attr.BOLD);
            this.screen.print("get ");
            this.screen.setTextColors(1, 4, Attr.BOLD);
            this.screen.print("back");
            this.screen.setTextColors(6, 5, Attr.BOLD);
            this.screen.print("ground ");
            this.screen.setTextColors(5, 6, Attr.BOLD);
            this.screen.print("colors, ");
            this.screen.setTextColors(2, 7, Attr.BOLD);
            this.screen.print("too.");
            this.screen.resetTextColors();
            this.screen.println();
            this.screen.println();
        });
        Pause.second(2);
        this.writeTextWin("And, of course...");
        this.screen.setTextAttr(Attr.BLINKING, true);
        this.screen.print("        BLINK");
        this.screen.setTextAttr(Attr.BLINKING, false);
        this.screen.println();
        Pause.second(2);
        String ansi = "\u001b[1;30mA\u001b[31mN\u001b[32mS\u001b[33mI\u001b[5;34m!\u001b[25;35m!\u001b[36m!\u001b[37m!";
        this.writeTextWin("You can optionally turn on support for ANSI escape codes,", "to interpret strings like this one, as you can see below:");
        this.screen.print("    ");
        this.screen.putStr(ansi);
        this.screen.println();
        this.textWinSave = this.screen.saveWindowState();
        Pause.second(1);
        this.inDemoWin(() -> {
            this.screen.resetTextColors();
            this.screen.println(ansi);
        });
        Pause.second(2);
        this.writeTextWin("JScreen implements blocking keyboard input, so you can", "wait for a key press...");
        this.screen.print("<PRESS ANY KEY>");
        this.textWinSave = this.screen.saveWindowState();
        try {
            this.screen.keyboard.awaitKeyEvent();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.writeTextWin("", "Well Done!", "It also supports line input.");
        this.screen.printBPS(300, "Please enter your name: ");
        String name = "";
        try {
            name = this.screen.keyboard.readLine(20);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.textWinSave = this.screen.saveWindowState();
        this.writeTextWin("Thank you, " + name + ".");
        Pause.second(2);
        this.writeTextWin("With JScreen, you can save the contents of the screen,", "a window, or any arbitrary region, to restore later.", "We'll grab a snapshot of the window below before moving", "on...");
        Pause.second(1);
        this.screen.restoreWindowState(this.demoWinSave);
        JScreenRegion save = this.screen.readWindow();
        Pause.second(1);
        this.writeTextWin("JScreen allows you to fill the screen, a window, or any", "arbitrary region.");
        Pause.second(1);
        this.inDemoWin(() -> {
            this.screen.fillWindow(Character.valueOf('*'), 4, 1, new Attr[0]);
            Pause.second(1);
            this.screen.fillRegion(new Rectangle(15, 5, 20, 5), Character.valueOf('#'), 2, 0, new Attr[0]);
        });
        Pause.second(2);
        this.writeTextWin("And also scroll the screen, a window, or any", "arbitrary region.");
        Pause.second(1);
        this.inDemoWin(() -> {
            int delay = 250;
            Rectangle region = new Rectangle(5, 1, 20, 6);
            Pause.milli(delay);
            this.screen.scrollRegionUp(region);
            Pause.milli(delay);
            this.screen.scrollRegionUp(region);
            Pause.milli(delay);
            this.screen.scrollRegionUp(region);
            Pause.milli(delay);
            this.screen.scrollRegionUp(region);
            Pause.milli(delay);
            this.screen.scrollRegionUp(region);
            Pause.milli(delay);
        });
        Pause.second(2);
        this.writeTextWin("But how fast is JScreen, you ask?", "Let's fill that window with random characters and colors,", "10,000 times.");
        Pause.second(1);
        this.inDemoWin(() -> {
            for (int i = 0; i < 10000; ++i) {
                this.screen.setCursor(0, 0);
                for (int j = (JScreenDemo.demoWin.width - 2) * (JScreenDemo.demoWin.height - 2); j > 0; --j) {
                    if (j == 1) {
                        this.screen.putChar(JScreenDemo.demoWin.width - 3, JScreenDemo.demoWin.height - 3, (char)(Math.random() * 256.0), (int)(Math.random() * 8.0), (int)(Math.random() * 8.0), new Attr[0]);
                        continue;
                    }
                    this.screen.putChar((char)(Math.random() * 256.0), (int)(Math.random() * 8.0), (int)(Math.random() * 8.0), new Attr[0]);
                }
            }
        });
        Pause.second(2);
        this.writeTextWin("Fast enough for you?", "Now we'll restore the window contents we saved earlier.");
        Pause.second(1);
        this.inDemoWin(() -> this.screen.writeWindow(save));
        Pause.second(1);
        this.writeTextWin("That concludes our demo for now, but there is more JScreen", "can do.  Feel free to have a closer look.  Maybe it's", "exactly what you've been looking for.", "Or maybe it isn't.  That's cool, too.", "Thanks for watching!");
        Pause.second(2);
    }

    private void writeTextWin(String ... text) {
        this.screen.restoreWindowState(this.textWinSave);
        this.screen.printlnBPS(300);
        for (String str : text) {
            this.screen.printlnBPS(300, str);
        }
        this.textWinSave = this.screen.saveWindowState();
    }

    private void inDemoWin(Runnable stuff) {
        this.screen.restoreWindowState(this.demoWinSave);
        stuff.run();
        this.demoWinSave = this.screen.saveWindowState();
    }
}

