/*
 * Decompiled with CFR 0.152.
 */
package net.digger.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import net.digger.ui.screen.JScreen;
import net.digger.ui.screen.mode.IBMScreenMode;
import net.digger.ui.screen.protocol.ANSI;
import net.digger.ui.screen.protocol.ANSIColor;
import net.digger.ui.screen.protocol.CGAANSIColor;
import net.digger.util.Pause;

public class DisplayANSI {
    private static final int DEFAULT_BPS = 9600;
    private static final Map<Integer, String> SPEEDS = new TreeMap<Integer, String>(){
        {
            this.put(110, "110 baud Bell 101");
            this.put(300, "300 baud v.21");
            this.put(1200, "1200bps v.22");
            this.put(2400, "2400bps v.22bis");
            this.put(4800, "4800bps v.27ter");
            this.put(9600, "9600bps v.32");
            this.put(14400, "14.4kbps v.32bis");
            this.put(19200, "19.2kbps v.32terbo");
            this.put(28800, "28.8kbps v.34");
            this.put(33600, "33.6kbps v.34");
            this.put(56000, "56kbps v.90, v.92");
            this.put(64000, "64kbps ISDN");
            this.put(112000, "112kbps v.92 bonded");
            this.put(128000, "128kbps ISDN bonded");
            this.put(1544000, "1.544mbps T1");
            this.put(Integer.MAX_VALUE, "Unlimited");
        }
    };
    private JScreen screen;
    private int bps;
    private Path file;
    private static boolean restart = true;

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.out.println();
            System.out.println("DisplayANSI, a simple ANSI art viewer.");
            System.out.println("Usage:");
            System.out.println("\tjava -jar DisplayANSI.jar <filename> <bps>");
            System.out.println("\tRight-click the screen for options.");
            System.out.println();
            return;
        }
        DisplayANSI ansi = args.length > 1 ? new DisplayANSI(Integer.parseInt(args[1])) : new DisplayANSI();
        ansi.setFile(args[0]);
        while (!(restart && ansi.display() || ansi.checkEscape())) {
            Pause.milli(500);
        }
    }

    public DisplayANSI() {
        this(9600);
    }

    public DisplayANSI(int speed) {
        this.bps = speed;
        this.screen = JScreen.createJScreenWindow("DisplayANSI (right-click for options)", IBMScreenMode.VGA_80x25);
        this.screen.setTextProtocol(new ANSI(this.screen, new CGAANSIColor()));
        this.screen.hideCursor();
        this.screen.keyboard.enableKeyBuffer(true);
        JPopupMenu menu = this.screen.getContextMenu();
        JMenuItem reset = new JMenuItem("Restart");
        menu.add(reset);
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                restart = true;
            }
        });
        JMenu speedMenu = new JMenu("Modem Speed");
        menu.add(speedMenu);
        ButtonGroup group = new ButtonGroup();
        for (int newspeed : SPEEDS.keySet()) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(SPEEDS.get(newspeed));
            item.setSelected(this.bps == newspeed);
            item.setActionCommand(String.valueOf(newspeed));
            group.add(item);
            speedMenu.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DisplayANSI.this.bps = Integer.parseInt(e.getActionCommand());
                }
            });
        }
    }

    public boolean checkEscape() {
        while (this.screen.keyboard.isKeyEvent()) {
            KeyEvent key = this.screen.keyboard.getKeyEvent();
            if (key.getKeyChar() != '\u001b') continue;
            JFrame frame = (JFrame)SwingUtilities.getRoot(this.screen.getComponent());
            if (frame != null) {
                frame.dispose();
            }
            this.screen.close();
            return true;
        }
        return false;
    }

    public void setFile(String file) {
        Path path = Paths.get(file, new String[0]);
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new IllegalArgumentException();
        }
        this.file = path;
    }

    public boolean display() throws IOException {
        restart = false;
        int oldbps = this.bps;
        int wait = (int)(1000000.0 / ((double)this.bps / 8.0));
        System.out.println("Wait: " + wait);
        for (byte b : Files.readAllBytes(this.file)) {
            char ch = (char)(b & 0xFF);
            if (this.bps != oldbps) {
                oldbps = this.bps;
                wait = (int)(1000000.0 / ((double)this.bps / 8.0));
                System.out.println("Wait: " + wait);
            }
            this.screen.print(ch);
            Pause.micro(wait);
            if (restart) {
                this.screen.printlnBPS(this.bps);
                return false;
            }
            if (!this.checkEscape()) continue;
            return true;
        }
        System.out.println("Done.");
        return false;
    }

    public class ANSIPrintAll
    extends ANSI {
        public ANSIPrintAll(JScreen screen, ANSIColor palette) {
            super(screen, palette);
        }

        @Override
        public void actionPrint(char ch) {
            switch (ch) {
                case '\u0000': {
                    break;
                }
                case '\n': {
                    this.screen.lineFeed();
                    break;
                }
                case '\r': {
                    this.screen.carriageReturn();
                    break;
                }
                default: {
                    this.insideMargin(() -> this.screen.putChar(ch));
                }
            }
        }
    }
}

