/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.simplelenium;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.codestory.simplelenium.Retry;
import net.codestory.simplelenium.Should;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Select;

public class DomElement {
    private final WebDriver driver;
    private final By selector;
    private final Predicate<WebElement> narrowSelection;
    private final Retry retry;

    DomElement(WebDriver driver, By selector) {
        this(driver, selector, element -> true, new Retry(30L, TimeUnit.SECONDS));
    }

    DomElement(WebDriver driver, By selector, Predicate<WebElement> narrowSelection, Retry retry) {
        this.driver = driver;
        this.selector = selector;
        this.narrowSelection = narrowSelection;
        this.retry = retry;
    }

    public DomElement withText(String text) {
        return new DomElement(this.driver, this.selector, element -> Objects.equals(element.getText(), text), this.retry);
    }

    public Should should() {
        return new Should(this.driver, this.selector, 5L, TimeUnit.SECONDS);
    }

    public Should shouldWithin(long duration, TimeUnit timeUnit) {
        return new Should(this.driver, this.selector, duration, timeUnit);
    }

    public void fill(CharSequence text) {
        this.execute("fill(" + text + ")", element -> element.sendKeys(new CharSequence[]{text}));
    }

    public void pressReturn() {
        this.execute("pressReturn()", element -> element.sendKeys(new CharSequence[]{Keys.RETURN}));
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.execute("sendKeys()", element -> element.sendKeys(keysToSend));
    }

    public void clear() {
        this.execute("clear()", element -> element.clear());
    }

    public void submit() {
        this.execute("submit", element -> element.submit());
    }

    public void click() {
        this.execute("click", element -> element.click());
    }

    public void select(String text) {
        this.execute("select(" + text + ")", element -> new Select(element).selectByVisibleText(text));
    }

    public void execute(Consumer<? super WebElement> action) {
        this.execute("execute(" + action + ")", action);
    }

    private void execute(String message, Consumer<? super WebElement> action) {
        System.out.println(" - " + this.selector + "." + message);
        this.retry.execute(() -> this.find(), action);
    }

    private WebElement find() {
        WebElement element = this.driver.findElement(this.selector);
        if (!this.narrowSelection.test(element)) {
            return null;
        }
        return element;
    }
}

