/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bind;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bind.ArgumentTypeResolver;
import net.bytebuddy.implementation.bind.DeclaringTypeResolver;
import net.bytebuddy.implementation.bind.MethodNameEqualityResolver;
import net.bytebuddy.implementation.bind.ParameterLengthResolver;
import net.bytebuddy.implementation.bind.annotation.BindingPriority;
import net.bytebuddy.implementation.bytecode.Removal;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.utility.CompoundList;

public interface MethodDelegationBinder {
    public Record compile(MethodDescription var1);

    public static class Processor
    implements Record {
        private static final int ONLY = 0;
        private static final int LEFT = 0;
        private static final int RIGHT = 1;
        private final List<? extends Record> records;
        private final AmbiguityResolver ambiguityResolver;

        public Processor(List<? extends Record> records, AmbiguityResolver ambiguityResolver) {
            this.records = records;
            this.ambiguityResolver = ambiguityResolver;
        }

        @Override
        public MethodBinding bind(Implementation.Target implementationTarget, MethodDescription source, TerminationHandler terminationHandler, MethodInvoker methodInvoker, Assigner assigner) {
            ArrayList<MethodBinding> targets = new ArrayList<MethodBinding>();
            for (Record record : this.records) {
                MethodBinding methodBinding = record.bind(implementationTarget, source, terminationHandler, methodInvoker, assigner);
                if (!methodBinding.isValid()) continue;
                targets.add(methodBinding);
            }
            if (targets.isEmpty()) {
                throw new IllegalArgumentException("None of " + this.records + " allows for delegation from " + source);
            }
            return this.resolve(source, targets);
        }

        private MethodBinding resolve(MethodDescription source, List<MethodBinding> targets) {
            switch (targets.size()) {
                case 1: {
                    return targets.get(0);
                }
                case 2: {
                    MethodBinding left = targets.get(0);
                    MethodBinding right = targets.get(1);
                    switch (this.ambiguityResolver.resolve(source, left, right)) {
                        case LEFT: {
                            return left;
                        }
                        case RIGHT: {
                            return right;
                        }
                        case UNKNOWN: 
                        case AMBIGUOUS: {
                            throw new IllegalArgumentException("Cannot resolve ambiguous delegation of " + source + " to " + left + " or " + right);
                        }
                    }
                    throw new AssertionError();
                }
            }
            MethodBinding left = targets.get(0);
            MethodBinding right = targets.get(1);
            switch (this.ambiguityResolver.resolve(source, left, right)) {
                case LEFT: {
                    targets.remove(1);
                    return this.resolve(source, targets);
                }
                case RIGHT: {
                    targets.remove(0);
                    return this.resolve(source, targets);
                }
                case UNKNOWN: 
                case AMBIGUOUS: {
                    targets.remove(1);
                    targets.remove(0);
                    MethodBinding subResult = this.resolve(source, targets);
                    switch (this.ambiguityResolver.resolve(source, left, subResult).merge(this.ambiguityResolver.resolve(source, right, subResult))) {
                        case RIGHT: {
                            return subResult;
                        }
                        case UNKNOWN: 
                        case AMBIGUOUS: 
                        case LEFT: {
                            throw new IllegalArgumentException("Cannot resolve ambiguous delegation of " + source + " to " + left + " or " + right);
                        }
                    }
                    throw new AssertionError();
                }
            }
            throw new IllegalStateException("Unexpected targets: " + targets);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.ambiguityResolver.equals(((Processor)other).ambiguityResolver) && this.records.equals(((Processor)other).records);
        }

        public int hashCode() {
            return 31 * this.records.hashCode() + this.ambiguityResolver.hashCode();
        }

        public String toString() {
            return "MethodDelegationBinder.Processor{records=" + this.records + ", ambiguityResolver=" + this.ambiguityResolver + '}';
        }
    }

    public static interface TerminationHandler {
        public StackManipulation resolve(Assigner var1, Assigner.Typing var2, MethodDescription var3, MethodDescription var4);

        public static enum Default implements TerminationHandler
        {
            RETURNING{

                @Override
                public StackManipulation resolve(Assigner assigner, Assigner.Typing typing, MethodDescription source, MethodDescription target) {
                    return new StackManipulation.Compound(assigner.assign(target.isConstructor() ? target.getDeclaringType().asGenericType() : target.getReturnType(), source.getReturnType(), typing), MethodReturn.of(source.getReturnType()));
                }
            }
            ,
            DROPPING{

                @Override
                public StackManipulation resolve(Assigner assigner, Assigner.Typing typing, MethodDescription source, MethodDescription target) {
                    return Removal.of(target.isConstructor() ? target.getDeclaringType() : target.getReturnType());
                }
            };


            public String toString() {
                return "MethodDelegationBinder.TerminationHandler.Default." + this.name();
            }
        }
    }

    @SuppressFBWarnings(value={"IC_SUPERCLASS_USES_SUBCLASS_DURING_INITIALIZATION"}, justification="Safe initialization is implied")
    public static interface AmbiguityResolver {
        public static final AmbiguityResolver DEFAULT = new Compound(BindingPriority.Resolver.INSTANCE, DeclaringTypeResolver.INSTANCE, ArgumentTypeResolver.INSTANCE, MethodNameEqualityResolver.INSTANCE, ParameterLengthResolver.INSTANCE);

        public Resolution resolve(MethodDescription var1, MethodBinding var2, MethodBinding var3);

        public static class Compound
        implements AmbiguityResolver {
            private final List<AmbiguityResolver> ambiguityResolvers = new ArrayList<AmbiguityResolver>();

            public Compound(AmbiguityResolver ... ambiguityResolver) {
                this(Arrays.asList(ambiguityResolver));
            }

            public Compound(List<? extends AmbiguityResolver> ambiguityResolvers) {
                for (AmbiguityResolver ambiguityResolver : ambiguityResolvers) {
                    if (ambiguityResolver instanceof Compound) {
                        this.ambiguityResolvers.addAll(((Compound)ambiguityResolver).ambiguityResolvers);
                        continue;
                    }
                    if (ambiguityResolver instanceof NoOp) continue;
                    this.ambiguityResolvers.add(ambiguityResolver);
                }
            }

            @Override
            public Resolution resolve(MethodDescription source, MethodBinding left, MethodBinding right) {
                Resolution resolution = Resolution.UNKNOWN;
                Iterator<AmbiguityResolver> iterator = this.ambiguityResolvers.iterator();
                while (resolution.isUnresolved() && iterator.hasNext()) {
                    resolution = iterator.next().resolve(source, left, right);
                }
                return resolution;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.ambiguityResolvers.equals(((Compound)other).ambiguityResolvers);
            }

            public int hashCode() {
                return this.ambiguityResolvers.hashCode();
            }

            public String toString() {
                return "MethodDelegationBinder.AmbiguityResolver.Compound{ambiguityResolvers=" + this.ambiguityResolvers + '}';
            }
        }

        public static enum Directional implements AmbiguityResolver
        {
            LEFT(true),
            RIGHT(false);

            private final boolean left;

            private Directional(boolean left) {
                this.left = left;
            }

            @Override
            public Resolution resolve(MethodDescription source, MethodBinding left, MethodBinding right) {
                return this.left ? Resolution.LEFT : Resolution.RIGHT;
            }

            public String toString() {
                return "MethodDelegationBinder.AmbiguityResolver.Directional." + this.name();
            }
        }

        public static enum NoOp implements AmbiguityResolver
        {
            INSTANCE;


            @Override
            public Resolution resolve(MethodDescription source, MethodBinding left, MethodBinding right) {
                return Resolution.UNKNOWN;
            }

            public String toString() {
                return "MethodDelegationBinder.AmbiguityResolver.NoOp." + this.name();
            }
        }

        public static enum Resolution {
            UNKNOWN(true),
            LEFT(false),
            RIGHT(false),
            AMBIGUOUS(true);

            private final boolean unresolved;

            private Resolution(boolean unresolved) {
                this.unresolved = unresolved;
            }

            public boolean isUnresolved() {
                return this.unresolved;
            }

            public Resolution merge(Resolution other) {
                switch (this) {
                    case UNKNOWN: {
                        return other;
                    }
                    case AMBIGUOUS: {
                        return AMBIGUOUS;
                    }
                    case LEFT: 
                    case RIGHT: {
                        return other == this ? this : AMBIGUOUS;
                    }
                }
                throw new AssertionError();
            }

            public String toString() {
                return "MethodDelegationBinder.AmbiguityResolver.Resolution." + this.name();
            }
        }
    }

    public static interface MethodBinding
    extends StackManipulation {
        public Integer getTargetParameterIndex(Object var1);

        public MethodDescription getTarget();

        public static class Builder {
            private final MethodInvoker methodInvoker;
            private final MethodDescription candidate;
            private final List<StackManipulation> parameterStackManipulations;
            private final LinkedHashMap<Object, Integer> registeredTargetIndices;
            private int nextParameterIndex;

            public Builder(MethodInvoker methodInvoker, MethodDescription candidate) {
                this.methodInvoker = methodInvoker;
                this.candidate = candidate;
                this.parameterStackManipulations = new ArrayList<StackManipulation>(candidate.getParameters().size());
                this.registeredTargetIndices = new LinkedHashMap();
                this.nextParameterIndex = 0;
            }

            public boolean append(ParameterBinding<?> parameterBinding) {
                this.parameterStackManipulations.add(parameterBinding);
                return this.registeredTargetIndices.put(parameterBinding.getIdentificationToken(), this.nextParameterIndex++) == null;
            }

            public MethodBinding build(StackManipulation terminatingManipulation) {
                if (this.candidate.getParameters().size() != this.nextParameterIndex) {
                    throw new IllegalStateException("The number of parameters bound does not equal the target's number of parameters");
                }
                return new Build(this.candidate, this.registeredTargetIndices, this.methodInvoker.invoke(this.candidate), this.parameterStackManipulations, terminatingManipulation);
            }

            public String toString() {
                return "MethodDelegationBinder.MethodBinding.Builder{methodInvoker=" + this.methodInvoker + ", candidate=" + this.candidate + ", parameterStackManipulations=" + this.parameterStackManipulations + ", registeredTargetIndices=" + this.registeredTargetIndices + ", nextParameterIndex=" + this.nextParameterIndex + '}';
            }

            protected static class Build
            implements MethodBinding {
                private final MethodDescription target;
                private final Map<?, Integer> registeredTargetIndices;
                private final StackManipulation methodInvocation;
                private final List<StackManipulation> parameterStackManipulations;
                private final StackManipulation terminatingStackManipulation;

                protected Build(MethodDescription target, Map<?, Integer> registeredTargetIndices, StackManipulation methodInvocation, List<StackManipulation> parameterStackManipulations, StackManipulation terminatingStackManipulation) {
                    this.target = target;
                    this.registeredTargetIndices = new HashMap(registeredTargetIndices);
                    this.methodInvocation = methodInvocation;
                    this.parameterStackManipulations = new ArrayList<StackManipulation>(parameterStackManipulations);
                    this.terminatingStackManipulation = terminatingStackManipulation;
                }

                @Override
                public boolean isValid() {
                    boolean result = this.methodInvocation.isValid() && this.terminatingStackManipulation.isValid();
                    Iterator<StackManipulation> assignment = this.parameterStackManipulations.iterator();
                    while (result && assignment.hasNext()) {
                        result = assignment.next().isValid();
                    }
                    return result;
                }

                @Override
                public Integer getTargetParameterIndex(Object parameterBindingToken) {
                    return this.registeredTargetIndices.get(parameterBindingToken);
                }

                @Override
                public MethodDescription getTarget() {
                    return this.target;
                }

                @Override
                public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                    return new StackManipulation.Compound(CompoundList.of(this.parameterStackManipulations, Arrays.asList(this.methodInvocation, this.terminatingStackManipulation))).apply(methodVisitor, implementationContext);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Build build = (Build)other;
                    return this.methodInvocation.equals(build.methodInvocation) && this.parameterStackManipulations.equals(build.parameterStackManipulations) && this.registeredTargetIndices.equals(build.registeredTargetIndices) && this.terminatingStackManipulation.equals(build.terminatingStackManipulation) && this.target.equals(build.target);
                }

                public int hashCode() {
                    int result = this.target.hashCode();
                    result = 31 * result + this.registeredTargetIndices.hashCode();
                    result = 31 * result + this.methodInvocation.hashCode();
                    result = 31 * result + this.parameterStackManipulations.hashCode();
                    result = 31 * result + this.terminatingStackManipulation.hashCode();
                    return result;
                }

                public String toString() {
                    return "MethodDelegationBinder.MethodBinding.Builder.Build{target=" + this.target + ", registeredTargetIndices=" + this.registeredTargetIndices + ", methodInvocation=" + this.methodInvocation + ", parameterStackManipulations=" + this.parameterStackManipulations + ", terminatingStackManipulation=" + this.terminatingStackManipulation + '}';
                }
            }
        }

        public static enum Illegal implements MethodBinding
        {
            INSTANCE;


            @Override
            public Integer getTargetParameterIndex(Object parameterBindingToken) {
                throw new IllegalStateException("Method is not bound");
            }

            @Override
            public MethodDescription getTarget() {
                throw new IllegalStateException("Method is not bound");
            }

            @Override
            public boolean isValid() {
                return false;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                throw new IllegalStateException("Cannot delegate to an unbound method");
            }

            public String toString() {
                return "MethodDelegationBinder.MethodBinding.Illegal." + this.name();
            }
        }
    }

    public static interface ParameterBinding<T>
    extends StackManipulation {
        public T getIdentificationToken();

        public static class Unique<T>
        implements ParameterBinding<T> {
            private final T identificationToken;
            private final StackManipulation delegate;

            public Unique(StackManipulation delegate, T identificationToken) {
                this.delegate = delegate;
                this.identificationToken = identificationToken;
            }

            public static <S> Unique<S> of(StackManipulation delegate, S identificationToken) {
                return new Unique<S>(delegate, identificationToken);
            }

            @Override
            public T getIdentificationToken() {
                return this.identificationToken;
            }

            @Override
            public boolean isValid() {
                return this.delegate.isValid();
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                return this.delegate.apply(methodVisitor, implementationContext);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Unique unique = (Unique)other;
                return this.identificationToken.equals(unique.identificationToken) && this.delegate.equals(unique.delegate);
            }

            public int hashCode() {
                int result = this.identificationToken.hashCode();
                result = 31 * result + this.delegate.hashCode();
                return result;
            }

            public String toString() {
                return "MethodDelegationBinder.ParameterBinding.Unique{identificationToken=" + this.identificationToken + ", delegate=" + this.delegate + '}';
            }
        }

        public static class Anonymous
        implements ParameterBinding<Object> {
            private final Object anonymousToken;
            private final StackManipulation delegate;

            public Anonymous(StackManipulation delegate) {
                this.delegate = delegate;
                this.anonymousToken = new Object();
            }

            @Override
            public Object getIdentificationToken() {
                return this.anonymousToken;
            }

            @Override
            public boolean isValid() {
                return this.delegate.isValid();
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                return this.delegate.apply(methodVisitor, implementationContext);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.delegate.equals(((Anonymous)other).delegate);
            }

            public int hashCode() {
                return 31 * this.delegate.hashCode();
            }

            public String toString() {
                return "MethodDelegationBinder.ParameterBinding.Anonymous{anonymousToken=" + this.anonymousToken + ", delegate=" + this.delegate + '}';
            }
        }

        public static enum Illegal implements ParameterBinding<Void>
        {
            INSTANCE;


            @Override
            public Void getIdentificationToken() {
                throw new IllegalStateException("An illegal binding does not define an identification token");
            }

            @Override
            public boolean isValid() {
                return false;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
                throw new IllegalStateException("An illegal parameter binding must not be applied");
            }

            public String toString() {
                return "MethodDelegationBinder.ParameterBinding.Illegal." + this.name();
            }
        }
    }

    public static interface MethodInvoker {
        public StackManipulation invoke(MethodDescription var1);

        public static class Virtual
        implements MethodInvoker {
            private final TypeDescription typeDescription;

            public Virtual(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            @Override
            public StackManipulation invoke(MethodDescription methodDescription) {
                return MethodInvocation.invoke(methodDescription).virtual(this.typeDescription);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((Virtual)other).typeDescription);
            }

            public int hashCode() {
                return this.typeDescription.hashCode();
            }

            public String toString() {
                return "MethodDelegationBinder.MethodInvoker.Virtual{typeDescription=" + this.typeDescription + '}';
            }
        }

        public static enum Simple implements MethodInvoker
        {
            INSTANCE;


            @Override
            public StackManipulation invoke(MethodDescription methodDescription) {
                return MethodInvocation.invoke(methodDescription);
            }

            public String toString() {
                return "MethodDelegationBinder.MethodInvoker.Simple." + this.name();
            }
        }
    }

    public static interface Record {
        public MethodBinding bind(Implementation.Target var1, MethodDescription var2, TerminationHandler var3, MethodInvoker var4, Assigner var5);

        public static enum Illegal implements Record
        {
            INSTANCE;


            @Override
            public MethodBinding bind(Implementation.Target implementationTarget, MethodDescription source, TerminationHandler terminationHandler, MethodInvoker methodInvoker, Assigner assigner) {
                return MethodBinding.Illegal.INSTANCE;
            }

            public String toString() {
                return "MethodDelegationBinder.Record.Illegal." + this.name();
            }
        }
    }
}

