/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.user;

import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.types.Pair;
import net.andreinc.mockneat.types.enums.DictType;
import net.andreinc.mockneat.types.enums.StringFormatType;
import net.andreinc.mockneat.types.enums.UserNameType;
import net.andreinc.mockneat.utils.ValidationUtils;

public class Users
extends MockUnitBase
implements MockUnitString {
    private static final Double UNDERSCORE = 0.15;

    public static Users users() {
        return MockNeat.threadLocal().users();
    }

    protected Users() {
    }

    public Users(MockNeat mockNeat) {
        super(mockNeat);
    }

    @Override
    public Supplier<String> supplier() {
        return this.types(UserNameType.values()).supplier();
    }

    public MockUnitString type(UserNameType type) {
        ValidationUtils.notNull(type, "type");
        Supplier<String> supplier = () -> this.generateUserName(type);
        return () -> supplier;
    }

    public MockUnitString types(UserNameType ... types) {
        ValidationUtils.notEmptyOrNullValues(types, "types");
        return () -> {
            UserNameType type = this.mockNeat.from(types).val();
            return this.type(type).supplier();
        };
    }

    private String generateUserName(UserNameType type) {
        Pair<DictType, DictType> pair = this.mockNeat.from(type.getDictCombos()).val();
        String part1 = (String)this.mockNeat.dicts().type(pair.getFirst()).format(StringFormatType.LOWER_CASE).val();
        String part2 = (String)this.mockNeat.dicts().type(pair.getSecond()).format(StringFormatType.LOWER_CASE).val();
        if (this.mockNeat.bools().probability(UNDERSCORE).val().booleanValue()) {
            part1 = part1 + "_";
        }
        return part1 + part2;
    }
}

