/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.text.sql;

import java.util.Map;
import java.util.function.Function;
import net.andreinc.mockneat.types.Pair;
import net.andreinc.mockneat.utils.ValidationUtils;

public class SQLInsert {
    private final String tableName;
    private final Map<String, Pair<String, Function<String, String>>> columns;

    public SQLInsert(String tableName, Map<String, Pair<String, Function<String, String>>> columns) {
        ValidationUtils.notEmpty(tableName, "tableName");
        ValidationUtils.notNull(columns, "columns");
        this.tableName = tableName;
        this.columns = columns;
    }

    public String getValue(String column) {
        ValidationUtils.notEmpty(column, "column");
        ValidationUtils.isTrue(this.columns.containsKey(column), "Column: #{column} cannot be found on #{table}.", "column", column, "table", this.tableName);
        return this.columns.get(column).getFirst();
    }

    public void setValue(String column, String value) {
        ValidationUtils.notEmpty(column, "column");
        ValidationUtils.notEmpty(value, "value");
        ValidationUtils.isTrue(this.columns.containsKey(column), "Column: #{column} cannot be found on #{table}.", "column", column, "table", this.tableName);
        Function<String, String> existingMethod = this.columns.get(column).getSecond();
        this.columns.put(column, Pair.of(value, existingMethod));
    }

    public String toString() {
        StringBuilder buff = new StringBuilder(1024);
        buff.append("INSERT INTO ").append(this.tableName).append(' ').append(this.getColumnsSection()).append("VALUES (");
        for (Pair<String, Function<String, String>> str : this.columns.values()) {
            String strVal = str.getFirst();
            if (str.getSecond() != null) {
                strVal = str.getSecond().apply(strVal);
            }
            buff.append(strVal).append(", ");
        }
        buff.delete(buff.length() - 2, buff.length()).append(");");
        return buff.toString();
    }

    private String getColumnsSection() {
        StringBuilder buff = new StringBuilder();
        buff.append('(');
        this.columns.keySet().forEach(col -> buff.append((String)col).append(", "));
        buff.delete(buff.length() - 2, buff.length()).append(") ");
        return buff.toString();
    }
}

