/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.text.sql;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.andreinc.mockneat.utils.ValidationUtils;

public class SQLEscaper {
    private final Map<String, String> replacers = new HashMap<String, String>();
    private final Pattern escapePattern;

    public SQLEscaper(List<TextEscapeToken> tokenList) {
        ValidationUtils.notNull(tokenList, "tokenList");
        StringBuilder buff = new StringBuilder();
        tokenList.forEach(token -> {
            this.replacers.put(token.getSearchToken(), token.getReplaceString());
            buff.append('|').append(token.getSearchRegex());
        });
        buff.deleteCharAt(0);
        buff.insert(0, '(');
        buff.append(')');
        this.escapePattern = Pattern.compile(buff.toString());
    }

    public String escape(String text) {
        ValidationUtils.notEmpty(text, "text");
        Matcher matcher = this.escapePattern.matcher(text);
        StringBuffer escapedBuff = new StringBuffer();
        escapedBuff.append('\'');
        while (matcher.find()) {
            matcher.appendReplacement(escapedBuff, this.replacers.get(matcher.group(1)));
        }
        matcher.appendTail(escapedBuff);
        escapedBuff.append('\'');
        return escapedBuff.toString();
    }

    public static class TextEscapeToken {
        private final String searchToken;
        private final String searchRegex;
        private final String replaceString;

        public TextEscapeToken(String searchToken, String searchRegex, String replaceString) {
            ValidationUtils.notEmpty(searchToken, "searchToken");
            ValidationUtils.notEmpty(searchRegex, "searchRegex");
            ValidationUtils.notEmpty(replaceString, "replaceString");
            this.searchToken = searchToken;
            this.searchRegex = searchRegex;
            this.replaceString = replaceString;
        }

        public String getSearchToken() {
            return this.searchToken;
        }

        public String getSearchRegex() {
            return this.searchRegex;
        }

        public String getReplaceString() {
            return this.replaceString;
        }
    }
}

