/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.text;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.andreinc.markovneat.MChainText;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.types.enums.MarkovChainType;
import net.andreinc.mockneat.utils.ValidationUtils;
import net.andreinc.mockneat.utils.file.FileManager;

public class Markovs
extends MockUnitBase
implements MockUnitString {
    private static final FileManager fm = FileManager.getInstance();
    private final Map<MarkovChainType, MChainText> markovUnits = new EnumMap<MarkovChainType, MChainText>(MarkovChainType.class);
    private int size = 512;

    public static Markovs markovs() {
        return MockNeat.threadLocal().markovs();
    }

    public Markovs(MockNeat mockNeat) {
        super(mockNeat);
    }

    protected Markovs() {
    }

    private MChainText get(MarkovChainType markovChainType) throws IOException {
        if (!this.markovUnits.containsKey((Object)markovChainType)) {
            MChainText mChainText = new MChainText(2, this.mockNeat.getRandom());
            List<String> lines = fm.read(markovChainType);
            mChainText.train(lines);
            this.markovUnits.put(markovChainType, mChainText);
        }
        return this.markovUnits.get((Object)markovChainType);
    }

    public Markovs size(int size) {
        Markovs markovs = new Markovs(this.mockNeat);
        markovs.size = size;
        return markovs;
    }

    @Override
    public Supplier<String> supplier() {
        return this.type(MarkovChainType.LOREM_IPSUM).supplier();
    }

    public MockUnitString types(MarkovChainType ... types) {
        ValidationUtils.notEmptyOrNullValues(types, "types");
        return () -> {
            MarkovChainType type = this.mockNeat.from(types).val();
            return this.type(type).supplier();
        };
    }

    public MockUnitString type(MarkovChainType type) {
        ValidationUtils.notNull(type, "type");
        Supplier<String> supp = () -> {
            try {
                MChainText unit = this.get(type);
                return unit.generateText(this.size);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        return () -> supp;
    }

    public MockUnitString loremIpsum() {
        return this.type(MarkovChainType.LOREM_IPSUM);
    }
}

