/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.seq;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnit;
import net.andreinc.mockneat.types.enums.DictType;
import net.andreinc.mockneat.utils.ValidationUtils;
import net.andreinc.mockneat.utils.file.FileManager;

public final class Seq<T>
implements MockUnit<T> {
    private final Iterable<T> iterable;
    private Iterator<T> iterator;
    private boolean cycle;
    private Supplier<T> after;

    public static Seq<?> seq(DictType dictType) {
        return MockNeat.threadLocal().seq(dictType);
    }

    public static <T> Seq<T> seq(Iterable<T> iterable) {
        return MockNeat.threadLocal().seq(iterable);
    }

    public static <T> Seq<T> seq(T[] array) {
        return MockNeat.threadLocal().seq(array);
    }

    public static Seq<String> fromDict(DictType dictType) {
        ValidationUtils.notNull(dictType, "dictType");
        List<String> lines = FileManager.getInstance().getLines(dictType);
        return new Seq<String>(lines);
    }

    public static <T> Seq<T> fromIterable(Iterable<T> iterable) {
        ValidationUtils.notNull(iterable, "iterable");
        return new Seq<T>(iterable);
    }

    public static <T> Seq<T> fromArray(T[] array) {
        ValidationUtils.notNull(array, "array");
        return new Seq<T>(Arrays.asList(array));
    }

    private Seq(Iterable<T> iterable) {
        ValidationUtils.notNull(iterable, "iterable");
        this.iterable = iterable;
        this.iterator = iterable.iterator();
        ValidationUtils.isTrue(this.iterator.hasNext(), "Impossible to create a Seq from an empty Iterable<T>.", new Object[0]);
    }

    public Seq<T> cycle(boolean value) {
        this.cycle = value;
        return this;
    }

    public Seq<T> after(T after) {
        this.after = () -> after;
        return this;
    }

    public Seq<T> afterDoMock(MockUnit<T> after) {
        this.after = after.supplier();
        return this;
    }

    @Override
    public Supplier<T> supplier() {
        return () -> {
            if (this.iterator.hasNext()) {
                return this.iterator.next();
            }
            if (this.cycle) {
                this.iterator = this.iterable.iterator();
                return this.iterator.next();
            }
            if (this.after == null) {
                return null;
            }
            return this.after.get();
        };
    }
}

