/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.seq;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.andreinc.aleph.AlephFormatter;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitInt;
import net.andreinc.mockneat.utils.ValidationUtils;

public class IntSeq
implements MockUnitInt {
    private int increment;
    private int start;
    private boolean cycle;
    private int max;
    private int min;
    private AtomicInteger internal;

    public static IntSeq intSeq() {
        return MockNeat.threadLocal().intSeq();
    }

    public IntSeq(int start, int increment, int max, int min, boolean cycle) {
        ValidationUtils.isTrue(min < max, AlephFormatter.str((String)"The min value '#{min}' should be lower than the maximum '#{max}' value of the sequence.").args(new Object[]{"min", min, "max", max}).fmt(), new Object[0]);
        this.increment = increment;
        this.start = start;
        this.cycle = cycle;
        this.max = max;
        this.min = min;
        this.internal = new AtomicInteger(start);
    }

    public IntSeq(int start, int increment) {
        this(start, increment, Integer.MAX_VALUE, Integer.MIN_VALUE, true);
    }

    public IntSeq(int increment) {
        this(0, increment, Integer.MAX_VALUE, Integer.MIN_VALUE, true);
    }

    public IntSeq() {
        this(0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE, true);
    }

    public IntSeq start(int start) {
        ValidationUtils.isTrue(this.min < this.max, AlephFormatter.str((String)"The min value '#{min}' should be lower than the maximum '#{max}' value of the sequence.").args(new Object[]{"min", this.min, "max", this.max}).fmt(), new Object[0]);
        this.start = start;
        this.internal = new AtomicInteger(start);
        return this;
    }

    public IntSeq increment(int increment) {
        this.increment = increment;
        return this;
    }

    public IntSeq cycle(boolean cycle) {
        this.cycle = cycle;
        return this;
    }

    public IntSeq max(int max) {
        ValidationUtils.isTrue(this.min < max, AlephFormatter.str((String)"The min value '#{min}' should be lower than the maximum '#{max}' value of the sequence.").args(new Object[]{"min", this.min, "max", max}).fmt(), new Object[0]);
        this.max = max;
        return this;
    }

    public IntSeq min(int min) {
        ValidationUtils.isTrue(min < this.max, AlephFormatter.str((String)"The min value '#{min}' should be lower than the maximum '#{max}' value of the sequence.").args(new Object[]{"min", min, "max", this.max}).fmt(), new Object[0]);
        this.min = min;
        return this;
    }

    private boolean nextValueOverflows() {
        return this.increment > 0 ? this.internal.get() > this.max : this.internal.get() < this.min;
    }

    private void fail() {
        String fmt = AlephFormatter.str((String)"IntSeq overflow. Values are generated inside the interval: [#{min}, #{max}]. Cannot increment any further.").arg("min", (Object)this.min).arg("max", (Object)this.max).fmt();
        throw new IllegalStateException(fmt);
    }

    @Override
    public Supplier<Integer> supplier() {
        return () -> {
            if (this.nextValueOverflows()) {
                if (this.cycle) {
                    this.internal.set(this.start);
                } else {
                    this.fail();
                }
            }
            return this.internal.getAndAdd(this.increment);
        };
    }
}

