/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.objects;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnit;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.utils.ValidationUtils;

public class ObjectMap
extends MockUnitBase
implements MockUnit<Map<String, Object>> {
    private final Map<String, MockUnit<?>> map = new LinkedHashMap();

    public static ObjectMap objectMap() {
        return MockNeat.threadLocal().objectMap();
    }

    public ObjectMap(MockNeat mockNeat) {
        super(mockNeat);
    }

    @Override
    public Supplier<Map<String, Object>> supplier() {
        return () -> ObjectMap.traverseObject(this);
    }

    public ObjectMap put(String value, MockUnit<?> unit) {
        ValidationUtils.notEmpty(value, "value");
        ValidationUtils.notNull(unit, "unit");
        this.map.put(value, unit);
        return this;
    }

    public ObjectMap put(String value, String unit) {
        return this.put(value, this.mockNeat.constant(unit));
    }

    public ObjectMap put(String value, Character unit) {
        return this.put(value, this.mockNeat.constant(unit));
    }

    public ObjectMap put(String value, Integer unit) {
        return this.put(value, this.mockNeat.constant(unit));
    }

    public ObjectMap put(String value, Long unit) {
        return this.put(value, this.mockNeat.constant(unit));
    }

    public ObjectMap put(String value, Double unit) {
        return this.put(value, this.mockNeat.constant(unit));
    }

    protected static Map<String, Object> traverseObject(ObjectMap ojMap) {
        Map<String, MockUnit<?>> map = ojMap.map;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : map.keySet()) {
            MockUnit<?> value = map.get(key);
            if (value instanceof ObjectMap) {
                result.put(key, ObjectMap.traverseObject((ObjectMap)value));
                continue;
            }
            result.put(key, value.get());
        }
        return result;
    }
}

