/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.networking;

import java.util.List;
import java.util.function.Supplier;
import net.andreinc.aleph.AlephFormatter;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.types.Pair;
import net.andreinc.mockneat.types.enums.DictType;
import net.andreinc.mockneat.types.enums.DomainSuffixType;
import net.andreinc.mockneat.types.enums.HostNameType;
import net.andreinc.mockneat.types.enums.PassStrengthType;
import net.andreinc.mockneat.types.enums.StringFormatType;
import net.andreinc.mockneat.types.enums.URLSchemeType;
import net.andreinc.mockneat.utils.ValidationUtils;

public class URLs
extends MockUnitBase
implements MockUnitString {
    static final Integer[] COMMON_HTTP_PORTS = new Integer[]{80, 1311, 2480, 4567, 4711, 4712, 5104, 5800, 5988, 5989, 7000, 7001, 7002, 8008, 8080, 8088, 8280, 8281, 8530, 8531, 8887, 8888, 9080, 9443, 9981, 9982, 11371, 16080, 18091, 18092};
    private Supplier<String> schemeSupplier;
    private Supplier<String> authSupplier;
    private Supplier<String> userNameSupplier;
    private Supplier<String> passWordSupplier;
    private Supplier<String> hostSupplier;
    private boolean www = true;
    private Supplier<String> domainSupplier;
    private Supplier<String> portSupplier;

    public static URLs urls() {
        return MockNeat.threadLocal().urls();
    }

    protected URLs() {
        this.initializeSuppliers();
    }

    public URLs(MockNeat mockNeat) {
        super(mockNeat);
        this.initializeSuppliers();
    }

    private static String urlFormat(String scheme, String auth, String host, String domain, String port, String paths) {
        return scheme + auth + host + domain + port + paths;
    }

    private void initializeSuppliers() {
        this.schemeSupplier = this.defaultSchemesSupplier();
        this.authSupplier = this.defaultAuthSupplier();
        this.hostSupplier = this.defaultHostSupplier();
        this.domainSupplier = this.defaultDomainSupplier();
        this.portSupplier = this.defaultPortSupplier();
    }

    private Supplier<String> defaultSchemesSupplier() {
        return this.schemeSupplier(URLSchemeType.HTTP);
    }

    private Supplier<String> schemeSupplier(String ... schemes) {
        return this.mockNeat.fromStrings(schemes).append("://")::val;
    }

    private Supplier<String> schemeSupplier(String scheme) {
        if ("".equals(scheme)) {
            return () -> "";
        }
        return () -> scheme.concat("://");
    }

    private Supplier<String> schemeSupplier(URLSchemeType scheme) {
        return this.schemeSupplier(scheme.getStr());
    }

    private Supplier<String> schemeSupplier(URLSchemeType ... schemes) {
        return this.mockNeat.from(schemes).mapToString().append("://")::val;
    }

    public URLs schemes(String ... schemes) {
        ValidationUtils.notEmptyOrNullValues(schemes, "schemes");
        this.schemeSupplier = this.schemeSupplier(schemes);
        return this;
    }

    public URLs scheme(String scheme) {
        ValidationUtils.notNull(scheme, "scheme");
        this.schemeSupplier = this.schemeSupplier(scheme);
        return this;
    }

    public URLs schemes(URLSchemeType ... schemes) {
        ValidationUtils.notEmptyOrNullValues(schemes, "schemes");
        this.schemeSupplier = this.schemeSupplier(schemes);
        return this;
    }

    public URLs scheme(URLSchemeType scheme) {
        ValidationUtils.notNull(scheme, "scheme");
        this.schemeSupplier = this.schemeSupplier(scheme);
        return this;
    }

    private Supplier<String> defaultAuthSupplier() {
        return () -> "";
    }

    private Supplier<String> authSupplier() {
        return () -> AlephFormatter.str((String)"#{userName}:#{passWord}@").arg("userName", (Object)this.userNameSupplier.get()).arg("passWord", (Object)this.passWordSupplier.get()).fmt();
    }

    public URLs auth() {
        this.userNameSupplier = this.mockNeat.users().urlEncode().supplier();
        this.passWordSupplier = this.mockNeat.passwords().type(PassStrengthType.MEDIUM).urlEncode().supplier();
        this.authSupplier = this.authSupplier();
        return this;
    }

    private Supplier<String> defaultHostSupplier() {
        return () -> {
            List<Pair<DictType, DictType>> comboList = this.mockNeat.from(HostNameType.class).val().getDictCombos();
            Pair<DictType, DictType> combo = this.mockNeat.from(comboList).val();
            String result = (String)this.mockNeat.dicts().type(combo.getFirst()).noSpecialChars().format(StringFormatType.LOWER_CASE).val() + (String)this.mockNeat.dicts().type(combo.getSecond()).noSpecialChars().format(StringFormatType.LOWER_CASE).val();
            if (this.www) {
                result = "www.".concat(result);
            }
            return result;
        };
    }

    private Supplier<String> hostSupplier(String ... hosts) {
        return this.mockNeat.fromStrings(hosts).prepend(this.www ? "www." : "")::val;
    }

    private Supplier<String> hostSupplier(String host) {
        return () -> this.www ? "www.".concat(host) : host;
    }

    private Supplier<String> hostSupplier(HostNameType ... types) {
        HostNameType type = this.mockNeat.from(types).val();
        return this.hostSupplier(type);
    }

    private Supplier<String> hostSupplier(HostNameType hostNameType) {
        return () -> {
            List<Pair<DictType, DictType>> comboList = hostNameType.getDictCombos();
            Pair<DictType, DictType> combo = this.mockNeat.from(comboList).val();
            String result1 = (String)this.mockNeat.dicts().type(combo.getFirst()).noSpecialChars().val();
            String result2 = (String)this.mockNeat.dicts().type(combo.getSecond()).noSpecialChars().val();
            String result = result1 + result2;
            if (this.www) {
                result = "www.".concat(result);
            }
            return result;
        };
    }

    public URLs hosts(String ... hosts) {
        ValidationUtils.notEmptyOrNullValues(hosts, "hosts");
        this.hostSupplier = this.hostSupplier(hosts);
        return this;
    }

    public URLs host(String host) {
        ValidationUtils.notEmpty(host, "host");
        this.hostSupplier = this.hostSupplier(host);
        return this;
    }

    public URLs hosts(HostNameType ... hostNameTypes) {
        ValidationUtils.notEmptyOrNullValues(hostNameTypes, "hostNameTypes");
        this.hostSupplier = this.hostSupplier(hostNameTypes);
        return this;
    }

    public URLs host(HostNameType hostNameType) {
        ValidationUtils.notNull(hostNameType, "hostNameType");
        this.hostSupplier = this.hostSupplier(hostNameType);
        return this;
    }

    private Supplier<String> defaultDomainSupplier() {
        return this.domainSupplier(DomainSuffixType.POPULAR);
    }

    private Supplier<String> domainSupplier(DomainSuffixType ... types) {
        return this.mockNeat.domains().types(types).prepend(".")::val;
    }

    private Supplier<String> domainSupplier(DomainSuffixType type) {
        return this.mockNeat.domains().types(type).prepend(".")::val;
    }

    private Supplier<String> domainSupplier(String ... domains) {
        return this.mockNeat.fromStrings(domains).prepend(".")::val;
    }

    private Supplier<String> domainSupplier(String domain) {
        return () -> "." + domain;
    }

    public URLs domains(DomainSuffixType ... types) {
        ValidationUtils.notEmptyOrNullValues(types, "types");
        this.domainSupplier = this.domainSupplier(types);
        return this;
    }

    public URLs domain(DomainSuffixType type) {
        ValidationUtils.notNull(type, "types");
        this.domainSupplier = this.domainSupplier(type);
        return this;
    }

    public URLs domains(String ... domains) {
        ValidationUtils.notEmptyOrNullValues(domains, "domains");
        this.domainSupplier = this.domainSupplier(domains);
        return this;
    }

    public URLs domain(String domain) {
        ValidationUtils.notEmpty(domain, "domain");
        this.domainSupplier = this.domainSupplier(domain);
        return this;
    }

    private Supplier<String> defaultPortSupplier() {
        return () -> "";
    }

    private Supplier<String> portsSupplier() {
        return this.portSupplier(COMMON_HTTP_PORTS);
    }

    private Supplier<String> portSupplier(Integer ... array) {
        return this.mockNeat.fromInts(array).mapToString().prepend(":")::val;
    }

    private Supplier<String> portSupplier(Integer port) {
        return () -> ":" + port;
    }

    public URLs ports() {
        this.portSupplier = this.portsSupplier();
        return this;
    }

    public URLs ports(Integer ... array) {
        ValidationUtils.notEmptyOrNullValues(array, "array");
        this.portSupplier = this.portSupplier(array);
        return this;
    }

    public URLs port(Integer port) {
        ValidationUtils.notNull(port, "port");
        this.portSupplier = this.portSupplier(port);
        return this;
    }

    public URLs www(boolean hasWWW) {
        this.www = hasWWW;
        return this;
    }

    @Override
    public Supplier<String> supplier() {
        return () -> {
            String scheme = this.schemeSupplier.get();
            String auth = this.authSupplier.get();
            String host = this.hostSupplier.get();
            String domain = this.domainSupplier.get();
            String port = this.portSupplier.get();
            String paths = "";
            return URLs.urlFormat(scheme, auth, host, domain, port, paths);
        };
    }
}

