/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.networking;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.types.Range;
import net.andreinc.mockneat.types.enums.IPv4Type;
import net.andreinc.mockneat.utils.ValidationUtils;

public class IPv4s
extends MockUnitBase
implements MockUnitString {
    public static IPv4s ipv4s() {
        return new IPv4s();
    }

    protected IPv4s() {
    }

    public IPv4s(MockNeat mockNeat) {
        super(mockNeat);
    }

    @Override
    public Supplier<String> supplier() {
        return this.type(IPv4Type.NO_CONSTRAINT).supplier();
    }

    public MockUnitString types(IPv4Type ... types) {
        ValidationUtils.notEmptyOrNullValues(types, "types");
        return () -> {
            IPv4Type type = this.mockNeat.from(types).val();
            return this.type(type).supplier();
        };
    }

    public MockUnitString type(IPv4Type type) {
        ValidationUtils.notNull(type, "type");
        Range[] oc = type.getOctets();
        Supplier<String> supp = () -> {
            StringBuilder buff = new StringBuilder();
            Arrays.stream(oc).forEach(range -> {
                int low = (Integer)range.getLowerBound();
                int up = (Integer)range.getUpperBound();
                if (range.isConstant().booleanValue()) {
                    buff.append(low).append('.');
                } else {
                    int result = (Integer)this.mockNeat.ints().range(low, up + 1).val();
                    buff.append(result).append('.');
                }
            });
            buff.deleteCharAt(buff.length() - 1);
            String result = buff.toString();
            return type.isPrivateAllowed() || !this.isPrivate(result) ? result : (String)this.type(type).val();
        };
        return () -> supp;
    }

    private boolean isPrivate(String ip) {
        List numbers = Arrays.stream(ip.split("\\.")).map(Integer::parseInt).collect(Collectors.toList());
        return (Integer)numbers.get(0) == 10 || (Integer)numbers.get(0) == 172 && (Integer)numbers.get(1) >= 16 && (Integer)numbers.get(1) < 32 || (Integer)numbers.get(0) == 192 && (Integer)numbers.get(1) == 168;
    }
}

