/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.financial;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.utils.ValidationUtils;

public class Money
extends MockUnitBase
implements MockUnitString {
    public static final double DEFAULT_LOWER = 0.0;
    public static final double DEFAULT_UPPER = 10000.0;
    private NumberFormat formatter = NumberFormat.getCurrencyInstance(Locale.US);

    public static Money money() {
        return MockNeat.threadLocal().money();
    }

    public Money() {
    }

    public Money(MockNeat mockNeat) {
        super(mockNeat);
    }

    public Money locale(Locale locale) {
        ValidationUtils.notNull(locale, "locale");
        this.formatter = NumberFormat.getCurrencyInstance(locale);
        return this;
    }

    public MockUnitString range(double lowerBound, double upperBound) {
        return () -> this.mockNeat.doubles().range(lowerBound, upperBound).mapToString(this.formatter::format).supplier();
    }

    public MockUnitString bound(double bound) {
        return () -> this.mockNeat.doubles().bound(bound).mapToString(this.formatter::format)::val;
    }

    @Override
    public Supplier<String> supplier() {
        return this.range(0.0, 10000.0).supplier();
    }
}

