/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.financial;

import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.types.enums.CVVType;
import net.andreinc.mockneat.utils.LoopsUtils;
import net.andreinc.mockneat.utils.ValidationUtils;

public class CVVS
extends MockUnitBase
implements MockUnitString {
    public static CVVS cvvs() {
        return MockNeat.threadLocal().cvvs();
    }

    protected CVVS() {
    }

    public CVVS(MockNeat mockNeat) {
        super(mockNeat);
    }

    @Override
    public Supplier<String> supplier() {
        return this.type(CVVType.CVV3).supplier();
    }

    public MockUnitString cvv3() {
        return this.type(CVVType.CVV3);
    }

    public MockUnitString cvv4() {
        return this.type(CVVType.CVV4);
    }

    public MockUnitString type(CVVType type) {
        ValidationUtils.notNull(type, "type");
        Supplier<String> supplier = () -> {
            StringBuilder builder = new StringBuilder();
            LoopsUtils.loop(type.getLength(), () -> builder.append(this.mockNeat.chars().digits().val()));
            return builder.toString();
        };
        return () -> supplier;
    }

    public MockUnitString types(CVVType ... types) {
        ValidationUtils.notEmptyOrNullValues(types, "types");
        return () -> () -> {
            CVVType type = this.mockNeat.from(types).val();
            return (String)this.mockNeat.cvvs().type(type).val();
        };
    }
}

