/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.abstraction;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.andreinc.aleph.AlephFormatter;
import net.andreinc.mockneat.abstraction.MockUnitDouble;
import net.andreinc.mockneat.abstraction.MockUnitInt;
import net.andreinc.mockneat.abstraction.MockUnitLocalDate;
import net.andreinc.mockneat.abstraction.MockUnitLong;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.utils.LoopsUtils;
import net.andreinc.mockneat.utils.MockUnitUtils;
import net.andreinc.mockneat.utils.ValidationUtils;

@FunctionalInterface
public interface MockUnit<T> {
    public Supplier<T> supplier();

    default public T val() {
        return this.supplier().get();
    }

    default public T get() {
        return this.val();
    }

    default public void serialize(String path) throws IOException {
        ValidationUtils.notNull(path, "path");
        T object = this.supplier().get();
        ValidationUtils.isTrue(object instanceof Serializable, "Object is not serializable. Does the add's class extends 'java.io.Serializable' ?", new Object[0]);
        Path cachePath = Paths.get(path, new String[0]);
        try (FileChannel channel = FileChannel.open(cachePath, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);){
            FileLock lock = channel.lock();
            try (ObjectOutputStream oos = new ObjectOutputStream(Channels.newOutputStream(channel));){
                oos.writeObject(object);
                lock.release();
            }
        }
    }

    default public <R> R val(Function<T, R> function) {
        ValidationUtils.notNull(function, "function");
        return function.apply(this.supplier().get());
    }

    default public <R> R get(Function<T, R> function) {
        return this.val(function);
    }

    default public void consume(Consumer<T> consumer) {
        ValidationUtils.notNull(consumer, "consumer");
        consumer.accept(this.val());
    }

    default public void consume(int times, BiConsumer<Integer, T> biConsumer) {
        ValidationUtils.isTrue(times > 0, "The number of times should be a positive number.", new Object[0]);
        ValidationUtils.notNull(biConsumer, "consumer");
        IntStream.range(0, times).forEach(i -> biConsumer.accept(i, this.val()));
    }

    default public String valStr() {
        return this.valStr("");
    }

    default public String valStr(String valueIfNull) {
        T val = this.supplier().get();
        if (null == val) {
            return valueIfNull;
        }
        return val.toString();
    }

    default public <R> MockUnit<R> map(Function<T, R> function) {
        ValidationUtils.notNull(function, "function");
        Supplier<Object> supp = () -> function.apply(this.supplier().get());
        return () -> supp;
    }

    default public MockUnitInt mapToInt(ToIntFunction<T> function) {
        ValidationUtils.notNull(function, "function");
        Supplier<Integer> supp = () -> function.applyAsInt(this.val());
        return () -> supp;
    }

    default public MockUnitDouble mapToDouble(ToDoubleFunction<T> function) {
        ValidationUtils.notNull(function, "function");
        Supplier<Double> supp = () -> function.applyAsDouble(this.val());
        return () -> supp;
    }

    default public MockUnitLong mapToLong(ToLongFunction<T> function) {
        ValidationUtils.notNull(function, "function");
        Supplier<Long> supp = () -> function.applyAsLong(this.val());
        return () -> supp;
    }

    default public MockUnitString mapToString(Function<T, String> function) {
        ValidationUtils.notNull(function, "function");
        Supplier<String> supp = () -> (String)function.apply(this.val());
        return () -> supp;
    }

    default public MockUnitString mapToString() {
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), Object::toString);
    }

    default public MockUnitLocalDate mapToLocalDate(Function<T, LocalDate> dateTransformer) {
        ValidationUtils.notNull(dateTransformer, "dateTransformer");
        Supplier<LocalDate> supp = () -> (LocalDate)dateTransformer.apply(this.val());
        return () -> supp;
    }

    default public MockUnit<Stream<T>> stream() {
        Supplier<Stream> supp = () -> Stream.generate(this.supplier());
        return () -> supp;
    }

    @Deprecated
    default public MockUnit<List<T>> list(Class<? extends List> listClass, int size) {
        ValidationUtils.notNull(listClass, "listClass");
        ValidationUtils.isTrue(size >= 0, "The size needs to be bigger than 0 (>=).", new Object[0]);
        Supplier<List> supp = () -> {
            try {
                List result = (List)listClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                LoopsUtils.loop(size, () -> MockUnitUtils.add(listClass, result, this.supplier()));
                return result;
            }
            catch (Exception e) {
                String fmt = AlephFormatter.str((String)"Cannot instantiate list '#{l.name}'.").arg("l", (Object)listClass).fmt();
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public MockUnit<List<T>> list(Supplier<List<T>> listSupplier, int size) {
        ValidationUtils.notNull(listSupplier, "listSupplier");
        ValidationUtils.isTrue(size >= 0, "The size needs to be bigger than 0 (>=).", new Object[0]);
        Supplier<List> supp = () -> {
            List result = (List)listSupplier.get();
            ValidationUtils.notNullSupp(result, "listSupplier");
            IntStream.range(0, size).forEach(i -> result.add(this.supplier().get()));
            return result;
        };
        return () -> supp;
    }

    @Deprecated
    default public MockUnit<List<T>> list(Class<? extends List> listClass, MockUnitInt sizeUnit) {
        ValidationUtils.notNull(sizeUnit, "sizeUnit");
        return () -> this.list((Class<List>)listClass, (int)((Integer)sizeUnit.val())).supplier();
    }

    default public MockUnit<List<T>> list(Supplier<List<T>> listSupplier, MockUnitInt sizeUnit) {
        ValidationUtils.notNull(sizeUnit, "sizeUnit");
        return () -> this.list(listSupplier, (int)((Integer)sizeUnit.val())).supplier();
    }

    default public MockUnit<List<T>> list(int size) {
        return this.list(ArrayList::new, size);
    }

    default public MockUnit<List<T>> list(MockUnitInt sizeUnit) {
        ValidationUtils.notNull(sizeUnit, "sizeUnit");
        return () -> this.list((Integer)sizeUnit.val()).supplier();
    }

    @Deprecated
    default public MockUnit<Set<T>> set(Class<? extends Set> setClass, int size) {
        ValidationUtils.notNull(setClass, "setClass");
        ValidationUtils.isTrue(size >= 0, "The size needs to be bigger than 0 (>=).", new Object[0]);
        Supplier<Set> supp = () -> {
            try {
                Set result = (Set)setClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                LoopsUtils.loop(size, () -> MockUnitUtils.add(setClass, result, this.supplier()));
                return result;
            }
            catch (Exception e) {
                String fmt = String.format("Cannot instantiate set: '%s'.", setClass.getName());
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public MockUnit<Set<T>> set(Supplier<Set<T>> setSupplier, int size) {
        ValidationUtils.notNull(setSupplier, "setSupplier");
        ValidationUtils.isTrue(size >= 0, "The size needs to be bigger than 0 (>=).", new Object[0]);
        Supplier<Set> supp = () -> {
            Set result = (Set)setSupplier.get();
            ValidationUtils.notNullSupp(result, "setSupplier");
            IntStream.range(0, size).forEach(i -> result.add(this.supplier().get()));
            return result;
        };
        return () -> supp;
    }

    @Deprecated
    default public MockUnit<Set<T>> set(Class<? extends Set> setClass, MockUnitInt sizeUnit) {
        ValidationUtils.notNull(setClass, "setClass");
        ValidationUtils.notNull(sizeUnit, "sizeUnit");
        return () -> this.set((Class<Set>)setClass, (int)((Integer)sizeUnit.val())).supplier();
    }

    default public MockUnit<Set<T>> set(Supplier<Set<T>> setSupplier, MockUnitInt sizeUnit) {
        ValidationUtils.notNull(setSupplier, "setSupplier");
        ValidationUtils.notNull(sizeUnit, "sizeUnit");
        return () -> this.set(setSupplier, (int)((Integer)sizeUnit.val())).supplier();
    }

    default public MockUnit<Set<T>> set(int size) {
        return this.set(HashSet::new, size);
    }

    default public MockUnit<Set<T>> set(MockUnitInt sizeUnit) {
        ValidationUtils.notNull(sizeUnit, "sizeUnit");
        return () -> this.set((Integer)sizeUnit.val()).supplier();
    }

    @Deprecated
    default public MockUnit<Collection<T>> collection(Class<? extends Collection> collectionClass, int size) {
        ValidationUtils.notNull(collectionClass, "collectionClass");
        ValidationUtils.isTrue(size >= 0, "The size needs to be bigger than 0 (>=).", new Object[0]);
        Supplier<Collection> supp = () -> {
            try {
                Collection result = (Collection)collectionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                LoopsUtils.loop(size, () -> MockUnitUtils.add(collectionClass, result, this.supplier()));
                return result;
            }
            catch (Exception e) {
                String fmt = AlephFormatter.str((String)"Cannot instantiate collection: '#{c.name}'.").arg("c", (Object)collectionClass.getName()).fmt();
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public MockUnit<Collection<T>> collection(Supplier<Collection<T>> collectionSupplier, int size) {
        ValidationUtils.notNull(collectionSupplier, "collectionSupplier");
        ValidationUtils.isTrue(size >= 0, "The size needs to be bigger than 0 (>=).", new Object[0]);
        Supplier<Collection> supp = () -> {
            Collection result = (Collection)collectionSupplier.get();
            ValidationUtils.notNullSupp(result, "collectionSupplier");
            IntStream.range(0, size).forEach(i -> result.add(this.supplier().get()));
            return result;
        };
        return () -> supp;
    }

    @Deprecated
    default public MockUnit<Collection<T>> collection(Class<? extends Collection> collectionClass, MockUnitInt sizeUnit) {
        ValidationUtils.notNull(sizeUnit, "sizeUnit");
        return () -> this.collection((Class<Collection>)collectionClass, (int)((Integer)sizeUnit.val())).supplier();
    }

    default public MockUnit<Collection<T>> collection(Supplier<Collection<T>> collectionSupplier, MockUnitInt sizeUnit) {
        ValidationUtils.notNull(sizeUnit, "sizeUnit");
        return () -> this.collection(collectionSupplier, (int)((Integer)sizeUnit.val())).supplier();
    }

    default public MockUnit<Collection<T>> collection(int size) {
        return this.collection(ArrayList::new, size);
    }

    default public MockUnit<Collection<T>> collection(MockUnitInt sizeUnit) {
        ValidationUtils.notNull(sizeUnit, "sizeUnit");
        return () -> this.collection((Integer)sizeUnit.val()).supplier();
    }

    @Deprecated
    default public <R> MockUnit<Map<R, T>> mapKeys(Class<? extends Map> mapClass, int size, Supplier<R> keysSupplier) {
        ValidationUtils.notNull(mapClass, "mapClass");
        ValidationUtils.notNull(keysSupplier, "keysSupplier");
        ValidationUtils.isTrue(size >= 0, "The size needs to be bigger than 0 (>=).", new Object[0]);
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                LoopsUtils.loop(size, () -> this.lambda$mapKeys$43(mapClass, result, (Supplier)keysSupplier));
                return result;
            }
            catch (Exception e) {
                String fmt = AlephFormatter.str((String)"Cannot instantiate map: '#{m.name}'.").arg("m", (Object)mapClass).fmt();
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public <R> MockUnit<Map<R, T>> mapKeys(Supplier<Map<R, T>> mapSupplier, int size, Supplier<R> keySupplier) {
        ValidationUtils.notNull(mapSupplier, "mapSupplier");
        ValidationUtils.isTrue(size >= 0, "The size needs to be bigger than 0 (>=).", new Object[0]);
        ValidationUtils.notNull(keySupplier, "keySupplier");
        Supplier<Map> supp = () -> {
            Map result = (Map)mapSupplier.get();
            ValidationUtils.notNullSupp(result, "keySupplier");
            IntStream.range(0, size).forEach(arg_0 -> this.lambda$mapKeys$46(result, (Supplier)keySupplier, arg_0));
            return result;
        };
        return () -> supp;
    }

    @Deprecated
    default public <R> MockUnit<Map<R, T>> mapKeys(Class<? extends Map> mapClass, MockUnitInt sizeUnit, Supplier<R> keysSupplier) {
        ValidationUtils.notNull(sizeUnit, "sizeUnit");
        return () -> this.mapKeys((Class<Map>)mapClass, (int)((Integer)sizeUnit.val()), keysSupplier).supplier();
    }

    default public <R> MockUnit<Map<R, T>> mapKeys(Supplier<Map<R, T>> mapSupplier, MockUnitInt sizeUnit, Supplier<R> keySupplier) {
        ValidationUtils.notNull(sizeUnit, "sizeUnit");
        return () -> this.mapKeys(mapSupplier, (int)((Integer)sizeUnit.val()), keySupplier).supplier();
    }

    default public <R> MockUnit<Map<R, T>> mapKeys(int size, Supplier<R> keysSupplier) {
        return this.mapKeys(HashMap::new, size, keysSupplier);
    }

    default public <R> MockUnit<Map<R, T>> mapKeys(MockUnitInt sizeUnit, Supplier<R> keysSupplier) {
        ValidationUtils.notNull(sizeUnit, "sizeUnit");
        return () -> this.mapKeys((Integer)sizeUnit.val(), keysSupplier).supplier();
    }

    @Deprecated
    default public <R> MockUnit<Map<R, T>> mapKeys(Class<? extends Map> mapClass, Iterable<R> keys) {
        ValidationUtils.notNull(mapClass, "mapClass");
        ValidationUtils.notNull(keys, "keys");
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                keys.forEach(key -> MockUnitUtils.put(mapClass, result, key, this.supplier().get()));
                return result;
            }
            catch (Exception e) {
                String fmt = AlephFormatter.str((String)"Cannot instantiate map: '#{m.name}'.").arg("m", (Object)mapClass).fmt();
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public <R> MockUnit<Map<R, T>> mapKeys(Supplier<Map<R, T>> mapSupplier, Iterable<R> keys) {
        ValidationUtils.notNull(mapSupplier, "mapSupplier");
        ValidationUtils.notNull(keys, "keys");
        Supplier<Map> supp = () -> {
            Map result = (Map)mapSupplier.get();
            ValidationUtils.notNullSupp(result, "mapSupplier");
            keys.forEach(key -> result.put(key, this.supplier().get()));
            return result;
        };
        return () -> supp;
    }

    default public <R> MockUnit<Map<R, T>> mapKeys(Iterable<R> keys) {
        return this.mapKeys(HashMap::new, keys);
    }

    @Deprecated
    default public <R> MockUnit<Map<R, T>> mapKeys(Class<? extends Map> mapClass, R[] keys) {
        ValidationUtils.notNull(mapClass, "mapClass");
        ValidationUtils.notNull(keys, "keys");
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Arrays.stream(keys).forEach(key -> MockUnitUtils.put(mapClass, result, key, this.supplier().get()));
                return result;
            }
            catch (Exception e) {
                String fmt = AlephFormatter.str((String)"Cannot instantiate map: '#{m.name}'.").arg("m", (Object)mapClass).fmt();
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public <R> MockUnit<Map<R, T>> mapKeys(Supplier<Map<R, T>> mapSupplier, R[] keys) {
        ValidationUtils.notNull(mapSupplier, "mapSupplier");
        ValidationUtils.notNull(keys, "keys");
        Supplier<Map> supp = () -> {
            Map result = (Map)mapSupplier.get();
            ValidationUtils.notNullSupp(result, "mapSupplier");
            Arrays.stream(keys).forEach(key -> result.put(key, this.supplier().get()));
            return result;
        };
        return () -> supp;
    }

    default public <R> MockUnit<Map<R, T>> mapKeys(R[] keys) {
        return this.mapKeys(HashMap::new, keys);
    }

    @Deprecated
    default public MockUnit<Map<Integer, T>> mapKeys(Class<? extends Map> mapClass, int[] keys) {
        ValidationUtils.notNull(mapClass, "mapClass");
        ValidationUtils.notNull(keys, "keys");
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Arrays.stream(keys).forEach(key -> MockUnitUtils.put(mapClass, result, key, this.supplier().get()));
                return result;
            }
            catch (Exception e) {
                String fmt = AlephFormatter.str((String)"Cannot instantiate map: '#{m.name}'.").arg("m", (Object)mapClass).fmt();
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public MockUnit<Map<Integer, T>> mapKeys(Supplier<Map<Integer, T>> mapSupplier, int[] keys) {
        ValidationUtils.notNull(mapSupplier, "mapSupplier");
        ValidationUtils.notNull(keys, "keys");
        Supplier<Map> supp = () -> {
            Map result = (Map)mapSupplier.get();
            ValidationUtils.notNullSupp(result, "mapSupplier");
            Arrays.stream(keys).forEach(key -> result.put(key, this.supplier().get()));
            return result;
        };
        return () -> supp;
    }

    default public MockUnit<Map<Integer, T>> mapKeys(int[] keys) {
        return this.mapKeys(HashMap::new, keys);
    }

    @Deprecated
    default public MockUnit<Map<Long, T>> mapKeys(Class<? extends Map> mapClass, long[] keys) {
        ValidationUtils.notNull(mapClass, "mapClass");
        ValidationUtils.notNull(keys, "keys");
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Arrays.stream(keys).forEach(key -> MockUnitUtils.put(mapClass, result, key, this.supplier().get()));
                return result;
            }
            catch (Exception e) {
                String fmt = AlephFormatter.str((String)"Cannot instantiate map: '#{m.name}'.").arg("m", (Object)mapClass).fmt();
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public MockUnit<Map<Long, T>> mapKeys(Supplier<Map<Long, T>> mapSupplier, long[] keys) {
        ValidationUtils.notNull(mapSupplier, "mapSupplier");
        ValidationUtils.notNull(keys, "keys");
        Supplier<Map> supp = () -> {
            Map result = (Map)mapSupplier.get();
            ValidationUtils.notNullSupp(result, "mapSupplier");
            Arrays.stream(keys).forEach(key -> result.put(key, this.supplier().get()));
            return result;
        };
        return () -> supp;
    }

    default public MockUnit<Map<Long, T>> mapKeys(long[] keys) {
        return this.mapKeys(HashMap::new, keys);
    }

    @Deprecated
    default public MockUnit<Map<Double, T>> mapKeys(Class<? extends Map> mapClass, double[] keys) {
        ValidationUtils.notNull(mapClass, "mapClass");
        ValidationUtils.notNull(keys, "keys");
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Arrays.stream(keys).forEach(key -> MockUnitUtils.put(mapClass, result, key, this.supplier().get()));
                return result;
            }
            catch (Exception e) {
                String fmt = AlephFormatter.str((String)"Cannot instantiate map: '#{m.name}'.").arg("m", (Object)mapClass).fmt();
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public MockUnit<Map<Double, T>> mapKeys(Supplier<Map<Double, T>> mapSupplier, double[] keys) {
        ValidationUtils.notNull(mapSupplier, "mapSupplier");
        ValidationUtils.notNull(keys, "keys");
        Supplier<Map> supp = () -> {
            Map result = (Map)mapSupplier.get();
            ValidationUtils.notNullSupp(result, "mapSupplier");
            Arrays.stream(keys).forEach(key -> result.put(key, this.supplier().get()));
            return result;
        };
        return () -> supp;
    }

    default public MockUnit<Map<Double, T>> mapKeys(double[] keys) {
        return this.mapKeys(HashMap::new, keys);
    }

    @Deprecated
    default public <R> MockUnit<Map<T, R>> mapVals(Class<? extends Map> mapClass, int size, Supplier<R> valuesSupplier) {
        ValidationUtils.notNull(mapClass, "mapClass");
        ValidationUtils.notNull(valuesSupplier, "valuesSupplier");
        ValidationUtils.isTrue(size >= 0, "The size needs to be bigger than 0 (>=).", new Object[0]);
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                LoopsUtils.loop(size, () -> this.lambda$mapVals$82(mapClass, result, (Supplier)valuesSupplier));
                return result;
            }
            catch (Exception e) {
                String fmt = AlephFormatter.str((String)"Cannot instantiate map: '#{m.name}'.").arg("m", (Object)mapClass).fmt();
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public <R> MockUnit<Map<T, R>> mapVals(Supplier<Map<T, R>> mapSupplier, int size, Supplier<R> valuesSupplier) {
        ValidationUtils.notNull(mapSupplier, "mapSupplier");
        ValidationUtils.notNull(valuesSupplier, "valuesSupplier");
        ValidationUtils.isTrue(size >= 0, "The size needs to be bigger than 0 (>=).", new Object[0]);
        Supplier<Map> supp = () -> {
            Map result = (Map)mapSupplier.get();
            ValidationUtils.notNullSupp(result, "mapSupplier");
            IntStream.range(0, size).forEach(arg_0 -> this.lambda$mapVals$85(result, (Supplier)valuesSupplier, arg_0));
            return result;
        };
        return () -> supp;
    }

    @Deprecated
    default public <R> MockUnit<Map<T, R>> mapVals(Class<? extends Map> mapClass, MockUnitInt sizeUnit, Supplier<R> valuesSupplier) {
        return () -> this.mapVals((Class<Map>)mapClass, (int)((Integer)sizeUnit.val()), valuesSupplier).supplier();
    }

    default public <R> MockUnit<Map<T, R>> mapVals(Supplier<Map<T, R>> mapSupplier, MockUnitInt sizeUnit, Supplier<R> valuesSupplier) {
        ValidationUtils.notNull(sizeUnit, "sizeUnit");
        return () -> this.mapVals(mapSupplier, (int)((Integer)sizeUnit.val()), valuesSupplier).supplier();
    }

    default public <R> MockUnit<Map<T, R>> mapVals(int size, Supplier<R> valuesSupplier) {
        return this.mapVals(HashMap::new, size, valuesSupplier);
    }

    default public <R> MockUnit<Map<T, R>> mapVals(MockUnitInt sizeUnit, Supplier<R> valuesSupplier) {
        return () -> this.mapVals((Integer)sizeUnit.val(), valuesSupplier).supplier();
    }

    @Deprecated
    default public <R> MockUnit<Map<T, R>> mapVals(Class<? extends Map> mapClass, Iterable<R> values) {
        ValidationUtils.notNull(mapClass, "mapClass");
        ValidationUtils.notNull(values, "values");
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                values.forEach(value -> MockUnitUtils.put(mapClass, result, this.supplier().get(), value));
                return result;
            }
            catch (Exception e) {
                String fmt = AlephFormatter.str((String)"Cannot instantiate map: '#{m.name}'.").arg("m", (Object)mapClass).fmt();
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public <R> MockUnit<Map<T, R>> mapVals(Supplier<Map<T, R>> mapSupplier, Iterable<R> values) {
        ValidationUtils.notNull(mapSupplier, "mapSupplier");
        ValidationUtils.notNull(values, "values");
        Supplier<Map> supp = () -> {
            Map result = (Map)mapSupplier.get();
            ValidationUtils.notNullSupp(result, "result");
            values.forEach(value -> result.put(this.supplier().get(), value));
            return result;
        };
        return () -> supp;
    }

    default public <R> MockUnit<Map<T, R>> mapVals(Iterable<R> values) {
        return this.mapVals(HashMap::new, values);
    }

    @Deprecated
    default public <R> MockUnit<Map<T, R>> mapVals(Class<? extends Map> mapClass, R[] values) {
        ValidationUtils.notNull(mapClass, "mapClass");
        ValidationUtils.notNull(values, "values");
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Arrays.stream(values).forEach(value -> MockUnitUtils.put(mapClass, result, this.supplier().get(), value));
                return result;
            }
            catch (Exception e) {
                String fmt = AlephFormatter.str((String)"Cannot instantiate map: '#{m.name}'.").arg("m", (Object)mapClass).fmt();
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public <R> MockUnit<Map<T, R>> mapVals(Supplier<Map<T, R>> mapSupplier, R[] values) {
        ValidationUtils.notNull(mapSupplier, "mapSupplier");
        ValidationUtils.notNull(values, "values");
        Supplier<Map> supp = () -> {
            Map result = (Map)mapSupplier.get();
            ValidationUtils.notNullSupp(result, "result");
            Arrays.stream(values).forEach(value -> result.put(this.supplier().get(), value));
            return result;
        };
        return () -> supp;
    }

    default public <R> MockUnit<Map<T, R>> mapVals(R[] values) {
        return this.mapVals(HashMap::new, values);
    }

    @Deprecated
    default public MockUnit<Map<T, Integer>> mapVals(Class<? extends Map> mapClass, int[] values) {
        ValidationUtils.notNull(mapClass, "mapClass");
        ValidationUtils.notNull(values, "values");
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Arrays.stream(values).forEach(value -> MockUnitUtils.put(mapClass, result, this.supplier().get(), value));
                return result;
            }
            catch (Exception e) {
                String fmt = AlephFormatter.str((String)"Cannot instantiate map: '#{m.name}'.").arg("m", (Object)mapClass).fmt();
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public MockUnit<Map<T, Integer>> mapVals(Supplier<Map<T, Integer>> mapSupplier, int[] values) {
        ValidationUtils.notNull(mapSupplier, "mapSupplier");
        ValidationUtils.notNull(values, "values");
        Supplier<Map> supp = () -> {
            Map result = (Map)mapSupplier.get();
            ValidationUtils.notNullSupp(result, "mapSupplier");
            Arrays.stream(values).forEach(value -> result.put(this.supplier().get(), value));
            return result;
        };
        return () -> supp;
    }

    default public MockUnit<Map<T, Integer>> mapVals(int[] values) {
        return this.mapVals(HashMap::new, values);
    }

    @Deprecated
    default public MockUnit<Map<T, Long>> mapVals(Class<? extends Map> mapClass, long[] values) {
        ValidationUtils.notNull(mapClass, "mapClass");
        ValidationUtils.notNull(values, "values");
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Arrays.stream(values).forEach(value -> MockUnitUtils.put(mapClass, result, this.supplier().get(), value));
                return result;
            }
            catch (Exception e) {
                String fmt = AlephFormatter.str((String)"Cannot instantiate map: '#{m.name}'.").arg("m", (Object)mapClass).fmt();
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public MockUnit<Map<T, Long>> mapVals(Supplier<Map<T, Long>> mapSupplier, long[] values) {
        ValidationUtils.notNull(mapSupplier, "mapSupplier");
        ValidationUtils.notNull(values, "values");
        Supplier<Map> supp = () -> {
            Map result = (Map)mapSupplier.get();
            ValidationUtils.notNullSupp(result, "mapSupplier");
            Arrays.stream(values).forEach(value -> result.put(this.supplier().get(), value));
            return result;
        };
        return () -> supp;
    }

    default public MockUnit<Map<T, Long>> mapVals(long[] values) {
        return this.mapVals(HashMap::new, values);
    }

    @Deprecated
    default public MockUnit<Map<T, Double>> mapVals(Class<? extends Map> mapClass, double[] values) {
        ValidationUtils.notNull(mapClass, "mapClass");
        ValidationUtils.notNull(values, "values");
        Supplier<Map> supp = () -> {
            try {
                Map result = (Map)mapClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Arrays.stream(values).forEach(value -> MockUnitUtils.put(mapClass, result, this.supplier().get(), value));
                return result;
            }
            catch (Exception e) {
                String fmt = AlephFormatter.str((String)"Cannot instantiate map: '#{m.name}'.").arg("m", (Object)mapClass).fmt();
                throw new IllegalArgumentException(fmt, e);
            }
        };
        return () -> supp;
    }

    default public MockUnit<Map<T, Double>> mapVals(Supplier<Map<T, Double>> mapSupplier, double[] values) {
        ValidationUtils.notNull(mapSupplier, "mapSupplier");
        ValidationUtils.notNull(values, "values");
        Supplier<Map> supp = () -> {
            Map result = (Map)mapSupplier.get();
            ValidationUtils.notNullSupp(result, "mapSupplier");
            Arrays.stream(values).forEach(value -> result.put(this.supplier().get(), value));
            return result;
        };
        return () -> supp;
    }

    default public MockUnit<Map<T, Double>> mapVals(double[] values) {
        return this.mapVals(HashMap::new, values);
    }

    default public MockUnit<T[]> array(Class<T> cls, int size) {
        ValidationUtils.notNull(cls, "cls");
        ValidationUtils.isTrue(size >= 0, "The size needs to be bigger than 0 (>=).", new Object[0]);
        Supplier<Object[]> supp = () -> {
            Object[] objs = (Object[])Array.newInstance(cls, size);
            IntStream.range(0, size).forEach(i -> {
                objs[i] = this.supplier().get();
            });
            return objs;
        };
        return () -> supp;
    }

    default public MockUnit<T[]> array(Supplier<T[]> arraySupplier) {
        ValidationUtils.notNull(arraySupplier, "arraySupplier");
        Supplier<Object[]> supp = () -> {
            Object[] result = (Object[])arraySupplier.get();
            ValidationUtils.notNullSupp(result, "arraySupplier");
            IntStream.range(0, result.length).forEach(i -> {
                result[i] = this.supplier().get();
            });
            return result;
        };
        return () -> supp;
    }

    private /* synthetic */ void lambda$mapVals$85(Map result, Supplier valuesSupplier, int i) {
        result.put(this.supplier().get(), valuesSupplier.get());
    }

    private /* synthetic */ void lambda$mapVals$82(Class mapClass, Map result, Supplier valuesSupplier) {
        MockUnitUtils.put((Class<? extends Map>)mapClass, result, this.supplier(), valuesSupplier);
    }

    private /* synthetic */ void lambda$mapKeys$46(Map result, Supplier keySupplier, int i) {
        result.put(keySupplier.get(), this.supplier().get());
    }

    private /* synthetic */ void lambda$mapKeys$43(Class mapClass, Map result, Supplier keysSupplier) {
        MockUnitUtils.put((Class<? extends Map>)mapClass, result, keysSupplier, this.supplier());
    }
}

