/*
 * Decompiled with CFR 0.152.
 */
package net.aksingh.owmjapis.core;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.net.InetSocketAddress;
import java.net.Proxy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.aksingh.owmjapis.api.APIException;
import net.aksingh.owmjapis.api.CurrentWeatherAPI;
import net.aksingh.owmjapis.api.DailyForecastAPI;
import net.aksingh.owmjapis.api.HourlyForecastAPI;
import net.aksingh.owmjapis.model.CurrentWeather;
import net.aksingh.owmjapis.model.DailyForecast;
import net.aksingh.owmjapis.model.HourlyForecast;
import net.aksingh.owmjapis.util.OkHttpTools;
import net.aksingh.owmjapis.util.SystemTools;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0004;<=>B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0003H\u0007J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0018\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0007J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u0018H\u0007J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0007H\u0007J\u0010\u0010&\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u0003H\u0007J\u0018\u0010&\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0007H\u0007J\u0018\u0010&\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J \u0010&\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u0007H\u0007J\u0018\u0010'\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0007J \u0010'\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\u0007H\u0007J\u0010\u0010(\u001a\u00020$2\u0006\u0010\"\u001a\u00020\u0018H\u0007J\u0018\u0010(\u001a\u00020$2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u0007H\u0007J\u0018\u0010(\u001a\u00020$2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J \u0010(\u001a\u00020$2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u0007H\u0007J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010+\u001a\u00020*2\u0006\u0010\u001a\u001a\u00020\u0003H\u0007J\u0018\u0010+\u001a\u00020*2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0018\u0010,\u001a\u00020*2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0007J\u0010\u0010-\u001a\u00020*2\u0006\u0010\"\u001a\u00020\u0018H\u0007J\u0018\u0010-\u001a\u00020*2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u00101\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u0006\u00102\u001a\u00020\u0000J\u000e\u00103\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u00103\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003J\u0016\u00103\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u0018J\u001e\u00103\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u000209J&\u00103\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00182\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003J.\u00103\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00182\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u00032\u0006\u00108\u001a\u000209J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000b\u0010\u0004R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lnet/aksingh/owmjapis/core/OWM;", "", "apiKey", "", "(Ljava/lang/String;)V", "OWM_25_BASE_URL", "OWM_25_DAILY_FORECAST_MAX_COUNT", "", "accuracy", "Lnet/aksingh/owmjapis/core/OWM$Accuracy;", "value", "setApiKey", "lang", "Lnet/aksingh/owmjapis/core/OWM$Language;", "proxy", "Ljava/net/Proxy;", "retrofit", "Lretrofit2/Retrofit;", "unit", "Lnet/aksingh/owmjapis/core/OWM$Unit;", "createRetrofitInstance", "currentWeatherByCityId", "Lnet/aksingh/owmjapis/model/CurrentWeather;", "cityId", "", "currentWeatherByCityName", "cityName", "countryCode", "Lnet/aksingh/owmjapis/core/OWM$Country;", "currentWeatherByCoords", "latitude", "", "longitude", "currentWeatherByZipCode", "zipCode", "dailyForecastByCityId", "Lnet/aksingh/owmjapis/model/DailyForecast;", "count", "dailyForecastByCityName", "dailyForecastByCoords", "dailyForecastByZipCode", "hourlyForecastByCityId", "Lnet/aksingh/owmjapis/model/HourlyForecast;", "hourlyForecastByCityName", "hourlyForecastByCoords", "hourlyForecastByZipCode", "resetProxy", "", "setAccuracy", "setLanguage", "setNoProxy", "setProxy", "user", "pass", "host", "port", "type", "Ljava/net/Proxy$Type;", "setUnit", "Accuracy", "Country", "Language", "Unit", "owm-japis"})
public final class OWM {
    private final String OWM_25_BASE_URL = "https://api.openweathermap.org/data/2.5/";
    private final byte OWM_25_DAILY_FORECAST_MAX_COUNT = 16;
    private String apiKey;
    private Accuracy accuracy;
    private Unit unit;
    private Language lang;
    private Proxy proxy;
    private Retrofit retrofit;

    private final void setApiKey(String value) {
        CharSequence charSequence = value;
        if (charSequence.length() == 0 || StringsKt.isBlank((CharSequence)value)) {
            throw (Throwable)new IllegalArgumentException("API key can't be empty/blank. Kindly get an API key from OpenWeatherMap.org");
        }
        this.apiKey = value;
    }

    @NotNull
    public final OWM setAccuracy(@NotNull Accuracy accuracy) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)accuracy), (String)"accuracy");
        this.accuracy = accuracy;
        this.retrofit = this.createRetrofitInstance(this.proxy);
        return this;
    }

    @NotNull
    public final OWM setUnit(@NotNull Unit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        this.unit = unit;
        this.retrofit = this.createRetrofitInstance(this.proxy);
        return this;
    }

    @NotNull
    public final OWM setLanguage(@NotNull Language lang) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)lang), (String)"lang");
        this.lang = lang;
        this.retrofit = this.createRetrofitInstance(this.proxy);
        return this;
    }

    @NotNull
    public final OWM setProxy(@NotNull Proxy proxy) {
        Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
        this.retrofit = this.createRetrofitInstance(proxy);
        return this;
    }

    @NotNull
    public final OWM setProxy(@NotNull Proxy proxy, @NotNull String user, @NotNull String pass) {
        Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)pass, (String)"pass");
        this.setProxy(proxy);
        SystemTools.Static.setProxyAuthDetails(user, pass);
        return this;
    }

    @NotNull
    public final OWM setProxy(@NotNull String host, int port) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        this.setProxy(host, port, Proxy.Type.HTTP);
        return this;
    }

    @NotNull
    public final OWM setProxy(@NotNull String host, int port, @NotNull Proxy.Type type) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        this.proxy = new Proxy(type, new InetSocketAddress(host, port));
        this.setProxy(this.proxy);
        return this;
    }

    @NotNull
    public final OWM setProxy(@NotNull String host, int port, @NotNull String user, @NotNull String pass) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)pass, (String)"pass");
        this.setProxy(host, port, user, pass, Proxy.Type.HTTP);
        return this;
    }

    @NotNull
    public final OWM setProxy(@NotNull String host, int port, @NotNull String user, @NotNull String pass, @NotNull Proxy.Type type) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)pass, (String)"pass");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        this.setProxy(host, port, type);
        SystemTools.Static.setProxyAuthDetails(user, pass);
        return this;
    }

    @NotNull
    public final OWM setNoProxy() {
        Proxy proxy = Proxy.NO_PROXY;
        Intrinsics.checkExpressionValueIsNotNull((Object)proxy, (String)"Proxy.NO_PROXY");
        this.setProxy(proxy);
        return this;
    }

    public final void resetProxy() {
        this.setProxy(SystemTools.Static.getSystemProxy());
        SystemTools.Static.setProxyAuthDetails("", "");
    }

    @NotNull
    public final CurrentWeather currentWeatherByCityName(@NotNull String cityName) throws APIException {
        Intrinsics.checkParameterIsNotNull((Object)cityName, (String)"cityName");
        CurrentWeatherAPI api = (CurrentWeatherAPI)this.retrofit.create(CurrentWeatherAPI.class);
        Call<CurrentWeather> apiCall = api.getCurrentWeatherByCityName(cityName);
        Response apiResp = apiCall.execute();
        CurrentWeather weather = (CurrentWeather)apiResp.body();
        if (weather == null) {
            if (!apiResp.isSuccessful()) {
                int n = apiResp.code();
                String string = apiResp.message();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"apiResp.message()");
                throw (Throwable)new APIException(n, string);
            }
            weather = new CurrentWeather(null, null, null, null, null, null, null, null, null, null, null, null, null, 8191, null);
        }
        return weather;
    }

    @NotNull
    public final CurrentWeather currentWeatherByCityName(@NotNull String cityName, @NotNull Country countryCode) throws APIException {
        Intrinsics.checkParameterIsNotNull((Object)cityName, (String)"cityName");
        Intrinsics.checkParameterIsNotNull((Object)((Object)countryCode), (String)"countryCode");
        return this.currentWeatherByCityName(cityName + "," + (Object)((Object)countryCode));
    }

    @NotNull
    public final CurrentWeather currentWeatherByCityId(int cityId) throws APIException {
        CurrentWeatherAPI api = (CurrentWeatherAPI)this.retrofit.create(CurrentWeatherAPI.class);
        Call<CurrentWeather> apiCall = api.getCurrentWeatherByCityId(cityId);
        Response apiResp = apiCall.execute();
        CurrentWeather weather = (CurrentWeather)apiResp.body();
        if (weather == null) {
            if (!apiResp.isSuccessful()) {
                int n = apiResp.code();
                String string = apiResp.message();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"apiResp.message()");
                throw (Throwable)new APIException(n, string);
            }
            weather = new CurrentWeather(null, null, null, null, null, null, null, null, null, null, null, null, null, 8191, null);
        }
        return weather;
    }

    @NotNull
    public final CurrentWeather currentWeatherByCoords(float latitude, float longitude) throws APIException {
        CurrentWeatherAPI api = (CurrentWeatherAPI)this.retrofit.create(CurrentWeatherAPI.class);
        Call<CurrentWeather> apiCall = api.getCurrentWeatherByCoords(latitude, longitude);
        Response apiResp = apiCall.execute();
        CurrentWeather weather = (CurrentWeather)apiResp.body();
        if (weather == null) {
            if (!apiResp.isSuccessful()) {
                int n = apiResp.code();
                String string = apiResp.message();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"apiResp.message()");
                throw (Throwable)new APIException(n, string);
            }
            weather = new CurrentWeather(null, null, null, null, null, null, null, null, null, null, null, null, null, 8191, null);
        }
        return weather;
    }

    @NotNull
    public final CurrentWeather currentWeatherByZipCode(int zipCode) throws APIException {
        return this.currentWeatherByZipCode(zipCode, Country.UNITED_STATES);
    }

    @NotNull
    public final CurrentWeather currentWeatherByZipCode(int zipCode, @NotNull Country countryCode) throws APIException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)countryCode), (String)"countryCode");
        CurrentWeatherAPI api = (CurrentWeatherAPI)this.retrofit.create(CurrentWeatherAPI.class);
        Call<CurrentWeather> apiCall = api.getCurrentWeatherByZipCode(String.valueOf(zipCode) + "," + (Object)((Object)countryCode));
        Response apiResp = apiCall.execute();
        CurrentWeather weather = (CurrentWeather)apiResp.body();
        if (weather == null) {
            if (!apiResp.isSuccessful()) {
                int n = apiResp.code();
                String string = apiResp.message();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"apiResp.message()");
                throw (Throwable)new APIException(n, string);
            }
            weather = new CurrentWeather(null, null, null, null, null, null, null, null, null, null, null, null, null, 8191, null);
        }
        return weather;
    }

    @NotNull
    public final HourlyForecast hourlyForecastByCityName(@NotNull String cityName) throws APIException {
        Intrinsics.checkParameterIsNotNull((Object)cityName, (String)"cityName");
        HourlyForecastAPI api = (HourlyForecastAPI)this.retrofit.create(HourlyForecastAPI.class);
        Call<HourlyForecast> apiCall = api.getHourlyForecastByCityName(cityName);
        Response apiResp = apiCall.execute();
        HourlyForecast forecast = (HourlyForecast)apiResp.body();
        if (forecast == null) {
            if (!apiResp.isSuccessful()) {
                int n = apiResp.code();
                String string = apiResp.message();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"apiResp.message()");
                throw (Throwable)new APIException(n, string);
            }
            forecast = new HourlyForecast(null, null, null, null, null, 31, null);
        }
        return forecast;
    }

    @NotNull
    public final HourlyForecast hourlyForecastByCityName(@NotNull String cityName, @NotNull Country countryCode) throws APIException {
        Intrinsics.checkParameterIsNotNull((Object)cityName, (String)"cityName");
        Intrinsics.checkParameterIsNotNull((Object)((Object)countryCode), (String)"countryCode");
        return this.hourlyForecastByCityName(cityName + "," + (Object)((Object)countryCode));
    }

    @NotNull
    public final HourlyForecast hourlyForecastByCityId(int cityId) throws APIException {
        HourlyForecastAPI api = (HourlyForecastAPI)this.retrofit.create(HourlyForecastAPI.class);
        Call<HourlyForecast> apiCall = api.getHourlyForecastByCityId(cityId);
        Response apiResp = apiCall.execute();
        HourlyForecast forecast = (HourlyForecast)apiResp.body();
        if (forecast == null) {
            if (!apiResp.isSuccessful()) {
                int n = apiResp.code();
                String string = apiResp.message();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"apiResp.message()");
                throw (Throwable)new APIException(n, string);
            }
            forecast = new HourlyForecast(null, null, null, null, null, 31, null);
        }
        return forecast;
    }

    @NotNull
    public final HourlyForecast hourlyForecastByCoords(float latitude, float longitude) throws APIException {
        HourlyForecastAPI api = (HourlyForecastAPI)this.retrofit.create(HourlyForecastAPI.class);
        Call<HourlyForecast> apiCall = api.getHourlyForecastByCoords(latitude, longitude);
        Response apiResp = apiCall.execute();
        HourlyForecast forecast = (HourlyForecast)apiResp.body();
        if (forecast == null) {
            if (!apiResp.isSuccessful()) {
                int n = apiResp.code();
                String string = apiResp.message();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"apiResp.message()");
                throw (Throwable)new APIException(n, string);
            }
            forecast = new HourlyForecast(null, null, null, null, null, 31, null);
        }
        return forecast;
    }

    @NotNull
    public final HourlyForecast hourlyForecastByZipCode(int zipCode) throws APIException {
        return this.hourlyForecastByZipCode(zipCode, Country.UNITED_STATES);
    }

    @NotNull
    public final HourlyForecast hourlyForecastByZipCode(int zipCode, @NotNull Country countryCode) throws APIException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)countryCode), (String)"countryCode");
        HourlyForecastAPI api = (HourlyForecastAPI)this.retrofit.create(HourlyForecastAPI.class);
        Call<HourlyForecast> apiCall = api.getHourlyForecastByZipCode(String.valueOf(zipCode) + "," + (Object)((Object)countryCode));
        Response apiResp = apiCall.execute();
        HourlyForecast forecast = (HourlyForecast)apiResp.body();
        if (forecast == null) {
            if (!apiResp.isSuccessful()) {
                int n = apiResp.code();
                String string = apiResp.message();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"apiResp.message()");
                throw (Throwable)new APIException(n, string);
            }
            forecast = new HourlyForecast(null, null, null, null, null, 31, null);
        }
        return forecast;
    }

    @NotNull
    public final DailyForecast dailyForecastByCityName(@NotNull String cityName) throws APIException {
        Intrinsics.checkParameterIsNotNull((Object)cityName, (String)"cityName");
        return this.dailyForecastByCityName(cityName, this.OWM_25_DAILY_FORECAST_MAX_COUNT);
    }

    @NotNull
    public final DailyForecast dailyForecastByCityName(@NotNull String cityName, byte count) throws APIException {
        Intrinsics.checkParameterIsNotNull((Object)cityName, (String)"cityName");
        DailyForecastAPI api = (DailyForecastAPI)this.retrofit.create(DailyForecastAPI.class);
        Call<DailyForecast> apiCall = api.getDailyForecastByCityName(cityName, count);
        Response apiResp = apiCall.execute();
        DailyForecast forecast = (DailyForecast)apiResp.body();
        if (forecast == null) {
            if (!apiResp.isSuccessful()) {
                int n = apiResp.code();
                String string = apiResp.message();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"apiResp.message()");
                throw (Throwable)new APIException(n, string);
            }
            forecast = new DailyForecast(null, null, null, null, null, 31, null);
        }
        return forecast;
    }

    @NotNull
    public final DailyForecast dailyForecastByCityName(@NotNull String cityName, @NotNull Country countryCode) throws APIException {
        Intrinsics.checkParameterIsNotNull((Object)cityName, (String)"cityName");
        Intrinsics.checkParameterIsNotNull((Object)((Object)countryCode), (String)"countryCode");
        return this.dailyForecastByCityName(cityName, countryCode, this.OWM_25_DAILY_FORECAST_MAX_COUNT);
    }

    @NotNull
    public final DailyForecast dailyForecastByCityName(@NotNull String cityName, @NotNull Country countryCode, byte count) throws APIException {
        Intrinsics.checkParameterIsNotNull((Object)cityName, (String)"cityName");
        Intrinsics.checkParameterIsNotNull((Object)((Object)countryCode), (String)"countryCode");
        return this.dailyForecastByCityName(cityName + "," + (Object)((Object)countryCode), count);
    }

    @NotNull
    public final DailyForecast dailyForecastByCityId(int cityId) throws APIException {
        return this.dailyForecastByCityId(cityId, this.OWM_25_DAILY_FORECAST_MAX_COUNT);
    }

    @NotNull
    public final DailyForecast dailyForecastByCityId(int cityId, byte count) throws APIException {
        DailyForecastAPI api = (DailyForecastAPI)this.retrofit.create(DailyForecastAPI.class);
        Call<DailyForecast> apiCall = api.getDailyForecastByCityId(cityId, count);
        Response apiResp = apiCall.execute();
        DailyForecast forecast = (DailyForecast)apiResp.body();
        if (forecast == null) {
            if (!apiResp.isSuccessful()) {
                int n = apiResp.code();
                String string = apiResp.message();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"apiResp.message()");
                throw (Throwable)new APIException(n, string);
            }
            forecast = new DailyForecast(null, null, null, null, null, 31, null);
        }
        return forecast;
    }

    @NotNull
    public final DailyForecast dailyForecastByCoords(float latitude, float longitude) throws APIException {
        return this.dailyForecastByCoords(latitude, longitude, this.OWM_25_DAILY_FORECAST_MAX_COUNT);
    }

    @NotNull
    public final DailyForecast dailyForecastByCoords(float latitude, float longitude, byte count) throws APIException {
        DailyForecastAPI api = (DailyForecastAPI)this.retrofit.create(DailyForecastAPI.class);
        Call<DailyForecast> apiCall = api.getDailyForecastByCoords(latitude, longitude, count);
        Response apiResp = apiCall.execute();
        DailyForecast forecast = (DailyForecast)apiResp.body();
        if (forecast == null) {
            if (!apiResp.isSuccessful()) {
                int n = apiResp.code();
                String string = apiResp.message();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"apiResp.message()");
                throw (Throwable)new APIException(n, string);
            }
            forecast = new DailyForecast(null, null, null, null, null, 31, null);
        }
        return forecast;
    }

    @NotNull
    public final DailyForecast dailyForecastByZipCode(int zipCode) throws APIException {
        return this.dailyForecastByZipCode(zipCode, Country.UNITED_STATES, this.OWM_25_DAILY_FORECAST_MAX_COUNT);
    }

    @NotNull
    public final DailyForecast dailyForecastByZipCode(int zipCode, byte count) throws APIException {
        return this.dailyForecastByZipCode(zipCode, Country.UNITED_STATES, count);
    }

    @NotNull
    public final DailyForecast dailyForecastByZipCode(int zipCode, @NotNull Country countryCode) throws APIException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)countryCode), (String)"countryCode");
        return this.dailyForecastByZipCode(zipCode, countryCode, this.OWM_25_DAILY_FORECAST_MAX_COUNT);
    }

    @NotNull
    public final DailyForecast dailyForecastByZipCode(int zipCode, @NotNull Country countryCode, byte count) throws APIException {
        Intrinsics.checkParameterIsNotNull((Object)((Object)countryCode), (String)"countryCode");
        DailyForecastAPI api = (DailyForecastAPI)this.retrofit.create(DailyForecastAPI.class);
        Call<DailyForecast> apiCall = api.getDailyForecastByZipCode(String.valueOf(zipCode) + "," + (Object)((Object)countryCode), count);
        Response apiResp = apiCall.execute();
        DailyForecast forecast = (DailyForecast)apiResp.body();
        if (forecast == null) {
            if (!apiResp.isSuccessful()) {
                int n = apiResp.code();
                String string = apiResp.message();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"apiResp.message()");
                throw (Throwable)new APIException(n, string);
            }
            forecast = new DailyForecast(null, null, null, null, null, 31, null);
        }
        return forecast;
    }

    private final Retrofit createRetrofitInstance(Proxy proxy) {
        OkHttpClient.Builder clientBuilder;
        OkHttpClient.Builder builder = clientBuilder = new OkHttpClient.Builder().proxy(proxy);
        Intrinsics.checkExpressionValueIsNotNull((Object)builder, (String)"clientBuilder");
        OkHttpTools.Static.addQueryParameter(builder, "appid", this.apiKey);
        OkHttpTools.Static.addQueryParameter(clientBuilder, "type", this.accuracy.toString());
        OkHttpTools.Static.addQueryParameter(clientBuilder, "lang", this.lang.toString());
        if (Intrinsics.areEqual((Object)((Object)this.unit), (Object)((Object)Unit.STANDARD)) ^ true) {
            OkHttpTools.Static.addQueryParameter(clientBuilder, "units", this.unit.toString());
        }
        OkHttpClient client = clientBuilder.build();
        Gson gson = new GsonBuilder().setLenient().create();
        Retrofit.Builder builder2 = new Retrofit.Builder().client(client).baseUrl(this.OWM_25_BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)gson));
        Retrofit retrofit = builder2.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)retrofit, (String)"builder.build()");
        return retrofit;
    }

    public OWM(@NotNull String apiKey) {
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        this.OWM_25_BASE_URL = "https://api.openweathermap.org/data/2.5/";
        this.OWM_25_DAILY_FORECAST_MAX_COUNT = (byte)16;
        this.setApiKey(apiKey);
        this.accuracy = Accuracy.LIKE;
        this.unit = Unit.STANDARD;
        this.lang = Language.ENGLISH;
        this.proxy = SystemTools.Static.getSystemProxy();
        this.retrofit = this.createRetrofitInstance(this.proxy);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lnet/aksingh/owmjapis/core/OWM$Accuracy;", "", "accuracy", "", "(Ljava/lang/String;ILjava/lang/String;)V", "ACCURATE", "LIKE", "owm-japis"})
    public static final class Accuracy
    extends Enum<Accuracy> {
        public static final /* enum */ Accuracy ACCURATE;
        public static final /* enum */ Accuracy LIKE;
        private static final /* synthetic */ Accuracy[] $VALUES;
        private final String accuracy;

        static {
            Accuracy[] accuracyArray = new Accuracy[2];
            Accuracy[] accuracyArray2 = accuracyArray;
            accuracyArray[0] = ACCURATE = new Accuracy("accurate");
            accuracyArray[1] = LIKE = new Accuracy("like");
            $VALUES = accuracyArray;
        }

        protected Accuracy(String accuracy) {
            Intrinsics.checkParameterIsNotNull((Object)accuracy, (String)"accuracy");
            this.accuracy = accuracy;
        }

        public static Accuracy[] values() {
            return (Accuracy[])$VALUES.clone();
        }

        public static Accuracy valueOf(String string) {
            return Enum.valueOf(Accuracy.class, string);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lnet/aksingh/owmjapis/core/OWM$Unit;", "", "unit", "", "(Ljava/lang/String;ILjava/lang/String;)V", "IMPERIAL", "METRIC", "STANDARD", "owm-japis"})
    public static final class Unit
    extends Enum<Unit> {
        public static final /* enum */ Unit IMPERIAL;
        public static final /* enum */ Unit METRIC;
        public static final /* enum */ Unit STANDARD;
        private static final /* synthetic */ Unit[] $VALUES;
        private final String unit;

        static {
            Unit[] unitArray = new Unit[3];
            Unit[] unitArray2 = unitArray;
            unitArray[0] = IMPERIAL = new Unit("imperial");
            unitArray[1] = METRIC = new Unit("metric");
            unitArray[2] = STANDARD = new Unit("standard");
            $VALUES = unitArray;
        }

        protected Unit(String unit) {
            Intrinsics.checkParameterIsNotNull((Object)unit, (String)"unit");
            this.unit = unit;
        }

        public static Unit[] values() {
            return (Unit[])$VALUES.clone();
        }

        public static Unit valueOf(String string) {
            return Enum.valueOf(Unit.class, string);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b#\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%\u00a8\u0006&"}, d2={"Lnet/aksingh/owmjapis/core/OWM$Language;", "", "lang", "", "(Ljava/lang/String;ILjava/lang/String;)V", "ARABIC", "BULGARIAN", "CATALAN", "CHINESE_SIMPLIFIED", "CHINESE_TRADITIONAL", "CROATIAN", "CZECH", "DUTCH", "ENGLISH", "FINNISH", "FRENCH", "GALICIAN", "GREEK", "GERMAN", "HUNGARIAN", "ITALIAN", "JAPANESE", "KOREAN", "LATVIAN", "LITHUANIAN", "MACEDONIAN", "PERSIAN", "POLISH", "PORTUGUESE", "ROMANIAN", "RUSSIAN", "SLOVAK", "SLOVENIAN", "SPANISH", "SWEDISH", "TURKISH", "UKRAINIAN", "VIETNAMESE", "owm-japis"})
    public static final class Language
    extends Enum<Language> {
        public static final /* enum */ Language ARABIC;
        public static final /* enum */ Language BULGARIAN;
        public static final /* enum */ Language CATALAN;
        public static final /* enum */ Language CHINESE_SIMPLIFIED;
        public static final /* enum */ Language CHINESE_TRADITIONAL;
        public static final /* enum */ Language CROATIAN;
        public static final /* enum */ Language CZECH;
        public static final /* enum */ Language DUTCH;
        public static final /* enum */ Language ENGLISH;
        public static final /* enum */ Language FINNISH;
        public static final /* enum */ Language FRENCH;
        public static final /* enum */ Language GALICIAN;
        public static final /* enum */ Language GREEK;
        public static final /* enum */ Language GERMAN;
        public static final /* enum */ Language HUNGARIAN;
        public static final /* enum */ Language ITALIAN;
        public static final /* enum */ Language JAPANESE;
        public static final /* enum */ Language KOREAN;
        public static final /* enum */ Language LATVIAN;
        public static final /* enum */ Language LITHUANIAN;
        public static final /* enum */ Language MACEDONIAN;
        public static final /* enum */ Language PERSIAN;
        public static final /* enum */ Language POLISH;
        public static final /* enum */ Language PORTUGUESE;
        public static final /* enum */ Language ROMANIAN;
        public static final /* enum */ Language RUSSIAN;
        public static final /* enum */ Language SLOVAK;
        public static final /* enum */ Language SLOVENIAN;
        public static final /* enum */ Language SPANISH;
        public static final /* enum */ Language SWEDISH;
        public static final /* enum */ Language TURKISH;
        public static final /* enum */ Language UKRAINIAN;
        public static final /* enum */ Language VIETNAMESE;
        private static final /* synthetic */ Language[] $VALUES;
        private final String lang;

        static {
            Language[] languageArray = new Language[33];
            Language[] languageArray2 = languageArray;
            languageArray[0] = ARABIC = new Language("ar");
            languageArray[1] = BULGARIAN = new Language("bg");
            languageArray[2] = CATALAN = new Language("ca");
            languageArray[3] = CHINESE_SIMPLIFIED = new Language("zh_cn");
            languageArray[4] = CHINESE_TRADITIONAL = new Language("zh_tw");
            languageArray[5] = CROATIAN = new Language("hr");
            languageArray[6] = CZECH = new Language("cz");
            languageArray[7] = DUTCH = new Language("nl");
            languageArray[8] = ENGLISH = new Language("en");
            languageArray[9] = FINNISH = new Language("fi");
            languageArray[10] = FRENCH = new Language("fr");
            languageArray[11] = GALICIAN = new Language("gl");
            languageArray[12] = GREEK = new Language("el");
            languageArray[13] = GERMAN = new Language("de");
            languageArray[14] = HUNGARIAN = new Language("hu");
            languageArray[15] = ITALIAN = new Language("it");
            languageArray[16] = JAPANESE = new Language("ja");
            languageArray[17] = KOREAN = new Language("kr");
            languageArray[18] = LATVIAN = new Language("la");
            languageArray[19] = LITHUANIAN = new Language("lt");
            languageArray[20] = MACEDONIAN = new Language("mk");
            languageArray[21] = PERSIAN = new Language("fa");
            languageArray[22] = POLISH = new Language("pl");
            languageArray[23] = PORTUGUESE = new Language("pt");
            languageArray[24] = ROMANIAN = new Language("ro");
            languageArray[25] = RUSSIAN = new Language("ru");
            languageArray[26] = SLOVAK = new Language("sk");
            languageArray[27] = SLOVENIAN = new Language("sl");
            languageArray[28] = SPANISH = new Language("es");
            languageArray[29] = SWEDISH = new Language("se");
            languageArray[30] = TURKISH = new Language("tr");
            languageArray[31] = UKRAINIAN = new Language("ua");
            languageArray[32] = VIETNAMESE = new Language("vi");
            $VALUES = languageArray;
        }

        protected Language(String lang) {
            Intrinsics.checkParameterIsNotNull((Object)lang, (String)"lang");
            this.lang = lang;
        }

        public static Language[] values() {
            return (Language[])$VALUES.clone();
        }

        public static Language valueOf(String string) {
            return Enum.valueOf(Language.class, string);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0013\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0003\b\u00fb\u0001\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001fj\u0002\b j\u0002\b!j\u0002\b\"j\u0002\b#j\u0002\b$j\u0002\b%j\u0002\b&j\u0002\b'j\u0002\b(j\u0002\b)j\u0002\b*j\u0002\b+j\u0002\b,j\u0002\b-j\u0002\b.j\u0002\b/j\u0002\b0j\u0002\b1j\u0002\b2j\u0002\b3j\u0002\b4j\u0002\b5j\u0002\b6j\u0002\b7j\u0002\b8j\u0002\b9j\u0002\b:j\u0002\b;j\u0002\b<j\u0002\b=j\u0002\b>j\u0002\b?j\u0002\b@j\u0002\bAj\u0002\bBj\u0002\bCj\u0002\bDj\u0002\bEj\u0002\bFj\u0002\bGj\u0002\bHj\u0002\bIj\u0002\bJj\u0002\bKj\u0002\bLj\u0002\bMj\u0002\bNj\u0002\bOj\u0002\bPj\u0002\bQj\u0002\bRj\u0002\bSj\u0002\bTj\u0002\bUj\u0002\bVj\u0002\bWj\u0002\bXj\u0002\bYj\u0002\bZj\u0002\b[j\u0002\b\\j\u0002\b]j\u0002\b^j\u0002\b_j\u0002\b`j\u0002\baj\u0002\bbj\u0002\bcj\u0002\bdj\u0002\bej\u0002\bfj\u0002\bgj\u0002\bhj\u0002\bij\u0002\bjj\u0002\bkj\u0002\blj\u0002\bmj\u0002\bnj\u0002\boj\u0002\bpj\u0002\bqj\u0002\brj\u0002\bsj\u0002\btj\u0002\buj\u0002\bvj\u0002\bwj\u0002\bxj\u0002\byj\u0002\bzj\u0002\b{j\u0002\b|j\u0002\b}j\u0002\b~j\u0002\b\u007fj\u0003\b\u0080\u0001j\u0003\b\u0081\u0001j\u0003\b\u0082\u0001j\u0003\b\u0083\u0001j\u0003\b\u0084\u0001j\u0003\b\u0085\u0001j\u0003\b\u0086\u0001j\u0003\b\u0087\u0001j\u0003\b\u0088\u0001j\u0003\b\u0089\u0001j\u0003\b\u008a\u0001j\u0003\b\u008b\u0001j\u0003\b\u008c\u0001j\u0003\b\u008d\u0001j\u0003\b\u008e\u0001j\u0003\b\u008f\u0001j\u0003\b\u0090\u0001j\u0003\b\u0091\u0001j\u0003\b\u0092\u0001j\u0003\b\u0093\u0001j\u0003\b\u0094\u0001j\u0003\b\u0095\u0001j\u0003\b\u0096\u0001j\u0003\b\u0097\u0001j\u0003\b\u0098\u0001j\u0003\b\u0099\u0001j\u0003\b\u009a\u0001j\u0003\b\u009b\u0001j\u0003\b\u009c\u0001j\u0003\b\u009d\u0001j\u0003\b\u009e\u0001j\u0003\b\u009f\u0001j\u0003\b\u00a0\u0001j\u0003\b\u00a1\u0001j\u0003\b\u00a2\u0001j\u0003\b\u00a3\u0001j\u0003\b\u00a4\u0001j\u0003\b\u00a5\u0001j\u0003\b\u00a6\u0001j\u0003\b\u00a7\u0001j\u0003\b\u00a8\u0001j\u0003\b\u00a9\u0001j\u0003\b\u00aa\u0001j\u0003\b\u00ab\u0001j\u0003\b\u00ac\u0001j\u0003\b\u00ad\u0001j\u0003\b\u00ae\u0001j\u0003\b\u00af\u0001j\u0003\b\u00b0\u0001j\u0003\b\u00b1\u0001j\u0003\b\u00b2\u0001j\u0003\b\u00b3\u0001j\u0003\b\u00b4\u0001j\u0003\b\u00b5\u0001j\u0003\b\u00b6\u0001j\u0003\b\u00b7\u0001j\u0003\b\u00b8\u0001j\u0003\b\u00b9\u0001j\u0003\b\u00ba\u0001j\u0003\b\u00bb\u0001j\u0003\b\u00bc\u0001j\u0003\b\u00bd\u0001j\u0003\b\u00be\u0001j\u0003\b\u00bf\u0001j\u0003\b\u00c0\u0001j\u0003\b\u00c1\u0001j\u0003\b\u00c2\u0001j\u0003\b\u00c3\u0001j\u0003\b\u00c4\u0001j\u0003\b\u00c5\u0001j\u0003\b\u00c6\u0001j\u0003\b\u00c7\u0001j\u0003\b\u00c8\u0001j\u0003\b\u00c9\u0001j\u0003\b\u00ca\u0001j\u0003\b\u00cb\u0001j\u0003\b\u00cc\u0001j\u0003\b\u00cd\u0001j\u0003\b\u00ce\u0001j\u0003\b\u00cf\u0001j\u0003\b\u00d0\u0001j\u0003\b\u00d1\u0001j\u0003\b\u00d2\u0001j\u0003\b\u00d3\u0001j\u0003\b\u00d4\u0001j\u0003\b\u00d5\u0001j\u0003\b\u00d6\u0001j\u0003\b\u00d7\u0001j\u0003\b\u00d8\u0001j\u0003\b\u00d9\u0001j\u0003\b\u00da\u0001j\u0003\b\u00db\u0001j\u0003\b\u00dc\u0001j\u0003\b\u00dd\u0001j\u0003\b\u00de\u0001j\u0003\b\u00df\u0001j\u0003\b\u00e0\u0001j\u0003\b\u00e1\u0001j\u0003\b\u00e2\u0001j\u0003\b\u00e3\u0001j\u0003\b\u00e4\u0001j\u0003\b\u00e5\u0001j\u0003\b\u00e6\u0001j\u0003\b\u00e7\u0001j\u0003\b\u00e8\u0001j\u0003\b\u00e9\u0001j\u0003\b\u00ea\u0001j\u0003\b\u00eb\u0001j\u0003\b\u00ec\u0001j\u0003\b\u00ed\u0001j\u0003\b\u00ee\u0001j\u0003\b\u00ef\u0001j\u0003\b\u00f0\u0001j\u0003\b\u00f1\u0001j\u0003\b\u00f2\u0001j\u0003\b\u00f3\u0001j\u0003\b\u00f4\u0001j\u0003\b\u00f5\u0001j\u0003\b\u00f6\u0001j\u0003\b\u00f7\u0001j\u0003\b\u00f8\u0001j\u0003\b\u00f9\u0001j\u0003\b\u00fa\u0001j\u0003\b\u00fb\u0001j\u0003\b\u00fc\u0001j\u0003\b\u00fd\u0001\u00a8\u0006\u00fe\u0001"}, d2={"Lnet/aksingh/owmjapis/core/OWM$Country;", "", "country", "", "(Ljava/lang/String;ILjava/lang/String;)V", "AFGHANISTAN", "ALAND_ISLANDS", "ALBANIA", "ALGERIA", "AMERICAN_SAMOA", "ANDORRA", "ANGOLA", "ANGUILLA", "ANTARCTICA", "ANTIGUA_AND_BARBUDA", "ARGENTINA", "ARMENIA", "ARUBA", "AUSTRALIA", "AUSTRIA", "AZERBAIJAN", "BAHAMAS", "BAHRAIN", "BANGLADESH", "BARBADOS", "BELARUS", "BELGIUM", "BELIZE", "BENIN", "BERMUDA", "BHUTAN", "BOLIVIA", "BOSNIA_AND_HERZEGOVINA", "BOTSWANA", "BOUVET_ISLAND", "BRAZIL", "BRITISH_INDIAN_OCEAN_TERRITORY", "BRITISH_VIRGIN_ISLANDS", "BRUNEI", "BULGARIA", "BURKINA_FASO", "BURUNDI", "CAMBODIA", "CAMEROON", "CANADA", "CAPE_VERDE", "CARIBBEAN_NETHERLANDS", "CAYMAN_ISLANDS", "CENTRAL_AFRICAN_REPUBLIC", "CHAD", "CHILE", "CHINA", "CHRISTMAS_ISLAND", "COCOS_KEELING_ISLANDS", "COLOMBIA", "COMOROS", "CONGO_BRAZZAVILLE", "CONGO_KINSHASA", "COOK_ISLANDS", "COSTA_RICA", "CROATIA", "CUBA", "CURACAO", "CYPRUS", "CZECH_REPUBLIC", "COTE_D_IVOIRE", "DENMARK", "DJIBOUTI", "DOMINICA", "DOMINICAN_REPUBLIC", "ECUADOR", "EGYPT", "EL_SALVADOR", "EQUATORIAL_GUINEA", "ERITREA", "ESTONIA", "ETHIOPIA", "FALKLAND_ISLANDS", "FAROE_ISLANDS", "FIJI", "FINLAND", "FRANCE", "FRENCH_GUIANA", "FRENCH_POLYNESIA", "FRENCH_SOUTHERN_TERRITORIES", "GABON", "GAMBIA", "GEORGIA", "GERMANY", "GHANA", "GIBRALTAR", "GREECE", "GREENLAND", "GRENADA", "GUADELOUPE", "GUAM", "GUATEMALA", "GUERNSEY", "GUINEA", "GUINEA_BISSAU", "GUYANA", "HAITI", "HEARD_AND_MCDONALD_ISLANDS", "HONDURAS", "HONG_KONG_SAR_CHINA", "HUNGARY", "ICELAND", "INDIA", "INDONESIA", "IRAN", "IRAQ", "IRELAND", "ISLE_OF_MAN", "ISRAEL", "ITALY", "JAMAICA", "JAPAN", "JERSEY", "JORDAN", "KAZAKHSTAN", "KENYA", "KIRIBATI", "KUWAIT", "KYRGYZSTAN", "LAOS", "LATVIA", "LEBANON", "LESOTHO", "LIBERIA", "LIBYA", "LIECHTENSTEIN", "LITHUANIA", "LUXEMBOURG", "MACAU_SAR_CHINA", "MACEDONIA", "MADAGASCAR", "MALAWI", "MALAYSIA", "MALDIVES", "MALI", "MALTA", "MARSHALL_ISLANDS", "MARTINIQUE", "MAURITANIA", "MAURITIUS", "MAYOTTE", "MEXICO", "MICRONESIA", "MOLDOVA", "MONACO", "MONGOLIA", "MONTENEGRO", "MONTSERRAT", "MOROCCO", "MOZAMBIQUE", "MYANMAR_BURMA", "NAMIBIA", "NAURU", "NEPAL", "NETHERLANDS", "NEW_CALEDONIA", "NEW_ZEALAND", "NICARAGUA", "NIGER", "NIGERIA", "NIUE", "NORFOLK_ISLAND", "NORTH_KOREA", "NORTHERN_MARIANA_ISLANDS", "NORWAY", "OMAN", "PAKISTAN", "PALAU", "PALESTINIAN_TERRITORIES", "PANAMA", "PAPUA_NEW_GUINEA", "PARAGUAY", "PERU", "PHILIPPINES", "PITCAIRN_ISLANDS", "POLAND", "PORTUGAL", "PUERTO_RICO", "QATAR", "ROMANIA", "RUSSIA", "RWANDA", "REUNION", "SAMOA", "SAN_MARINO", "SAUDI_ARABIA", "SENEGAL", "SERBIA", "SEYCHELLES", "SIERRA_LEONE", "SINGAPORE", "SINT_MAARTEN", "SLOVAKIA", "SLOVENIA", "SOLOMON_ISLANDS", "SOMALIA", "SOUTH_AFRICA", "SOUTH_GEORGIA_AND_SOUTH_SANDWICH_ISLANDS", "SOUTH_KOREA", "SOUTH_SUDAN", "SPAIN", "SRI_LANKA", "ST_BARTHELEMY", "ST_HELENA", "ST_KITTS_AND_NEVIS", "ST_LUCIA", "ST_MARTIN", "ST_PIERRE_AND_MIQUELON", "ST_VINCENT_AND_GRENADINES", "SUDAN", "SURINAME", "SVALBARD_AND_JAN_MAYEN", "SWAZILAND", "SWEDEN", "SWITZERLAND", "SYRIA", "SAO_TOME_AND_PRINCIPE", "TAIWAN", "TAJIKISTAN", "TANZANIA", "THAILAND", "TIMOR_LESTE", "TOGO", "TOKELAU", "TONGA", "TRINIDAD_AND_TOBAGO", "TUNISIA", "TURKEY", "TURKMENISTAN", "TURKS_AND_CAICOS_ISLANDS", "TUVALU", "US_OUTLYING_ISLANDS", "US_VIRGIN_ISLANDS", "UGANDA", "UKRAINE", "UNITED_ARAB_EMIRATES", "UNITED_KINGDOM", "UNITED_STATES", "URUGUAY", "UZBEKISTAN", "VANUATU", "VATICAN_CITY", "VENEZUELA", "VIETNAM", "WALLIS_AND_FUTUNA", "WESTERN_SAHARA", "YEMEN", "ZAMBIA", "ZIMBABWE", "owm-japis"})
    public static final class Country
    extends Enum<Country> {
        public static final /* enum */ Country AFGHANISTAN;
        public static final /* enum */ Country ALAND_ISLANDS;
        public static final /* enum */ Country ALBANIA;
        public static final /* enum */ Country ALGERIA;
        public static final /* enum */ Country AMERICAN_SAMOA;
        public static final /* enum */ Country ANDORRA;
        public static final /* enum */ Country ANGOLA;
        public static final /* enum */ Country ANGUILLA;
        public static final /* enum */ Country ANTARCTICA;
        public static final /* enum */ Country ANTIGUA_AND_BARBUDA;
        public static final /* enum */ Country ARGENTINA;
        public static final /* enum */ Country ARMENIA;
        public static final /* enum */ Country ARUBA;
        public static final /* enum */ Country AUSTRALIA;
        public static final /* enum */ Country AUSTRIA;
        public static final /* enum */ Country AZERBAIJAN;
        public static final /* enum */ Country BAHAMAS;
        public static final /* enum */ Country BAHRAIN;
        public static final /* enum */ Country BANGLADESH;
        public static final /* enum */ Country BARBADOS;
        public static final /* enum */ Country BELARUS;
        public static final /* enum */ Country BELGIUM;
        public static final /* enum */ Country BELIZE;
        public static final /* enum */ Country BENIN;
        public static final /* enum */ Country BERMUDA;
        public static final /* enum */ Country BHUTAN;
        public static final /* enum */ Country BOLIVIA;
        public static final /* enum */ Country BOSNIA_AND_HERZEGOVINA;
        public static final /* enum */ Country BOTSWANA;
        public static final /* enum */ Country BOUVET_ISLAND;
        public static final /* enum */ Country BRAZIL;
        public static final /* enum */ Country BRITISH_INDIAN_OCEAN_TERRITORY;
        public static final /* enum */ Country BRITISH_VIRGIN_ISLANDS;
        public static final /* enum */ Country BRUNEI;
        public static final /* enum */ Country BULGARIA;
        public static final /* enum */ Country BURKINA_FASO;
        public static final /* enum */ Country BURUNDI;
        public static final /* enum */ Country CAMBODIA;
        public static final /* enum */ Country CAMEROON;
        public static final /* enum */ Country CANADA;
        public static final /* enum */ Country CAPE_VERDE;
        public static final /* enum */ Country CARIBBEAN_NETHERLANDS;
        public static final /* enum */ Country CAYMAN_ISLANDS;
        public static final /* enum */ Country CENTRAL_AFRICAN_REPUBLIC;
        public static final /* enum */ Country CHAD;
        public static final /* enum */ Country CHILE;
        public static final /* enum */ Country CHINA;
        public static final /* enum */ Country CHRISTMAS_ISLAND;
        public static final /* enum */ Country COCOS_KEELING_ISLANDS;
        public static final /* enum */ Country COLOMBIA;
        public static final /* enum */ Country COMOROS;
        public static final /* enum */ Country CONGO_BRAZZAVILLE;
        public static final /* enum */ Country CONGO_KINSHASA;
        public static final /* enum */ Country COOK_ISLANDS;
        public static final /* enum */ Country COSTA_RICA;
        public static final /* enum */ Country CROATIA;
        public static final /* enum */ Country CUBA;
        public static final /* enum */ Country CURACAO;
        public static final /* enum */ Country CYPRUS;
        public static final /* enum */ Country CZECH_REPUBLIC;
        public static final /* enum */ Country COTE_D_IVOIRE;
        public static final /* enum */ Country DENMARK;
        public static final /* enum */ Country DJIBOUTI;
        public static final /* enum */ Country DOMINICA;
        public static final /* enum */ Country DOMINICAN_REPUBLIC;
        public static final /* enum */ Country ECUADOR;
        public static final /* enum */ Country EGYPT;
        public static final /* enum */ Country EL_SALVADOR;
        public static final /* enum */ Country EQUATORIAL_GUINEA;
        public static final /* enum */ Country ERITREA;
        public static final /* enum */ Country ESTONIA;
        public static final /* enum */ Country ETHIOPIA;
        public static final /* enum */ Country FALKLAND_ISLANDS;
        public static final /* enum */ Country FAROE_ISLANDS;
        public static final /* enum */ Country FIJI;
        public static final /* enum */ Country FINLAND;
        public static final /* enum */ Country FRANCE;
        public static final /* enum */ Country FRENCH_GUIANA;
        public static final /* enum */ Country FRENCH_POLYNESIA;
        public static final /* enum */ Country FRENCH_SOUTHERN_TERRITORIES;
        public static final /* enum */ Country GABON;
        public static final /* enum */ Country GAMBIA;
        public static final /* enum */ Country GEORGIA;
        public static final /* enum */ Country GERMANY;
        public static final /* enum */ Country GHANA;
        public static final /* enum */ Country GIBRALTAR;
        public static final /* enum */ Country GREECE;
        public static final /* enum */ Country GREENLAND;
        public static final /* enum */ Country GRENADA;
        public static final /* enum */ Country GUADELOUPE;
        public static final /* enum */ Country GUAM;
        public static final /* enum */ Country GUATEMALA;
        public static final /* enum */ Country GUERNSEY;
        public static final /* enum */ Country GUINEA;
        public static final /* enum */ Country GUINEA_BISSAU;
        public static final /* enum */ Country GUYANA;
        public static final /* enum */ Country HAITI;
        public static final /* enum */ Country HEARD_AND_MCDONALD_ISLANDS;
        public static final /* enum */ Country HONDURAS;
        public static final /* enum */ Country HONG_KONG_SAR_CHINA;
        public static final /* enum */ Country HUNGARY;
        public static final /* enum */ Country ICELAND;
        public static final /* enum */ Country INDIA;
        public static final /* enum */ Country INDONESIA;
        public static final /* enum */ Country IRAN;
        public static final /* enum */ Country IRAQ;
        public static final /* enum */ Country IRELAND;
        public static final /* enum */ Country ISLE_OF_MAN;
        public static final /* enum */ Country ISRAEL;
        public static final /* enum */ Country ITALY;
        public static final /* enum */ Country JAMAICA;
        public static final /* enum */ Country JAPAN;
        public static final /* enum */ Country JERSEY;
        public static final /* enum */ Country JORDAN;
        public static final /* enum */ Country KAZAKHSTAN;
        public static final /* enum */ Country KENYA;
        public static final /* enum */ Country KIRIBATI;
        public static final /* enum */ Country KUWAIT;
        public static final /* enum */ Country KYRGYZSTAN;
        public static final /* enum */ Country LAOS;
        public static final /* enum */ Country LATVIA;
        public static final /* enum */ Country LEBANON;
        public static final /* enum */ Country LESOTHO;
        public static final /* enum */ Country LIBERIA;
        public static final /* enum */ Country LIBYA;
        public static final /* enum */ Country LIECHTENSTEIN;
        public static final /* enum */ Country LITHUANIA;
        public static final /* enum */ Country LUXEMBOURG;
        public static final /* enum */ Country MACAU_SAR_CHINA;
        public static final /* enum */ Country MACEDONIA;
        public static final /* enum */ Country MADAGASCAR;
        public static final /* enum */ Country MALAWI;
        public static final /* enum */ Country MALAYSIA;
        public static final /* enum */ Country MALDIVES;
        public static final /* enum */ Country MALI;
        public static final /* enum */ Country MALTA;
        public static final /* enum */ Country MARSHALL_ISLANDS;
        public static final /* enum */ Country MARTINIQUE;
        public static final /* enum */ Country MAURITANIA;
        public static final /* enum */ Country MAURITIUS;
        public static final /* enum */ Country MAYOTTE;
        public static final /* enum */ Country MEXICO;
        public static final /* enum */ Country MICRONESIA;
        public static final /* enum */ Country MOLDOVA;
        public static final /* enum */ Country MONACO;
        public static final /* enum */ Country MONGOLIA;
        public static final /* enum */ Country MONTENEGRO;
        public static final /* enum */ Country MONTSERRAT;
        public static final /* enum */ Country MOROCCO;
        public static final /* enum */ Country MOZAMBIQUE;
        public static final /* enum */ Country MYANMAR_BURMA;
        public static final /* enum */ Country NAMIBIA;
        public static final /* enum */ Country NAURU;
        public static final /* enum */ Country NEPAL;
        public static final /* enum */ Country NETHERLANDS;
        public static final /* enum */ Country NEW_CALEDONIA;
        public static final /* enum */ Country NEW_ZEALAND;
        public static final /* enum */ Country NICARAGUA;
        public static final /* enum */ Country NIGER;
        public static final /* enum */ Country NIGERIA;
        public static final /* enum */ Country NIUE;
        public static final /* enum */ Country NORFOLK_ISLAND;
        public static final /* enum */ Country NORTH_KOREA;
        public static final /* enum */ Country NORTHERN_MARIANA_ISLANDS;
        public static final /* enum */ Country NORWAY;
        public static final /* enum */ Country OMAN;
        public static final /* enum */ Country PAKISTAN;
        public static final /* enum */ Country PALAU;
        public static final /* enum */ Country PALESTINIAN_TERRITORIES;
        public static final /* enum */ Country PANAMA;
        public static final /* enum */ Country PAPUA_NEW_GUINEA;
        public static final /* enum */ Country PARAGUAY;
        public static final /* enum */ Country PERU;
        public static final /* enum */ Country PHILIPPINES;
        public static final /* enum */ Country PITCAIRN_ISLANDS;
        public static final /* enum */ Country POLAND;
        public static final /* enum */ Country PORTUGAL;
        public static final /* enum */ Country PUERTO_RICO;
        public static final /* enum */ Country QATAR;
        public static final /* enum */ Country ROMANIA;
        public static final /* enum */ Country RUSSIA;
        public static final /* enum */ Country RWANDA;
        public static final /* enum */ Country REUNION;
        public static final /* enum */ Country SAMOA;
        public static final /* enum */ Country SAN_MARINO;
        public static final /* enum */ Country SAUDI_ARABIA;
        public static final /* enum */ Country SENEGAL;
        public static final /* enum */ Country SERBIA;
        public static final /* enum */ Country SEYCHELLES;
        public static final /* enum */ Country SIERRA_LEONE;
        public static final /* enum */ Country SINGAPORE;
        public static final /* enum */ Country SINT_MAARTEN;
        public static final /* enum */ Country SLOVAKIA;
        public static final /* enum */ Country SLOVENIA;
        public static final /* enum */ Country SOLOMON_ISLANDS;
        public static final /* enum */ Country SOMALIA;
        public static final /* enum */ Country SOUTH_AFRICA;
        public static final /* enum */ Country SOUTH_GEORGIA_AND_SOUTH_SANDWICH_ISLANDS;
        public static final /* enum */ Country SOUTH_KOREA;
        public static final /* enum */ Country SOUTH_SUDAN;
        public static final /* enum */ Country SPAIN;
        public static final /* enum */ Country SRI_LANKA;
        public static final /* enum */ Country ST_BARTHELEMY;
        public static final /* enum */ Country ST_HELENA;
        public static final /* enum */ Country ST_KITTS_AND_NEVIS;
        public static final /* enum */ Country ST_LUCIA;
        public static final /* enum */ Country ST_MARTIN;
        public static final /* enum */ Country ST_PIERRE_AND_MIQUELON;
        public static final /* enum */ Country ST_VINCENT_AND_GRENADINES;
        public static final /* enum */ Country SUDAN;
        public static final /* enum */ Country SURINAME;
        public static final /* enum */ Country SVALBARD_AND_JAN_MAYEN;
        public static final /* enum */ Country SWAZILAND;
        public static final /* enum */ Country SWEDEN;
        public static final /* enum */ Country SWITZERLAND;
        public static final /* enum */ Country SYRIA;
        public static final /* enum */ Country SAO_TOME_AND_PRINCIPE;
        public static final /* enum */ Country TAIWAN;
        public static final /* enum */ Country TAJIKISTAN;
        public static final /* enum */ Country TANZANIA;
        public static final /* enum */ Country THAILAND;
        public static final /* enum */ Country TIMOR_LESTE;
        public static final /* enum */ Country TOGO;
        public static final /* enum */ Country TOKELAU;
        public static final /* enum */ Country TONGA;
        public static final /* enum */ Country TRINIDAD_AND_TOBAGO;
        public static final /* enum */ Country TUNISIA;
        public static final /* enum */ Country TURKEY;
        public static final /* enum */ Country TURKMENISTAN;
        public static final /* enum */ Country TURKS_AND_CAICOS_ISLANDS;
        public static final /* enum */ Country TUVALU;
        public static final /* enum */ Country US_OUTLYING_ISLANDS;
        public static final /* enum */ Country US_VIRGIN_ISLANDS;
        public static final /* enum */ Country UGANDA;
        public static final /* enum */ Country UKRAINE;
        public static final /* enum */ Country UNITED_ARAB_EMIRATES;
        public static final /* enum */ Country UNITED_KINGDOM;
        public static final /* enum */ Country UNITED_STATES;
        public static final /* enum */ Country URUGUAY;
        public static final /* enum */ Country UZBEKISTAN;
        public static final /* enum */ Country VANUATU;
        public static final /* enum */ Country VATICAN_CITY;
        public static final /* enum */ Country VENEZUELA;
        public static final /* enum */ Country VIETNAM;
        public static final /* enum */ Country WALLIS_AND_FUTUNA;
        public static final /* enum */ Country WESTERN_SAHARA;
        public static final /* enum */ Country YEMEN;
        public static final /* enum */ Country ZAMBIA;
        public static final /* enum */ Country ZIMBABWE;
        private static final /* synthetic */ Country[] $VALUES;
        private final String country;

        static {
            Country[] countryArray = new Country[249];
            Country[] countryArray2 = countryArray;
            countryArray[0] = AFGHANISTAN = new Country("AF");
            countryArray[1] = ALAND_ISLANDS = new Country("AX");
            countryArray[2] = ALBANIA = new Country("AL");
            countryArray[3] = ALGERIA = new Country("DZ");
            countryArray[4] = AMERICAN_SAMOA = new Country("AS");
            countryArray[5] = ANDORRA = new Country("AD");
            countryArray[6] = ANGOLA = new Country("AO");
            countryArray[7] = ANGUILLA = new Country("AI");
            countryArray[8] = ANTARCTICA = new Country("AQ");
            countryArray[9] = ANTIGUA_AND_BARBUDA = new Country("AG");
            countryArray[10] = ARGENTINA = new Country("AR");
            countryArray[11] = ARMENIA = new Country("AM");
            countryArray[12] = ARUBA = new Country("AW");
            countryArray[13] = AUSTRALIA = new Country("AU");
            countryArray[14] = AUSTRIA = new Country("AT");
            countryArray[15] = AZERBAIJAN = new Country("AZ");
            countryArray[16] = BAHAMAS = new Country("BS");
            countryArray[17] = BAHRAIN = new Country("BH");
            countryArray[18] = BANGLADESH = new Country("BD");
            countryArray[19] = BARBADOS = new Country("BB");
            countryArray[20] = BELARUS = new Country("BY");
            countryArray[21] = BELGIUM = new Country("BE");
            countryArray[22] = BELIZE = new Country("BZ");
            countryArray[23] = BENIN = new Country("BJ");
            countryArray[24] = BERMUDA = new Country("BM");
            countryArray[25] = BHUTAN = new Country("BT");
            countryArray[26] = BOLIVIA = new Country("BO");
            countryArray[27] = BOSNIA_AND_HERZEGOVINA = new Country("BA");
            countryArray[28] = BOTSWANA = new Country("BW");
            countryArray[29] = BOUVET_ISLAND = new Country("BV");
            countryArray[30] = BRAZIL = new Country("BR");
            countryArray[31] = BRITISH_INDIAN_OCEAN_TERRITORY = new Country("IO");
            countryArray[32] = BRITISH_VIRGIN_ISLANDS = new Country("VG");
            countryArray[33] = BRUNEI = new Country("BN");
            countryArray[34] = BULGARIA = new Country("BG");
            countryArray[35] = BURKINA_FASO = new Country("BF");
            countryArray[36] = BURUNDI = new Country("BI");
            countryArray[37] = CAMBODIA = new Country("KH");
            countryArray[38] = CAMEROON = new Country("CM");
            countryArray[39] = CANADA = new Country("CA");
            countryArray[40] = CAPE_VERDE = new Country("CV");
            countryArray[41] = CARIBBEAN_NETHERLANDS = new Country("BQ");
            countryArray[42] = CAYMAN_ISLANDS = new Country("KY");
            countryArray[43] = CENTRAL_AFRICAN_REPUBLIC = new Country("CF");
            countryArray[44] = CHAD = new Country("TD");
            countryArray[45] = CHILE = new Country("CL");
            countryArray[46] = CHINA = new Country("CN");
            countryArray[47] = CHRISTMAS_ISLAND = new Country("CX");
            countryArray[48] = COCOS_KEELING_ISLANDS = new Country("CC");
            countryArray[49] = COLOMBIA = new Country("CO");
            countryArray[50] = COMOROS = new Country("KM");
            countryArray[51] = CONGO_BRAZZAVILLE = new Country("CG");
            countryArray[52] = CONGO_KINSHASA = new Country("CD");
            countryArray[53] = COOK_ISLANDS = new Country("CK");
            countryArray[54] = COSTA_RICA = new Country("CR");
            countryArray[55] = CROATIA = new Country("HR");
            countryArray[56] = CUBA = new Country("CU");
            countryArray[57] = CURACAO = new Country("CW");
            countryArray[58] = CYPRUS = new Country("CY");
            countryArray[59] = CZECH_REPUBLIC = new Country("CZ");
            countryArray[60] = COTE_D_IVOIRE = new Country("CI");
            countryArray[61] = DENMARK = new Country("DK");
            countryArray[62] = DJIBOUTI = new Country("DJ");
            countryArray[63] = DOMINICA = new Country("DM");
            countryArray[64] = DOMINICAN_REPUBLIC = new Country("DO");
            countryArray[65] = ECUADOR = new Country("EC");
            countryArray[66] = EGYPT = new Country("EG");
            countryArray[67] = EL_SALVADOR = new Country("SV");
            countryArray[68] = EQUATORIAL_GUINEA = new Country("GQ");
            countryArray[69] = ERITREA = new Country("ER");
            countryArray[70] = ESTONIA = new Country("EE");
            countryArray[71] = ETHIOPIA = new Country("ET");
            countryArray[72] = FALKLAND_ISLANDS = new Country("FK");
            countryArray[73] = FAROE_ISLANDS = new Country("FO");
            countryArray[74] = FIJI = new Country("FJ");
            countryArray[75] = FINLAND = new Country("FI");
            countryArray[76] = FRANCE = new Country("FR");
            countryArray[77] = FRENCH_GUIANA = new Country("GF");
            countryArray[78] = FRENCH_POLYNESIA = new Country("PF");
            countryArray[79] = FRENCH_SOUTHERN_TERRITORIES = new Country("TF");
            countryArray[80] = GABON = new Country("GA");
            countryArray[81] = GAMBIA = new Country("GM");
            countryArray[82] = GEORGIA = new Country("GE");
            countryArray[83] = GERMANY = new Country("DE");
            countryArray[84] = GHANA = new Country("GH");
            countryArray[85] = GIBRALTAR = new Country("GI");
            countryArray[86] = GREECE = new Country("GR");
            countryArray[87] = GREENLAND = new Country("GL");
            countryArray[88] = GRENADA = new Country("GD");
            countryArray[89] = GUADELOUPE = new Country("GP");
            countryArray[90] = GUAM = new Country("GU");
            countryArray[91] = GUATEMALA = new Country("GT");
            countryArray[92] = GUERNSEY = new Country("GG");
            countryArray[93] = GUINEA = new Country("GN");
            countryArray[94] = GUINEA_BISSAU = new Country("GW");
            countryArray[95] = GUYANA = new Country("GY");
            countryArray[96] = HAITI = new Country("HT");
            countryArray[97] = HEARD_AND_MCDONALD_ISLANDS = new Country("HM");
            countryArray[98] = HONDURAS = new Country("HN");
            countryArray[99] = HONG_KONG_SAR_CHINA = new Country("HK");
            countryArray[100] = HUNGARY = new Country("HU");
            countryArray[101] = ICELAND = new Country("IS");
            countryArray[102] = INDIA = new Country("IN");
            countryArray[103] = INDONESIA = new Country("ID");
            countryArray[104] = IRAN = new Country("IR");
            countryArray[105] = IRAQ = new Country("IQ");
            countryArray[106] = IRELAND = new Country("IE");
            countryArray[107] = ISLE_OF_MAN = new Country("IM");
            countryArray[108] = ISRAEL = new Country("IL");
            countryArray[109] = ITALY = new Country("IT");
            countryArray[110] = JAMAICA = new Country("JM");
            countryArray[111] = JAPAN = new Country("JP");
            countryArray[112] = JERSEY = new Country("JE");
            countryArray[113] = JORDAN = new Country("JO");
            countryArray[114] = KAZAKHSTAN = new Country("KZ");
            countryArray[115] = KENYA = new Country("KE");
            countryArray[116] = KIRIBATI = new Country("KI");
            countryArray[117] = KUWAIT = new Country("KW");
            countryArray[118] = KYRGYZSTAN = new Country("KG");
            countryArray[119] = LAOS = new Country("LA");
            countryArray[120] = LATVIA = new Country("LV");
            countryArray[121] = LEBANON = new Country("LB");
            countryArray[122] = LESOTHO = new Country("LS");
            countryArray[123] = LIBERIA = new Country("LR");
            countryArray[124] = LIBYA = new Country("LY");
            countryArray[125] = LIECHTENSTEIN = new Country("LI");
            countryArray[126] = LITHUANIA = new Country("LT");
            countryArray[127] = LUXEMBOURG = new Country("LU");
            countryArray[128] = MACAU_SAR_CHINA = new Country("MO");
            countryArray[129] = MACEDONIA = new Country("MK");
            countryArray[130] = MADAGASCAR = new Country("MG");
            countryArray[131] = MALAWI = new Country("MW");
            countryArray[132] = MALAYSIA = new Country("MY");
            countryArray[133] = MALDIVES = new Country("MV");
            countryArray[134] = MALI = new Country("ML");
            countryArray[135] = MALTA = new Country("MT");
            countryArray[136] = MARSHALL_ISLANDS = new Country("MH");
            countryArray[137] = MARTINIQUE = new Country("MQ");
            countryArray[138] = MAURITANIA = new Country("MR");
            countryArray[139] = MAURITIUS = new Country("MU");
            countryArray[140] = MAYOTTE = new Country("YT");
            countryArray[141] = MEXICO = new Country("MX");
            countryArray[142] = MICRONESIA = new Country("FM");
            countryArray[143] = MOLDOVA = new Country("MD");
            countryArray[144] = MONACO = new Country("MC");
            countryArray[145] = MONGOLIA = new Country("MN");
            countryArray[146] = MONTENEGRO = new Country("ME");
            countryArray[147] = MONTSERRAT = new Country("MS");
            countryArray[148] = MOROCCO = new Country("MA");
            countryArray[149] = MOZAMBIQUE = new Country("MZ");
            countryArray[150] = MYANMAR_BURMA = new Country("MM");
            countryArray[151] = NAMIBIA = new Country("NA");
            countryArray[152] = NAURU = new Country("NR");
            countryArray[153] = NEPAL = new Country("NP");
            countryArray[154] = NETHERLANDS = new Country("NL");
            countryArray[155] = NEW_CALEDONIA = new Country("NC");
            countryArray[156] = NEW_ZEALAND = new Country("NZ");
            countryArray[157] = NICARAGUA = new Country("NI");
            countryArray[158] = NIGER = new Country("NE");
            countryArray[159] = NIGERIA = new Country("NG");
            countryArray[160] = NIUE = new Country("NU");
            countryArray[161] = NORFOLK_ISLAND = new Country("NF");
            countryArray[162] = NORTH_KOREA = new Country("KP");
            countryArray[163] = NORTHERN_MARIANA_ISLANDS = new Country("MP");
            countryArray[164] = NORWAY = new Country("NO");
            countryArray[165] = OMAN = new Country("OM");
            countryArray[166] = PAKISTAN = new Country("PK");
            countryArray[167] = PALAU = new Country("PW");
            countryArray[168] = PALESTINIAN_TERRITORIES = new Country("PS");
            countryArray[169] = PANAMA = new Country("PA");
            countryArray[170] = PAPUA_NEW_GUINEA = new Country("PG");
            countryArray[171] = PARAGUAY = new Country("PY");
            countryArray[172] = PERU = new Country("PE");
            countryArray[173] = PHILIPPINES = new Country("PH");
            countryArray[174] = PITCAIRN_ISLANDS = new Country("PN");
            countryArray[175] = POLAND = new Country("PL");
            countryArray[176] = PORTUGAL = new Country("PT");
            countryArray[177] = PUERTO_RICO = new Country("PR");
            countryArray[178] = QATAR = new Country("QA");
            countryArray[179] = ROMANIA = new Country("RO");
            countryArray[180] = RUSSIA = new Country("RU");
            countryArray[181] = RWANDA = new Country("RW");
            countryArray[182] = REUNION = new Country("RE");
            countryArray[183] = SAMOA = new Country("WS");
            countryArray[184] = SAN_MARINO = new Country("SM");
            countryArray[185] = SAUDI_ARABIA = new Country("SA");
            countryArray[186] = SENEGAL = new Country("SN");
            countryArray[187] = SERBIA = new Country("RS");
            countryArray[188] = SEYCHELLES = new Country("SC");
            countryArray[189] = SIERRA_LEONE = new Country("SL");
            countryArray[190] = SINGAPORE = new Country("SG");
            countryArray[191] = SINT_MAARTEN = new Country("SX");
            countryArray[192] = SLOVAKIA = new Country("SK");
            countryArray[193] = SLOVENIA = new Country("SI");
            countryArray[194] = SOLOMON_ISLANDS = new Country("SB");
            countryArray[195] = SOMALIA = new Country("SO");
            countryArray[196] = SOUTH_AFRICA = new Country("ZA");
            countryArray[197] = SOUTH_GEORGIA_AND_SOUTH_SANDWICH_ISLANDS = new Country("GS");
            countryArray[198] = SOUTH_KOREA = new Country("KR");
            countryArray[199] = SOUTH_SUDAN = new Country("SS");
            countryArray[200] = SPAIN = new Country("ES");
            countryArray[201] = SRI_LANKA = new Country("LK");
            countryArray[202] = ST_BARTHELEMY = new Country("BL");
            countryArray[203] = ST_HELENA = new Country("SH");
            countryArray[204] = ST_KITTS_AND_NEVIS = new Country("KN");
            countryArray[205] = ST_LUCIA = new Country("LC");
            countryArray[206] = ST_MARTIN = new Country("MF");
            countryArray[207] = ST_PIERRE_AND_MIQUELON = new Country("PM");
            countryArray[208] = ST_VINCENT_AND_GRENADINES = new Country("VC");
            countryArray[209] = SUDAN = new Country("SD");
            countryArray[210] = SURINAME = new Country("SR");
            countryArray[211] = SVALBARD_AND_JAN_MAYEN = new Country("SJ");
            countryArray[212] = SWAZILAND = new Country("SZ");
            countryArray[213] = SWEDEN = new Country("SE");
            countryArray[214] = SWITZERLAND = new Country("CH");
            countryArray[215] = SYRIA = new Country("SY");
            countryArray[216] = SAO_TOME_AND_PRINCIPE = new Country("ST");
            countryArray[217] = TAIWAN = new Country("TW");
            countryArray[218] = TAJIKISTAN = new Country("TJ");
            countryArray[219] = TANZANIA = new Country("TZ");
            countryArray[220] = THAILAND = new Country("TH");
            countryArray[221] = TIMOR_LESTE = new Country("TL");
            countryArray[222] = TOGO = new Country("TG");
            countryArray[223] = TOKELAU = new Country("TK");
            countryArray[224] = TONGA = new Country("TO");
            countryArray[225] = TRINIDAD_AND_TOBAGO = new Country("TT");
            countryArray[226] = TUNISIA = new Country("TN");
            countryArray[227] = TURKEY = new Country("TR");
            countryArray[228] = TURKMENISTAN = new Country("TM");
            countryArray[229] = TURKS_AND_CAICOS_ISLANDS = new Country("TC");
            countryArray[230] = TUVALU = new Country("TV");
            countryArray[231] = US_OUTLYING_ISLANDS = new Country("UM");
            countryArray[232] = US_VIRGIN_ISLANDS = new Country("VI");
            countryArray[233] = UGANDA = new Country("UG");
            countryArray[234] = UKRAINE = new Country("UA");
            countryArray[235] = UNITED_ARAB_EMIRATES = new Country("AE");
            countryArray[236] = UNITED_KINGDOM = new Country("GB");
            countryArray[237] = UNITED_STATES = new Country("US");
            countryArray[238] = URUGUAY = new Country("UY");
            countryArray[239] = UZBEKISTAN = new Country("UZ");
            countryArray[240] = VANUATU = new Country("VU");
            countryArray[241] = VATICAN_CITY = new Country("VA");
            countryArray[242] = VENEZUELA = new Country("VE");
            countryArray[243] = VIETNAM = new Country("VN");
            countryArray[244] = WALLIS_AND_FUTUNA = new Country("WF");
            countryArray[245] = WESTERN_SAHARA = new Country("EH");
            countryArray[246] = YEMEN = new Country("YE");
            countryArray[247] = ZAMBIA = new Country("ZM");
            countryArray[248] = ZIMBABWE = new Country("ZW");
            $VALUES = countryArray;
        }

        protected Country(String country) {
            Intrinsics.checkParameterIsNotNull((Object)country, (String)"country");
            this.country = country;
        }

        public static Country[] values() {
            return (Country[])$VALUES.clone();
        }

        public static Country valueOf(String string) {
            return Enum.valueOf(Country.class, string);
        }
    }
}

