/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.playground;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import net.adeptropolis.frogspawn.ClusteringSettings;
import net.adeptropolis.frogspawn.clustering.Cluster;
import net.adeptropolis.frogspawn.clustering.RecursiveClustering;
import net.adeptropolis.frogspawn.clustering.postprocessing.Postprocessing;
import net.adeptropolis.frogspawn.clustering.postprocessing.PostprocessingSettings;
import net.adeptropolis.frogspawn.digest.ClusterDigester;
import net.adeptropolis.frogspawn.digest.Digest;
import net.adeptropolis.frogspawn.digest.DigestRankings;
import net.adeptropolis.frogspawn.digest.DigesterSettings;
import net.adeptropolis.frogspawn.digest.LabeledDigestMapping;
import net.adeptropolis.frogspawn.graphs.labeled.LabeledGraph;
import net.adeptropolis.frogspawn.graphs.labeled.LabeledGraphSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Playground {
    private static final Logger LOG = LoggerFactory.getLogger((String)Playground.class.getSimpleName());
    private static final Path LARGE_GRAPH = Paths.get("/home/florian/Datasets/Workbench/wiki_corenlp.filtered.graph.very_large.tsv", new String[0]);
    private static final Path MEDIUM_GRAPH = Paths.get("/home/florian/Datasets/Workbench/wiki_corenlp.filtered.graph.10M.tsv", new String[0]);
    private static final Path SMALL_GRAPH = Paths.get("/home/florian/Datasets/Workbench/wiki_corenlp.filtered.graph.small.tsv", new String[0]);
    private static final Path ENTITY_GRAPH = Paths.get("/home/florian/tmp/wiki_ents.tsv", new String[0]);
    private static final Path ENTITY_GRAPH_TERMS = Paths.get("/home/florian/tmp/wiki_ents_terms_only.norm.tsv", new String[0]);
    private static final Path NAMES_2M = Paths.get("/home/florian/Datasets/Workbench/fb_names.2M.tsv", new String[0]);
    private static final Path NAMES_20M = Paths.get("/home/florian/Datasets/Workbench/fb_names.20M.tsv", new String[0]);

    public static void main(String[] args) throws IOException {
        new Playground().namesTest();
    }

    private void namesTest() throws IOException {
        LabeledGraph<String> labeledGraph = LabeledGraphSource.fromTSV(Files.lines(NAMES_20M));
        ClusteringSettings settings = ClusteringSettings.builder().withMinVertexAffiliation(0.1).withMinClusterSize(100).build();
        Cluster root = RecursiveClustering.run(labeledGraph.getGraph(), settings);
        DigesterSettings digesterSettings = DigesterSettings.builder(settings).withDigestRanking(DigestRankings.COMBINED_RANKING.apply(0.5)).build();
        ClusterDigester digester = new ClusterDigester(digesterSettings);
        LabeledDigestMapping<String, String> mapping = (label, weight, score) -> String.format("%s <%.1f %.2f>", label, weight, score);
        this.export("/home/florian/tmp/clusters5.txt", labeledGraph, root, digester, mapping);
    }

    private void standardClustering() throws IOException {
        LabeledGraph<String> labeledGraph = LabeledGraphSource.fromTSV(Files.lines(ENTITY_GRAPH_TERMS));
        ClusteringSettings settings = ClusteringSettings.builder().withMinVertexAffiliation(0.1).withMinClusterSize(100).build();
        Cluster root = RecursiveClustering.run(labeledGraph.getGraph(), settings);
        PostprocessingSettings postprocessingSettings = PostprocessingSettings.builder(settings).withMinChildren(15).build();
        Postprocessing.apply(root, postprocessingSettings);
        DigesterSettings digesterSettings = DigesterSettings.builder(settings).withDigestRanking(DigestRankings.COMBINED_RANKING.apply(1.2)).build();
        ClusterDigester digester = new ClusterDigester(digesterSettings);
        LabeledDigestMapping<String, String> mapping = (label, weight, score) -> String.format("%s <%.1f %.2f>", label, weight, score);
        this.export("/home/florian/tmp/clusters4.txt", labeledGraph, root, digester, mapping);
    }

    private void export(String path, LabeledGraph<String> labeledGraph, Cluster root, ClusterDigester digester, LabeledDigestMapping<String, String> mapping) throws FileNotFoundException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        PrintWriter w = new PrintWriter(path);
        root.traverse(cluster -> {
            Digest digest = digester.digest((Cluster)cluster);
            String vertices = digest.map(mapping, (String[])labeledGraph.getLabels()).collect(Collectors.joining(", "));
            String prefix = StringUtils.repeat((String)"==", (int)cluster.depth());
            double totalWeight = cluster.aggregateGraph().totalWeight();
            w.printf("%s> %d / %.3f: %s\n", prefix, digest.totalSize(), totalWeight, vertices);
        });
        w.close();
        stopWatch.stop();
        LOG.info("Output creation finished after {}", (Object)stopWatch);
    }
}

