/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.helpers;

import com.google.common.base.Preconditions;

public class Vectors {
    private Vectors() {
    }

    public static double norm2(double[] v) {
        double norm = 0.0;
        for (double value : v) {
            norm += value * value;
        }
        return Math.sqrt(norm);
    }

    public static double scalarProduct(double[] v, double[] w) {
        Preconditions.checkArgument((v.length == w.length ? 1 : 0) != 0);
        double prod = 0.0;
        for (int i = 0; i < v.length; ++i) {
            prod += v[i] * w[i];
        }
        return prod;
    }

    public static void normalize2(double[] v) {
        double scale = 1.0 / Vectors.norm2(v);
        for (int i = 0; i < v.length; ++i) {
            v[i] = v[i] * scale;
        }
    }

    public static void normalize2Sig(double[] v) {
        double sig = v[0] != 0.0 ? Math.signum(v[0]) : 1.0;
        double scale = 1.0 / Vectors.norm2(v);
        for (int i = 0; i < v.length; ++i) {
            v[i] = sig * v[i] * scale;
        }
    }
}

