/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.graphs.traversal;

import java.util.concurrent.CountDownLatch;
import net.adeptropolis.frogspawn.graphs.Graph;
import net.adeptropolis.frogspawn.graphs.traversal.ParallelOps;
import net.adeptropolis.frogspawn.graphs.traversal.ParallelOpsException;
import net.adeptropolis.frogspawn.graphs.traversal.VertexConsumer;

public final class ParallelVertexOps
extends ParallelOps
implements Runnable {
    private final VertexConsumer consumer;

    private ParallelVertexOps(Graph graph, VertexConsumer consumer, int slice, CountDownLatch latch) {
        super(graph, slice, latch);
        this.consumer = consumer;
    }

    public static void traverse(Graph graph, VertexConsumer consumer) {
        if (graph.order() >= 128) {
            ParallelVertexOps.traverseParallel(graph, consumer);
        } else {
            for (int i = 0; i < graph.order(); ++i) {
                consumer.accept(i);
            }
        }
    }

    private static void traverseParallel(Graph graph, VertexConsumer consumer) {
        CountDownLatch latch = new CountDownLatch(THREAD_POOL_SIZE);
        for (int i = 0; i < THREAD_POOL_SIZE; ++i) {
            EXECUTOR.submit(new ParallelVertexOps(graph, consumer, i, latch));
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ParallelOpsException(e);
        }
    }

    @Override
    public void run() {
        int v;
        int i = 0;
        while ((v = i * THREAD_POOL_SIZE + this.slice) < this.graph.order()) {
            this.consumer.accept(v);
            ++i;
        }
        this.latch.countDown();
    }
}

