/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.graphs.traversal;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.adeptropolis.frogspawn.graphs.Graph;
import net.adeptropolis.frogspawn.graphs.traversal.ParallelOpsException;

abstract class ParallelOps {
    static final int PARALLELIZATION_THRESHOLD = 128;
    static final int THREAD_POOL_SIZE = Runtime.getRuntime().availableProcessors();
    static final ThreadPoolExecutor EXECUTOR = new ThreadPoolExecutor(THREAD_POOL_SIZE, THREAD_POOL_SIZE, Long.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadOps());
    final Graph graph;
    final int slice;
    final CountDownLatch latch;

    ParallelOps(Graph graph, int slice, CountDownLatch latch) {
        this.graph = graph;
        this.slice = slice;
        this.latch = latch;
    }

    static class DaemonThreadOps
    implements ThreadFactory,
    Thread.UncaughtExceptionHandler {
        private final AtomicInteger threadId = new AtomicInteger();

        DaemonThreadOps() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, String.format("worker-thread-%d", this.threadId.getAndIncrement()));
            thread.setDaemon(true);
            thread.setPriority(5);
            thread.setUncaughtExceptionHandler(this);
            return thread;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            throw new ParallelOpsException(throwable);
        }
    }
}

