/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.graphs.traversal;

import java.util.concurrent.CountDownLatch;
import net.adeptropolis.frogspawn.graphs.Graph;
import net.adeptropolis.frogspawn.graphs.traversal.EdgeConsumer;
import net.adeptropolis.frogspawn.graphs.traversal.ParallelOps;
import net.adeptropolis.frogspawn.graphs.traversal.ParallelOpsException;

public final class ParallelEdgeOps
extends ParallelOps
implements Runnable {
    private final EdgeConsumer consumer;

    private ParallelEdgeOps(Graph graph, EdgeConsumer consumer, int slice, CountDownLatch latch) {
        super(graph, slice, latch);
        this.consumer = consumer;
    }

    public static void traverse(Graph graph, EdgeConsumer consumer) {
        if (graph.order() >= 128) {
            ParallelEdgeOps.traverseParallel(graph, consumer);
        } else {
            for (int i = 0; i < graph.order(); ++i) {
                graph.traverseIncidentEdges(i, consumer);
            }
        }
    }

    private static void traverseParallel(Graph graph, EdgeConsumer consumer) {
        CountDownLatch latch = new CountDownLatch(THREAD_POOL_SIZE);
        for (int i = 0; i < THREAD_POOL_SIZE; ++i) {
            EXECUTOR.submit(new ParallelEdgeOps(graph, consumer, i, latch));
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ParallelOpsException(e);
        }
    }

    @Override
    public void run() {
        int v;
        int i = 0;
        while ((v = i * THREAD_POOL_SIZE + this.slice) < this.graph.order()) {
            this.graph.traverseIncidentEdges(v, this.consumer);
            ++i;
        }
        this.latch.countDown();
    }
}

